/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.CSVUtil;
import org.ttzero.excel.util.FileUtil;

public class CSVSheet
extends Sheet {
    protected Path path;
    protected CSVUtil.RowsIterator iterator;
    protected boolean shouldClean;
    protected Charset charset;
    protected char delimiter = (char)44;

    public CSVSheet() {
    }

    public CSVSheet(Path path) {
        this.path = path;
    }

    public CSVSheet(String name, Path path) {
        super(name);
        this.path = path;
    }

    public CSVSheet(InputStream is) throws IOException {
        this(null, is);
    }

    public CSVSheet(String name, InputStream is) throws IOException {
        super(name);
        this.path = Files.createTempFile("eec+", String.valueOf(this.id), new FileAttribute[0]);
        Files.copy(is, this.path, StandardCopyOption.REPLACE_EXISTING);
        this.shouldClean = true;
    }

    public CSVSheet(Reader reader) throws IOException {
        this(null, reader);
    }

    public CSVSheet(String name, Reader reader) throws IOException {
        super(name);
        this.path = Files.createTempFile("eec+", String.valueOf(this.id), new FileAttribute[0]);
        this.shouldClean = true;
        char[] chars = new char[8192];
        try (BufferedWriter bw = Files.newBufferedWriter(this.path, new OpenOption[0]);){
            int n;
            while ((n = reader.read(chars)) > 0) {
                bw.write(chars, 0, n);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.shouldClose) {
            this.iterator.close();
            if (this.shouldClean) {
                FileUtil.rm_rf(this.path);
            }
        }
        super.close();
    }

    private void init() throws IOException {
        assert (this.path != null && FileUtil.exists(this.path));
        this.iterator = CSVUtil.newReader(this.path, this.delimiter, this.charset).sharedIterator();
    }

    @Override
    protected void resetBlockData() {
        int len = this.columns.length;
        int n = 0;
        int limit = this.getRowLimit();
        boolean hasNext = true;
        int rbs = this.rowBlock.capacity();
        while (n++ < rbs && this.rows < limit && (hasNext = this.iterator.hasNext())) {
            Row row = this.rowBlock.next();
            row.index = this.rows;
            Cell[] cells = row.realloc(len);
            String[] csvRow = this.iterator.next();
            for (int i = 0; i < len; ++i) {
                Column hc = this.columns[i];
                Cell cell = cells[i];
                cell.clear();
                cell.setString(csvRow[i]);
                cell.xf = this.cellValueAndStyle.getStyleIndex(row, hc, csvRow[i]);
            }
            ++this.rows;
        }
        if (this.rows >= limit) {
            this.shouldClose = false;
            this.rowBlock.markEOF();
            CSVSheet copy = (CSVSheet)this.getClass().cast(this.clone());
            copy.shouldClose = true;
            this.workbook.insertSheet(this.id, copy);
        } else if (!hasNext) {
            this.rowBlock.markEOF();
        }
    }

    @Override
    protected Column[] getHeaderColumns() {
        if (this.headerReady) {
            return this.columns;
        }
        try {
            this.init();
            if (!this.iterator.hasNext()) {
                return this.columns;
            }
            String[] rows = this.iterator.next();
            this.columns = new Column[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                this.columns[i] = new Column(this.getNonHeader() != 1 ? rows[i] : null, String.class);
                this.columns[i].styles = this.workbook.getStyles();
            }
        }
        catch (IOException e) {
            throw new ExcelWriteException(e);
        }
        return this.columns;
    }

    @Override
    public void checkColumnLimit() {
        super.checkColumnLimit();
        if (this.getNonHeader() == 1) {
            ((CSVUtil.SharedRowsIterator)this.iterator).retain();
        }
    }

    @Override
    protected void mergeHeaderCellsIfEquals() {
    }

    public CSVSheet setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public CSVSheet setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }
}

