/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import org.ttzero.excel.drawing.Effect;
import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.style.Border;
import org.ttzero.excel.entity.style.ColorIndex;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.NumFmt;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.processor.ConversionProcessor;
import org.ttzero.excel.processor.Converter;
import org.ttzero.excel.processor.StyleProcessor;

public class Column {
    public static final Column UNALLOCATED_COLUMN = new Column();
    public String key;
    public String name;
    public Class<?> clazz;
    public ConversionProcessor processor;
    public Converter<?> converter;
    public StyleProcessor styleProcessor;
    public Integer cellStyle;
    public Integer headerStyle;
    public int cellStyleIndex = -1;
    public int headerStyleIndex = -1;
    public int globalStyleIndex = -1;
    public double width = -1.0;
    public double headerHeight = -1.0;
    public Styles styles;
    public Comment headerComment;
    public Comment cellComment;
    public NumFmt numFmt;
    public int colIndex = -1;
    public Column prev;
    public Column next;
    public Column tail;
    public int realColIndex;
    protected int option;
    public Effect effect;
    public Font font;
    public Fill fill;
    public Border border;

    public Column() {
    }

    public Column(String name) {
        this.name = name;
    }

    public Column(String name, Class<?> clazz) {
        this(name, clazz, false);
    }

    public Column(String name, String key) {
        this(name, key, false);
    }

    public Column(String name, String key, Class<?> clazz) {
        this(name, key, false);
        this.clazz = clazz;
    }

    public Column(String name, Class<?> clazz, ConversionProcessor processor) {
        this(name, clazz, processor, false);
    }

    public Column(String name, String key, ConversionProcessor processor) {
        this(name, key, processor, false);
    }

    public Column(String name, Class<?> clazz, boolean share) {
        this.name = name;
        this.clazz = clazz;
        this.setShare(share);
    }

    public Column(String name, String key, boolean share) {
        this.name = name;
        this.key = key;
        this.setShare(share);
    }

    public Column(String name, Class<?> clazz, ConversionProcessor processor, boolean share) {
        this(name, clazz, share);
        this.processor = processor;
    }

    public Column(String name, String key, Class<?> clazz, ConversionProcessor processor) {
        this(name, key, clazz);
        this.processor = processor;
    }

    public Column(String name, String key, ConversionProcessor processor, boolean share) {
        this(name, key, share);
        this.processor = processor;
    }

    public Column(String name, Class<?> clazz, int cellStyle) {
        this(name, clazz, cellStyle, true);
    }

    public Column(String name, String key, int cellStyle) {
        this(name, key, cellStyle, true);
    }

    public Column(String name, Class<?> clazz, int cellStyle, boolean share) {
        this(name, clazz, share);
        this.cellStyle = cellStyle;
    }

    public Column(String name, String key, int cellStyle, boolean share) {
        this(name, key, share);
        this.cellStyle = cellStyle;
    }

    public Column(Column other) {
        this.from(other);
        if (other.next != null) {
            this.addSubColumn(new Column(other.next));
        }
    }

    public Column from(Column other) {
        int i;
        this.key = other.key;
        this.name = other.name;
        this.clazz = other.clazz;
        this.processor = other.processor;
        this.converter = other.converter;
        this.styleProcessor = other.styleProcessor;
        this.width = other.width;
        this.headerHeight = other.headerHeight;
        this.styles = other.styles;
        this.headerComment = other.headerComment;
        this.cellComment = other.cellComment;
        this.numFmt = other.numFmt;
        this.font = other.font;
        this.border = other.border;
        this.fill = other.fill;
        this.colIndex = other.colIndex;
        this.option = other.option;
        this.realColIndex = other.realColIndex;
        if (other.cellStyle != null) {
            this.setCellStyle(other.cellStyle);
        }
        if (other.headerStyle != null) {
            this.setHeaderStyle(other.headerStyle);
        }
        if ((i = other.getHeaderStyleIndex()) > 0) {
            this.headerStyleIndex = i;
        }
        if ((i = other.getCellStyleIndex()) > 0) {
            this.cellStyleIndex = i;
        }
        this.effect = other.effect;
        return this;
    }

    public Column setWidth(double width) {
        if (width < 0.0) {
            throw new ExcelWriteException("Width " + width + " less than 0.");
        }
        this.width = width;
        return this;
    }

    public Column setHeaderHeight(double headerHeight) {
        if (headerHeight < 0.0) {
            throw new ExcelWriteException("Height " + headerHeight + " less than 0.");
        }
        this.headerHeight = headerHeight;
        return this;
    }

    public boolean isShare() {
        return (this.option >> 5 & 1) == 1;
    }

    public String getName() {
        return this.name;
    }

    public Column setName(String name) {
        this.name = name;
        return this;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Column setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public Column setProcessor(ConversionProcessor processor) {
        this.processor = processor;
        return this;
    }

    public Column setStyleProcessor(StyleProcessor styleProcessor) {
        if (styleProcessor != null && !StyleProcessor.None.class.isAssignableFrom(styleProcessor.getClass())) {
            this.styleProcessor = styleProcessor;
        }
        return this;
    }

    public ConversionProcessor getConversion() {
        return this.processor != null ? this.processor : this.converter;
    }

    public Column setConverter(Converter<?> converter) {
        if (converter != null && !Converter.None.class.isAssignableFrom(converter.getClass())) {
            this.converter = converter;
        }
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public Column setCellStyle(int cellStyle) {
        this.cellStyle = cellStyle;
        if (this.styles != null) {
            this.cellStyleIndex = this.styles.of(cellStyle);
        }
        return this;
    }

    public Column setHeaderStyle(int headerStyle) {
        this.headerStyle = headerStyle;
        if (this.styles != null) {
            this.headerStyleIndex = this.styles.of(headerStyle);
        }
        return this;
    }

    public Column setColIndex(int colIndex) {
        this.colIndex = colIndex;
        return this;
    }

    public int getCellStyleIndex() {
        return this.cellStyleIndex >= 0 ? this.cellStyleIndex : (this.cellStyleIndex = this.styles != null && this.cellStyle != null ? this.styles.of(this.cellStyle) : -1);
    }

    public int getHeaderStyleIndex() {
        return this.headerStyleIndex >= 0 ? this.headerStyleIndex : (this.headerStyleIndex = this.styles != null && this.headerStyle != null ? this.styles.of(this.headerStyle) : -1);
    }

    public Column setFont(Font font) {
        this.font = font;
        return this;
    }

    public Column setFill(Fill fill) {
        this.fill = fill;
        return this;
    }

    public Column setBorder(Border border) {
        this.border = border;
        return this;
    }

    public Column setVertical(int vertical) {
        this.option = this.option & 0xFFFFFCFF | (vertical >> 4 & 3) << 8;
        return this;
    }

    public Column setHorizontal(int horizontal) {
        this.option = this.option & 0xFFFFE3FF | (horizontal >> 1 & 7) << 10;
        return this;
    }

    public Column setShare(boolean share) {
        this.option = share ? (this.option |= 0x20) : (this.option &= 0xFFFFFFDF);
        return this;
    }

    public Column setNumFmt(String code) {
        this.numFmt = new NumFmt(code);
        return this;
    }

    public Column setNumFmt(NumFmt numFmt) {
        this.numFmt = numFmt;
        return this;
    }

    public NumFmt getNumFmt() {
        return this.numFmt != null ? this.numFmt : (this.cellStyle != null ? (this.numFmt = this.styles.getNumFmt(this.cellStyle)) : null);
    }

    protected int getCellStyle(Class<?> clazz) {
        int style;
        if (IWorksheetWriter.isString(clazz)) {
            style = Styles.defaultStringBorderStyle();
        } else if (IWorksheetWriter.isDateTime(clazz) || IWorksheetWriter.isDate(clazz) || IWorksheetWriter.isLocalDateTime(clazz)) {
            if (this.numFmt == null) {
                this.numFmt = NumFmt.DATETIME_FORMAT;
            }
            style = 262214;
        } else if (IWorksheetWriter.isBool(clazz) || IWorksheetWriter.isChar(clazz)) {
            style = Styles.clearHorizontal(Styles.defaultStringBorderStyle()) | 6;
        } else if (IWorksheetWriter.isInt(clazz) || IWorksheetWriter.isLong(clazz)) {
            style = Styles.defaultIntBorderStyle();
        } else if (IWorksheetWriter.isFloat(clazz) || IWorksheetWriter.isDouble(clazz) || IWorksheetWriter.isBigDecimal(clazz)) {
            style = Styles.defaultDoubleBorderStyle();
        } else if (IWorksheetWriter.isLocalDate(clazz)) {
            if (this.numFmt == null) {
                this.numFmt = NumFmt.DATE_FORMAT;
            }
            style = 262214;
        } else if (IWorksheetWriter.isTime(clazz) || IWorksheetWriter.isLocalTime(clazz)) {
            if (this.numFmt == null) {
                this.numFmt = NumFmt.TIME_FORMAT;
            }
            style = 262214;
        } else {
            style = 262208;
        }
        return style;
    }

    public int getCellStyle() {
        int h;
        int v;
        if (this.cellStyle != null) {
            return this.cellStyle;
        }
        int style = this.getCellStyle(this.clazz);
        if (this.font != null) {
            style = this.styles.modifyFont(style, this.font);
        }
        if (this.getColumnType() == 2) {
            Font font = this.styles.getFont(style).clone();
            font.setStyle(0).underline();
            font.setColor(ColorIndex.themeColors[10]);
            style = this.styles.modifyFont(style, font);
        }
        if (this.numFmt != null) {
            style = this.styles.modifyNumFmt(style, this.numFmt);
        }
        if (this.border != null) {
            style = this.styles.modifyBorder(style, this.border);
        }
        if (this.fill != null) {
            style = this.styles.modifyFill(style, this.fill);
        }
        if ((v = (this.option >>> 8 & 3) << 4) > 0) {
            style = this.styles.modifyVertical(style, v);
        }
        if ((h = (this.option >>> 10 & 7) << 1) > 0) {
            style = this.styles.modifyHorizontal(style, h);
        }
        this.setCellStyle(style |= this.option & 1);
        return style;
    }

    public boolean isIgnoreValue() {
        return (this.option >> 3 & 1) == 1;
    }

    public Column ignoreValue() {
        this.option |= 8;
        return this;
    }

    public Column setWrapText(boolean wrapText) {
        this.option = wrapText ? (this.option |= 1) : this.option >>> 1 << 1;
        return this;
    }

    public Column setHeaderComment(Comment headerComment) {
        this.headerComment = headerComment;
        return this;
    }

    public Column addSubColumn(Column column) {
        if (this == column) {
            return this;
        }
        if (this.next != null) {
            int appendSize;
            int subSize = this.subColumnSize();
            if (subSize + (appendSize = column.subColumnSize()) > 1024) {
                throw new ExcelWriteException("Too many sub-column occur. Max support 1024, current is " + subSize);
            }
            column.prev = this.tail;
            this.tail.next = column;
        } else {
            this.next = column;
            column.prev = this;
        }
        this.tail = column.tail != null ? column.tail : column;
        return this;
    }

    public int subColumnSize() {
        int i = 1;
        if (this.next != null) {
            Column next = this.next;
            while (next != this.tail) {
                next = next.next;
                ++i;
            }
            ++i;
        }
        return i;
    }

    public Column[] toArray() {
        int len = this.subColumnSize();
        Column[] dist = new Column[len];
        if (len < 1) {
            return dist;
        }
        Column e = this;
        for (int i = 0; i < len; ++i) {
            dist[i] = e;
            e = e.next;
        }
        return dist;
    }

    public int getRealColIndex() {
        return this.realColIndex;
    }

    public boolean isHide() {
        return (this.option >> 4 & 1) == 1;
    }

    public Column hide() {
        this.option |= 0x10;
        return this;
    }

    public Column show() {
        this.option &= 0xFFFFFFEF;
        return this;
    }

    public Column getTail() {
        return this.tail != null ? this.tail : this;
    }

    public Column autoSize() {
        this.option |= 2;
        return this;
    }

    public Column fixedSize(double width) {
        this.option |= 4;
        this.width = width;
        return this;
    }

    public int getAutoSize() {
        return this.option >> 1 & 3;
    }

    public Column writeAsDefault() {
        this.option &= 0xFFFFFF3F;
        return this;
    }

    public Column writeAsMedia() {
        this.option = this.option & 0xFFFFFF3F | 0x40;
        return this;
    }

    public int getColumnType() {
        return this.option >> 6 & 3;
    }

    public Column setEffect(Effect effect) {
        this.effect = effect;
        return this;
    }

    public Effect getEffect() {
        return this.effect;
    }

    public Column writeAsHyperlink() {
        this.option = this.option & 0xFFFFFF3F | 0x80;
        return this;
    }
}

