/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.entity.style.NumFmt;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Cell;

public class SimpleSheet<T>
extends ListSheet<T> {
    protected int type = -1;
    protected boolean firstRowAsHeader;
    protected static final Column UNALLOCATED_COLUMN = new Column();

    public SimpleSheet() {
    }

    public SimpleSheet(String name) {
        super(name);
    }

    public SimpleSheet(Column ... columns) {
        super(columns);
    }

    public SimpleSheet(String name, Column ... columns) {
        super(name, columns);
    }

    public SimpleSheet(String name, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
    }

    public SimpleSheet(List<T> data) {
        super(data);
    }

    public SimpleSheet(String name, List<T> data) {
        super(name, data);
    }

    public SimpleSheet(List<T> data, Column ... columns) {
        super(data, columns);
    }

    public SimpleSheet(String name, List<T> data, Column ... columns) {
        super(name, data, columns);
    }

    public SimpleSheet(List<T> data, WaterMark waterMark, Column ... columns) {
        super(data, waterMark, columns);
    }

    public SimpleSheet(String name, List<T> data, WaterMark waterMark, Column ... columns) {
        super(name, data, waterMark, columns);
    }

    public SimpleSheet<T> setHeader(List<String> header) {
        Column[] columns;
        if (header == null || header.isEmpty()) {
            columns = new Column[]{};
        } else {
            columns = new Column[header.size()];
            int i = 0;
            int len = header.size();
            while (i < len) {
                columns[i] = new Column(header.get(i++)).setCellStyle(0);
            }
        }
        super.setColumns(columns);
        return this;
    }

    public SimpleSheet<T> setHeader(String ... header) {
        return this.setHeader(Arrays.asList(header));
    }

    public SimpleSheet<T> firstRowAsHeader() {
        this.firstRowAsHeader = true;
        return this;
    }

    @Override
    public Column[] getHeaderColumns() {
        Object o = this.getFirst();
        if (o == null) {
            this.type = 0;
        } else if (List.class.isAssignableFrom(o.getClass())) {
            this.type = 1;
            if (this.firstRowAsHeader) {
                List row0 = (List)o;
                this.columns = new Column[row0.size()];
                int i = 0;
                for (Object e : row0) {
                    this.columns[i++] = new Column(e.toString()).setCellStyle(0);
                }
                ++this.start;
            }
        } else if (o.getClass().isArray()) {
            this.type = 2;
            if (this.firstRowAsHeader) {
                int len = Array.getLength(o);
                this.columns = new Column[len];
                for (int i = 0; i < len; ++i) {
                    this.columns[i] = new Column(Array.get(o, i).toString()).setCellStyle(0);
                }
                ++this.start;
            }
        } else {
            this.type = 3;
            return super.getHeaderColumns();
        }
        if (this.columns == null) {
            this.columns = new Column[0];
            this.headerReady = true;
            this.ignoreHeader();
            this.setHeaderRowHeight(-1.0);
        }
        SimpleSheet.UNALLOCATED_COLUMN.styles = this.workbook.getStyles();
        SimpleSheet.UNALLOCATED_COLUMN.cellStyle = 0;
        return this.columns;
    }

    @Override
    protected void resetBlockData() {
        if (this.type == 3) {
            super.resetBlockData();
            return;
        }
        if (!this.eof && this.left() < this.rowBlock.capacity()) {
            this.append();
        }
        int end = this.getEndIndex();
        while (this.start < end) {
            List sub;
            Row row = this.rowBlock.next();
            row.index = this.rows;
            Object o = this.data.get(this.start);
            boolean isNull = o == null;
            List list = sub = !isNull && this.type == 1 ? (List)o : null;
            int len = !isNull ? (this.type == 1 ? sub.size() : Array.getLength(o)) : 0;
            Cell[] cells = row.realloc(len);
            for (int i = 0; i < len; ++i) {
                Column column;
                Cell cell = cells[i];
                cell.clear();
                Object e = null;
                Column column2 = column = i < this.columns.length ? this.columns[i] : UNALLOCATED_COLUMN;
                if (!column.isIgnoreValue()) {
                    e = this.type == 1 ? (Object)sub.get(i) : Array.get(o, i);
                }
                column.clazz = null;
                this.cellValueAndStyle.reset(row, cell, e, column);
                if (cell.t != 'i' && cell.t != 'a' && cell.t != 't') continue;
                SimpleSheet.datetimeCell(this.workbook.getStyles(), cell);
            }
            row.height = this.getRowHeight();
            ++this.rows;
            ++this.start;
        }
    }

    protected static void datetimeCell(Styles styles, Cell cell) {
        SimpleSheet.defaultDatetimeCell(styles, cell);
    }

    @Override
    public RowBlock nextBlock() {
        this.rowBlock.clear();
        this.resetBlockData();
        return this.rowBlock.flip();
    }

    @Override
    public double getDefaultWidth() {
        return this.type <= 2 ? 10.16 : super.getDefaultWidth();
    }

    public static void defaultDatetimeCell(Styles styles, Cell cell) {
        if (styles.isDate(cell.xf)) {
            return;
        }
        int style = styles.getStyleByIndex(cell.xf);
        switch (cell.t) {
            case 'i': {
                style = styles.modifyNumFmt(style, NumFmt.DATETIME_FORMAT);
                break;
            }
            case 'a': {
                style = styles.modifyNumFmt(style, NumFmt.DATE_FORMAT);
                break;
            }
            case 't': {
                style = styles.modifyNumFmt(style, NumFmt.TIME_FORMAT);
            }
        }
        if (!Styles.hasHorizontal(style)) {
            style |= 6;
        }
        cell.xf = styles.of(style);
    }
}

