/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.e7;

import java.awt.Color;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import org.ttzero.excel.drawing.Bevel;
import org.ttzero.excel.drawing.Camera;
import org.ttzero.excel.drawing.Effect;
import org.ttzero.excel.drawing.Enums;
import org.ttzero.excel.drawing.Fill;
import org.ttzero.excel.drawing.Glow;
import org.ttzero.excel.drawing.LightRig;
import org.ttzero.excel.drawing.Outline;
import org.ttzero.excel.drawing.Reflection;
import org.ttzero.excel.drawing.Scene3D;
import org.ttzero.excel.drawing.Shadow;
import org.ttzero.excel.drawing.Shape3D;
import org.ttzero.excel.entity.IDrawingsWriter;
import org.ttzero.excel.entity.Picture;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.style.ColorIndex;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.manager.docProps.Tuple2;
import org.ttzero.excel.util.ExtBufferedWriter;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={"xdr", "a", "r"}, value="wsDr", uri={"http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing", "http://schemas.openxmlformats.org/drawingml/2006/main", "http://schemas.openxmlformats.org/officeDocument/2006/relationships"})
public class XMLDrawingsWriter
implements IDrawingsWriter {
    protected Path path;
    protected ExtBufferedWriter bw;
    protected int size;
    protected RelManager relManager;
    protected Picture[] pictures;
    protected long[] bits;
    protected int countDown;
    static final String[] ANCHOR_PROPERTY = new String[]{"twoCell", "oneCell", "absolute"};

    public XMLDrawingsWriter(Path path) {
        this.path = path;
        this.relManager = new RelManager();
        try {
            if (!FileUtil.exists(path.getParent())) {
                FileUtil.mkdir(path.getParent());
            }
            this.bw = new ExtBufferedWriter(Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));
            this.bw.write("<xdr:wsDr xmlns:xdr=\"http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing\" xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
        }
        catch (IOException e) {
            throw new RuntimeException("Create XMLDrawingsWriter error", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.bw == null) {
            return;
        }
        if (this.countDown > 0) {
            int counter = 30;
            while (this.checkComplete() != 0) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (--counter >= 0) continue;
            }
        }
        this.bw.write("</xdr:wsDr>");
        this.relManager.write(this.path.getParent(), this.path.getFileName().toString());
        FileUtil.close(this.bw);
        this.bw = null;
    }

    @Override
    public void writeTo(Path root) throws IOException {
    }

    @Override
    public void drawing(Picture picture) throws IOException {
        if (StringUtil.isEmpty(picture.picName)) {
            return;
        }
        Relationship picRel = this.relManager.add(new Relationship("../media/" + picture.picName, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image"));
        ++this.size;
        int cellAnchor = picture.property >> 2 & 3;
        int editAs = picture.property & 3;
        if (cellAnchor == 1) {
            this.bw.write("<xdr:oneCellAnchor>");
        } else {
            this.bw.write("<xdr:twoCellAnchor editAs=\"");
            this.bw.write(ANCHOR_PROPERTY[editAs]);
            this.bw.write("\">");
        }
        this.bw.write("<xdr:from><xdr:col>");
        this.bw.writeInt(picture.col);
        this.bw.write("</xdr:col><xdr:colOff>");
        this.bw.writeInt(picture.padding[3] * 12700);
        this.bw.write("</xdr:colOff><xdr:row>");
        this.bw.writeInt(picture.row);
        this.bw.write("</xdr:row><xdr:rowOff>");
        this.bw.writeInt(picture.padding[0] * 12700);
        this.bw.write("</xdr:rowOff></xdr:from>");
        if (cellAnchor == 1) {
            this.bw.write("<xdr:ext cx=\"");
            this.bw.writeInt(picture.padding[1] * 12700);
            this.bw.write("\" cy=\"");
            this.bw.writeInt(picture.padding[2] * 12700);
            this.bw.write("\"/>");
        } else {
            this.bw.write("<xdr:to><xdr:col>");
            this.bw.writeInt(Math.max(picture.col, picture.toCol));
            this.bw.write("</xdr:col><xdr:colOff>");
            this.bw.writeInt(picture.padding[1] * 12700);
            this.bw.write("</xdr:colOff><xdr:row>");
            this.bw.writeInt(Math.max(picture.row, picture.toRow));
            this.bw.write("</xdr:row><xdr:rowOff>");
            this.bw.writeInt(picture.padding[2] * 12700);
            this.bw.write("</xdr:rowOff></xdr:to>");
        }
        this.bw.write("<xdr:pic><xdr:nvPicPr><xdr:cNvPr id=\"");
        this.bw.writeInt(this.size);
        this.bw.write("\" name=\"Picture ");
        this.bw.writeInt(this.size);
        this.bw.write("\"/><xdr:cNvPicPr><a:picLocks noChangeAspect=\"1\"/></xdr:cNvPicPr></xdr:nvPicPr>");
        this.bw.write("<xdr:blipFill><a:blip r:embed=\"");
        this.bw.write(picRel.getId());
        this.bw.write("\"/>");
        this.bw.write("<a:stretch><a:fillRect/></a:stretch></xdr:blipFill>");
        this.bw.write("<xdr:spPr>");
        if (picture.revolve != 0) {
            this.bw.write("<a:xfrm rot=\"");
            this.bw.writeInt(60000 * picture.revolve);
            this.bw.write("\"/>");
        }
        if (picture.effect == null) {
            this.bw.write("<a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom>");
        } else {
            this.writeEffects(picture);
        }
        this.bw.write("</xdr:spPr>");
        this.bw.write("</xdr:pic><xdr:clientData/></xdr:");
        if (cellAnchor == 1) {
            this.bw.write("oneCellAnchor>");
        } else {
            this.bw.write("twoCellAnchor>");
        }
    }

    @Override
    public void asyncDrawing(Picture picture) throws IOException {
        int freeIndex;
        if (this.pictures == null) {
            this.bits = new long[2];
            this.pictures = new Picture[this.bits.length << 6];
        }
        if ((freeIndex = XMLDrawingsWriter.getFreeIndex(this.bits)) < 0) {
            freeIndex = this.bits.length << 6;
            this.bits = Arrays.copyOf(this.bits, this.bits.length + 2);
            this.pictures = Arrays.copyOf(this.pictures, this.bits.length << 6);
        } else if (this.pictures[freeIndex] != null) {
            this.drawing(this.pictures[freeIndex]);
            --this.countDown;
        }
        picture.idx = freeIndex;
        this.pictures[freeIndex] = picture;
        XMLDrawingsWriter.markIndex(this.bits, freeIndex);
        ++this.countDown;
    }

    @Override
    public void complete(Picture picture) {
        if (this.bits == null) {
            return;
        }
        XMLDrawingsWriter.freeIndex(this.bits, picture.idx);
    }

    protected int checkComplete() throws IOException {
        Picture p;
        int i;
        while (this.countDown > 0 && (i = XMLDrawingsWriter.getFreeIndex(this.bits)) >= 0 && (p = this.pictures[i]) != null) {
            this.drawing(p);
            XMLDrawingsWriter.markIndex(this.bits, i);
            --this.countDown;
        }
        return this.countDown;
    }

    public static int getFreeIndex(long[] bits) {
        int i;
        int idx = 64;
        for (i = 0; i < bits.length && (idx = Long.numberOfTrailingZeros(Long.highestOneBit(bits[i] ^ 0xFFFFFFFFFFFFFFFFL))) == 64; ++i) {
        }
        return idx < 64 ? (i << 6) + (64 - idx - 1) : -1;
    }

    public static synchronized void markIndex(long[] bits, int idx) {
        int n = idx >> 6;
        bits[n] = bits[n] | 1L << 63 - (idx - (idx >>> 6 << 6));
    }

    public static synchronized void freeIndex(long[] bits, int idx) {
        int n = idx >> 6;
        bits[n] = bits[n] & (1L << 63 - (idx - (idx >>> 6 << 6)) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    protected void writeEffects(Picture pict) throws IOException {
        boolean hasGlow;
        Effect effect = pict.effect;
        this.bw.write("<a:prstGeom prst=\"");
        this.bw.write(effect.geometry != null ? effect.geometry.name() : Enums.ShapeType.rect.name());
        if (effect.geometryAdjustValueList != null && !effect.geometryAdjustValueList.isEmpty()) {
            this.bw.write("\"><a:avLst>");
            for (Tuple2<String, String> guide : effect.geometryAdjustValueList) {
                this.bw.write("<a:gd name=\"");
                this.bw.write((String)guide.v1);
                this.bw.write("\" fmla=\"");
                this.bw.write((String)guide.v2);
                this.bw.write("\"/>");
            }
            this.bw.write("</a:avLst></a:prstGeom>");
        } else {
            this.bw.write("\"><a:avLst/></a:prstGeom>");
        }
        if (effect.fill != null) {
            this.attachFill(effect.fill);
        }
        if (effect.outline != null && effect.outline.width > 0.0) {
            this.attachOutline(effect.outline);
        }
        boolean hasShadow = effect.shadow != null && effect.shadow.size > 0.0;
        boolean hasInnerShadow = effect.innerShadow != null;
        boolean hasReflection = effect.reflection != null;
        boolean hasSoftEdges = effect.softEdges > 0.0;
        boolean bl = hasGlow = effect.glow != null;
        if (hasShadow || hasInnerShadow || hasReflection || hasSoftEdges || hasGlow) {
            this.bw.write("<a:effectLst>");
            if (hasGlow) {
                this.attachGlow(effect.glow);
            }
            if (hasShadow) {
                this.attachShadow(effect.shadow, "outerShdw");
            }
            if (hasInnerShadow) {
                this.attachShadow(effect.innerShadow, "innerShdw");
            }
            if (hasReflection) {
                this.attachReflection(effect.reflection);
            }
            if (hasSoftEdges) {
                this.attachSoftEdges(effect.softEdges);
            }
            this.bw.write("</a:effectLst>");
        }
        if (effect.scene3D != null && effect.scene3D.camera != null) {
            this.attachScene3d(effect.scene3D);
        }
        if (effect.shape3D != null) {
            this.attachShape3D(effect.shape3D);
        }
    }

    protected void attachShadow(Shadow shadow, String tag) throws IOException {
        boolean hs;
        this.bw.write("<a:");
        this.bw.write(tag);
        int n = (int)(shadow.blur % 101.0 * 12700.0);
        if (n > 0) {
            this.bw.write(" blurRad=\"");
            this.bw.writeInt(n);
        }
        if ((n = (int)(shadow.dist % 201.0 * 12700.0) / 100 * 100) > 0) {
            this.bw.write("\" dist=\"");
            this.bw.writeInt(n);
        }
        if ((n = shadow.direction % 361 * 60000) > 0) {
            this.bw.write("\" dir=\"");
            this.bw.writeInt(n);
        }
        boolean bl = hs = shadow.sx != 0.0 || shadow.sy != 0.0;
        if (hs) {
            if (shadow.sx != 0.0) {
                this.bw.write("\" sx=\"");
                this.bw.writeInt((int)(shadow.sx % 201.0 * 1000.0));
            }
            if (shadow.sy != 0.0) {
                this.bw.write("\" sy=\"");
                this.bw.writeInt((int)(shadow.sy % 201.0 * 1000.0));
            }
        } else if (shadow.size != 100.0) {
            this.bw.write("\" sx=\"");
            n = (int)(shadow.size % 201.0 * 1000.0);
            this.bw.writeInt(n);
            this.bw.write("\" sy=\"");
            this.bw.writeInt(n);
        }
        if (shadow.kx > 0.0) {
            this.bw.write("\" kx=\"");
            this.bw.writeInt((int)(shadow.kx % 361.0 * 60000.0));
        }
        if (shadow.ky > 0.0) {
            this.bw.write("\" ky=\"");
            this.bw.writeInt((int)(shadow.ky % 361.0 * 60000.0));
        }
        if (shadow.angle != null) {
            this.bw.write("\" algn=\"");
            this.bw.write(shadow.angle.shotName);
        }
        if ("outerShdw".equals(tag)) {
            this.bw.write("\" rotWithShape=\"");
            this.bw.writeInt(shadow.rotWithShape);
        }
        this.bw.write("\"><a:srgbClr val=\"");
        this.bw.write(ColorIndex.toRGB(shadow.color));
        n = (100 - shadow.alpha % 101) * 1000;
        if (n != 100000) {
            this.bw.write("\"><a:alpha val=\"");
            this.bw.writeInt(n);
            this.bw.write("\"/></a:srgbClr>");
        } else {
            this.bw.write("\"/>");
        }
        this.bw.write("</a:");
        this.bw.write(tag);
        this.bw.write(">");
    }

    protected void attachReflection(Reflection reflection) throws IOException {
        this.bw.write("<a:reflection blurRad=\"");
        this.bw.writeInt((int)(reflection.blur % 101.0 * 12700.0));
        this.bw.write("\" stA=\"");
        this.bw.writeInt((100 - reflection.alpha % 101) * 1000);
        if (reflection.dist > 0.0) {
            this.bw.write("\" dist=\"");
            this.bw.writeInt((int)(reflection.dist % 101.0 * 12700.0));
        }
        this.bw.write("\" endPos=\"");
        this.bw.writeInt((int)(reflection.size % 101.0 * 1000.0 + 0.5));
        this.bw.write("\" dir=\"");
        this.bw.writeInt(reflection.direction % 361 * 60000);
        this.bw.write("\" sy=\"-100000\" algn=\"bl\" rotWithShape=\"0\"/>");
    }

    protected void attachGlow(Glow glow) throws IOException {
        int red = (int)(glow.dist % 151.0 * 12700.0) / 100 * 100;
        this.bw.write("<a:glow");
        if (red > 0) {
            this.bw.write(" rad=\"");
            this.bw.writeInt(red);
            this.bw.write(34);
        }
        this.bw.write("><a:srgbClr val=\"");
        Color color = glow.color != null ? glow.color : Color.WHITE;
        this.bw.write(ColorIndex.toRGB(color));
        int t = 100 - glow.alpha % 101;
        if (t != 100) {
            this.bw.write("\"><a:alpha val=\"");
            this.bw.writeInt(t * 1000);
            this.bw.write("\"/></a:srgbClr></a:glow>");
        } else {
            this.bw.write("\"/></a:glow>");
        }
    }

    protected void attachSoftEdges(double softEdges) throws IOException {
        this.bw.write("<a:softEdge rad=\"");
        this.bw.writeInt((int)(softEdges % 101.0 * 12700.0) / 100 * 100);
        this.bw.write("\"/>");
    }

    protected void attachFill(Fill fill) throws IOException {
        if (fill instanceof Fill.SolidFill) {
            int t;
            Fill.SolidFill solidFill = (Fill.SolidFill)fill;
            if (solidFill.color == null) {
                return;
            }
            this.bw.write("<a:solidFill><a:srgbClr val=\"");
            this.bw.write(ColorIndex.toRGB(solidFill.color));
            this.bw.write("\">");
            if (solidFill.shade > 0) {
                this.bw.write("<a:shade val=\"");
                this.bw.writeInt(solidFill.shade * 1000);
                this.bw.write("\"/>");
            }
            if ((t = 100 - solidFill.alpha % 101) != 100) {
                this.bw.write("<a:alpha val=\"");
                this.bw.writeInt(t * 1000);
                this.bw.write("\"/>");
            }
            this.bw.write("</a:srgbClr></a:solidFill>");
        }
    }

    protected void attachOutline(Outline ln) throws IOException {
        this.bw.write("<a:ln w=\"");
        this.bw.writeInt((int)(ln.width * 12700.0));
        this.bw.write("\" cap=\"");
        this.bw.write(ln.cap != null ? ln.cap.shotName : Enums.Cap.square.shotName);
        if (ln.cmpd != null) {
            this.bw.write("\" cmpd=\"");
            this.bw.write(ln.cmpd.shotName);
        }
        this.bw.write("\">");
        this.bw.write("<a:solidFill><a:srgbClr val=\"");
        this.bw.write(ln.color != null ? ColorIndex.toRGB(ln.color) : "FFFFFF");
        this.bw.write("\"/></a:solidFill>");
        if (ln.dash != null) {
            this.bw.write("<a:prstDash val=\"");
            this.bw.write(ln.dash.name());
            this.bw.write("\"/>");
        }
        if (ln.joinType != null) {
            this.bw.write("<a:");
            this.bw.write(ln.joinType.name());
            if (ln.joinType == Enums.JoinType.miter) {
                this.bw.write(" lim=\"");
                this.bw.writeInt(ln.miterLimit > 0.0 ? (int)(ln.miterLimit * 1000.0) : 800000);
                this.bw.write("\"/>");
            } else {
                this.bw.write("/>");
            }
        }
        this.bw.write("</a:ln>");
    }

    protected void attachScene3d(Scene3D scene) throws IOException {
        this.bw.write("<a:scene3d>");
        Camera camera = scene.camera;
        this.bw.write("<a:camera prst=\"");
        this.bw.write(camera.presetCamera != null ? camera.presetCamera.name() : Enums.PresetCamera.orthographicFront.name());
        if (camera.fov > 0.0) {
            this.bw.write("\" fov=\"");
            this.bw.writeInt((int)(camera.fov % 181.0 * 60000.0));
        }
        if (camera.zoom > 0) {
            this.bw.write("\" zoom=\"");
            this.bw.writeInt(camera.zoom);
            this.bw.write("%");
        }
        if (camera.latitude > 0.0 || camera.longitude > 0.0 || camera.revolution > 0.0) {
            this.bw.write("\"><a:rot lat=\"");
            this.bw.writeInt((int)(camera.latitude * 60000.0));
            this.bw.write("\" lon=\"");
            this.bw.writeInt((int)(camera.longitude * 60000.0));
            this.bw.write("\" rev=\"");
            this.bw.writeInt((int)(camera.revolution * 60000.0));
            this.bw.write("\"/></a:camera>");
        } else {
            this.bw.write("\"/>");
        }
        LightRig lightRig = scene.lightRig;
        if (lightRig != null && lightRig.rig != null) {
            this.bw.write("<a:lightRig rig=\"");
            this.bw.write(lightRig.rig.name());
            this.bw.write("\" dir=\"");
            this.bw.write(lightRig.angle != null ? lightRig.angle.shotName : Enums.Angle.TOP.shotName);
            this.bw.write("\">");
            if (lightRig.latitude > 0.0 || lightRig.longitude > 0.0 || lightRig.revolution > 0.0) {
                this.bw.write("<a:rot lat=\"");
                this.bw.writeInt((int)(lightRig.latitude * 60000.0));
                this.bw.write("\" lon=\"");
                this.bw.writeInt((int)(lightRig.longitude * 60000.0));
                this.bw.write("\" rev=\"");
                this.bw.writeInt((int)(lightRig.revolution * 60000.0));
                this.bw.write("\"/>");
            }
            this.bw.write("</a:lightRig>");
        }
        this.bw.write("</a:scene3d>");
    }

    protected void attachShape3D(Shape3D shape) throws IOException {
        this.bw.write("<a:sp3d");
        if (shape.contourWidth > 0.0) {
            this.writeShapeProp(shape.contourWidth, "contourW");
        }
        if (shape.extrusionHeight > 0.0) {
            this.writeShapeProp(shape.extrusionHeight, "extrusionH");
        }
        if (shape.material != null) {
            this.bw.write(" prstMaterial=\"");
            this.bw.write(shape.material.name());
            this.bw.write("\"");
        }
        this.bw.write(">");
        if (shape.bevelBottom != null) {
            this.writeBevel(shape.bevelBottom, 'B');
        }
        if (shape.bevelTop != null) {
            this.writeBevel(shape.bevelTop, 'T');
        }
        if (shape.contourColor != null) {
            this.bw.write("<a:contourClr><a:srgbClr val=\"");
            this.bw.write(ColorIndex.toRGB(shape.contourColor));
            this.bw.write("\"/></a:contourClr>");
        }
        if (shape.extrusionColor != null) {
            this.bw.write("<a:extrusionClr><a:srgbClr val=\"");
            this.bw.write(ColorIndex.toRGB(shape.extrusionColor));
            this.bw.write("\"/></a:extrusionClr>");
        }
        this.bw.write("</a:sp3d>");
    }

    protected void writeBevel(Bevel bevel, char angle) throws IOException {
        this.bw.write("<a:bevel");
        this.bw.write(angle);
        this.bw.write(" w=\"");
        this.bw.writeInt((int)(bevel.width * 12700.0));
        this.bw.write("\" h=\"");
        this.bw.writeInt((int)(bevel.height * 12700.0));
        if (bevel.prst != null) {
            this.bw.write("\" prst=\"");
            this.bw.write(bevel.prst.name());
        }
        this.bw.write("\"/>");
    }

    private void writeShapeProp(double v, String tag) throws IOException {
        this.bw.write(" ");
        this.bw.write(tag);
        this.bw.write("=\"");
        this.bw.writeInt((int)(v * 12700.0));
        this.bw.write("\"");
    }
}

