/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.hash;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.LongAdder;

public final class LockFreeBitArray {
    private static final int LONG_ADDRESSABLE_BITS = 6;
    final AtomicLongArray data;
    private final LongAdder bitCount;

    LockFreeBitArray(long bits) {
        this(new long[(int)LockFreeBitArray.divide(bits, 64L, RoundingMode.CEILING)]);
    }

    LockFreeBitArray(long[] data) {
        this.data = new AtomicLongArray(data);
        this.bitCount = new LongAdder();
        long bitCount = 0L;
        for (long value : data) {
            bitCount += (long)Long.bitCount(value);
        }
        this.bitCount.add(bitCount);
    }

    boolean set(long bitIndex) {
        long newValue;
        long oldValue;
        if (this.get(bitIndex)) {
            return false;
        }
        int longIndex = (int)(bitIndex >>> 6);
        long mask = 1L << (int)bitIndex;
        do {
            if ((oldValue = this.data.get(longIndex)) != (newValue = oldValue | mask)) continue;
            return false;
        } while (!this.data.compareAndSet(longIndex, oldValue, newValue));
        this.bitCount.increment();
        return true;
    }

    boolean get(long bitIndex) {
        return (this.data.get((int)(bitIndex >>> 6)) & 1L << (int)bitIndex) != 0L;
    }

    public static long[] toPlainArray(AtomicLongArray atomicLongArray) {
        long[] array = new long[atomicLongArray.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = atomicLongArray.get(i);
        }
        return array;
    }

    long bitSize() {
        return (long)this.data.length() * 64L;
    }

    LockFreeBitArray copy() {
        return new LockFreeBitArray(LockFreeBitArray.toPlainArray(this.data));
    }

    void putAll(LockFreeBitArray other) {
        for (int i = 0; i < this.data.length(); ++i) {
            long ourLongNew;
            long ourLongOld;
            long otherLong = other.data.get(i);
            boolean changedAnyBits = true;
            do {
                if ((ourLongOld = this.data.get(i)) != (ourLongNew = ourLongOld | otherLong)) continue;
                changedAnyBits = false;
                break;
            } while (!this.data.compareAndSet(i, ourLongOld, ourLongNew));
            if (!changedAnyBits) continue;
            int bitsAdded = Long.bitCount(ourLongNew) - Long.bitCount(ourLongOld);
            this.bitCount.add(bitsAdded);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof LockFreeBitArray) {
            LockFreeBitArray lockFreeBitArray = (LockFreeBitArray)o;
            return Arrays.equals(LockFreeBitArray.toPlainArray(this.data), LockFreeBitArray.toPlainArray(lockFreeBitArray.data));
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(LockFreeBitArray.toPlainArray(this.data));
    }

    public static long divide(long p, long q, RoundingMode mode) {
        boolean increment;
        long div = p / q;
        long rem = p - q * div;
        if (rem == 0L) {
            return div;
        }
        int signum = 1 | (int)((p ^ q) >> 63);
        switch (mode) {
            case UNNECESSARY: 
            case DOWN: {
                increment = false;
                break;
            }
            case UP: {
                increment = true;
                break;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_EVEN: 
            case HALF_DOWN: 
            case HALF_UP: {
                long absRem = Math.abs(rem);
                long cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0L) {
                    increment = mode == RoundingMode.HALF_UP | mode == RoundingMode.HALF_EVEN & (div & 1L) != 0L;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + (long)signum : div;
    }
}

