/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.manager.docProps;

import java.math.BigDecimal;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.manager.docProps.XmlEntity;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={"", "vt"}, uri={"http://schemas.openxmlformats.org/officeDocument/2006/custom-properties", "http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes"}, value="Properties")
public class CustomProperties
extends XmlEntity {
    public static final String FORMAT_ID = "{D5CDD505-2E9C-101B-9397-08002B2CF9AE}";
    private static final String MARK_AS_READ_ONLY = "_MarkAsFinal";
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public void put(String key, Object value) {
        CustomProperties.check(key, value);
        this.properties.put(key, value);
    }

    public void putAll(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            CustomProperties.check(entry.getKey(), entry.getValue());
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    public void markAsReadOnly() {
        this.properties.put(MARK_AS_READ_ONLY, true);
    }

    public boolean hasReadOnlyMark() {
        Object v = this.properties.get(MARK_AS_READ_ONLY);
        return v instanceof Boolean && (Boolean)v != false;
    }

    public Object remove(String key) {
        return this.properties.remove(key);
    }

    public Map<String, Object> getAll() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.properties.size());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            if (MARK_AS_READ_ONLY.equals(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public boolean hasProperty() {
        return !this.properties.isEmpty();
    }

    @Override
    void toDom(Element root, Map<String, Namespace> namespaceMap) {
        int id = 2;
        Namespace vt = namespaceMap.get("vt");
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Element property = root.addElement("property").addAttribute("fmtid", FORMAT_ID).addAttribute("pid", Integer.toString(id++)).addAttribute("name", entry.getKey());
            Object val = entry.getValue();
            switch (CustomProperties.testValueType(val)) {
                case 0: {
                    property.addElement(QName.get((String)"lpwstr", (Namespace)vt)).addText(val.toString());
                    break;
                }
                case 1: {
                    property.addElement(QName.get((String)"filetime", (Namespace)vt)).addText(DateUtil.toTString((Date)val));
                    break;
                }
                case 2: {
                    property.addElement(QName.get((String)"i4", (Namespace)vt)).addText(val.toString());
                    break;
                }
                case 3: {
                    property.addElement(QName.get((String)"r8", (Namespace)vt)).addText(val.toString());
                    break;
                }
                case 4: {
                    property.addElement(QName.get((String)"bool", (Namespace)vt)).addText(val.toString());
                    break;
                }
            }
        }
    }

    public static CustomProperties domToCustom(Element root) {
        List list = root.elements();
        if (list == null || list.isEmpty()) {
            return null;
        }
        CustomProperties custom = new CustomProperties();
        for (Element e : list) {
            String key = e.attributeValue("name");
            List sub = e.elements();
            if (sub != null && !sub.isEmpty()) {
                Element val = (Element)sub.get(0);
                String type = val.getName();
                String value = val.getText();
                switch (type) {
                    case "lpwstr": {
                        custom.properties.put(key, value);
                        break;
                    }
                    case "filetime": {
                        custom.properties.put(key, DateUtil.utcDateTimeFormat.get().parse(value, new ParsePosition(0)));
                        break;
                    }
                    case "i4": 
                    case "i2": {
                        custom.properties.put(key, Integer.parseInt(value));
                        break;
                    }
                    case "i8": {
                        custom.properties.put(key, Long.parseLong(value));
                        break;
                    }
                    case "r8": 
                    case "r4": 
                    case "ui8": {
                        custom.properties.put(key, new BigDecimal(value));
                        break;
                    }
                    case "bool": {
                        custom.properties.put(key, Boolean.valueOf(value));
                        break;
                    }
                    default: {
                        custom.properties.put(key, value);
                        break;
                    }
                }
                continue;
            }
            custom.properties.put(key, null);
        }
        return custom;
    }

    protected static void check(String key, Object val) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("Property name is required.");
        }
        if (key.length() > 256) {
            throw new IllegalArgumentException("Property name is too long, max=256 current=" + key.length());
        }
        if (val == null) {
            throw new IllegalArgumentException("Property value is required.");
        }
    }

    protected static int testValueType(Object val) {
        int t = val instanceof String ? 0 : (val instanceof Date ? 1 : (val instanceof Integer || val instanceof Short ? 2 : (val instanceof Long || val instanceof Double || val instanceof Float ? 3 : (val instanceof Boolean ? 4 : 0))));
        return t;
    }
}

