/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.util.ExtBufferedWriter;

public class Dimension {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dimension.class);
    public final int firstRow;
    public final int lastRow;
    public final short firstColumn;
    public final short lastColumn;
    public final int width;
    public final int height;

    public Dimension(int firstRow, short firstColumn) {
        this(firstRow, firstColumn, firstRow, firstColumn);
    }

    public Dimension(int firstRow, short firstColumn, int lastRow, short lastColumn) {
        this.firstRow = Math.max(firstRow, 1);
        this.firstColumn = (short)Math.max(firstColumn, 1);
        this.lastRow = lastRow > 0 ? lastRow : this.firstRow;
        this.lastColumn = lastColumn > 0 ? lastColumn : this.firstColumn;
        this.width = this.lastColumn - this.firstColumn + 1;
        this.height = this.lastRow - this.firstRow + 1;
        if (this.width < 1 || this.height < 1) {
            throw new IllegalArgumentException("Dimension(firstRow:" + firstRow + ",firstColumn:" + firstColumn + ",lastRow=" + lastRow + ",lastColumn=" + lastColumn + ") contains invalid range");
        }
    }

    public static Dimension of(String range) {
        int i = range.indexOf(58);
        long f = 0L;
        long t = 0L;
        if (i < 0) {
            f = ExcelReader.coordinateToLong(range);
        } else if (i == 0) {
            t = ExcelReader.coordinateToLong(range.substring(i + 1));
        } else {
            f = ExcelReader.coordinateToLong(range.substring(0, i));
            t = ExcelReader.coordinateToLong(range.substring(i + 1));
            if (t == 0L) {
                t = 0x1000000000L;
                LOGGER.warn("Empty reference detected. The range will include the entire column instead of a single cell.");
            }
        }
        return new Dimension((int)(f >> 16), (short)f, (int)(t >> 16), (short)t);
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public short getFirstColumn() {
        return this.firstColumn;
    }

    public short getLastColumn() {
        return this.lastColumn;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return Sheet.toCoordinate(this.firstRow, this.firstColumn) + (this.lastRow > this.firstRow || this.lastColumn > this.firstColumn ? ":" + Sheet.toCoordinate(this.lastRow, this.lastColumn) : "");
    }

    public String toReferer() {
        char[] chars;
        if (this.lastRow > this.firstRow || this.lastColumn > this.firstColumn) {
            int i = 0;
            int c0 = this.firstColumn <= 26 ? 1 : (this.firstColumn <= 702 ? 2 : 3);
            int r0 = ExtBufferedWriter.stringSize(this.firstRow);
            int c1 = this.lastColumn <= 26 ? 1 : (this.lastColumn <= 702 ? 2 : 3);
            int r1 = ExtBufferedWriter.stringSize(this.lastRow);
            chars = new char[c0 + r0 + c1 + r1 + 5];
            chars[i++] = 36;
            System.arraycopy(Sheet.int2Col(this.firstColumn), 0, chars, i, c0);
            i += c0;
            chars[i++] = 36;
            ExtBufferedWriter.getChars(this.firstRow, i += r0, chars);
            chars[i++] = 58;
            chars[i++] = 36;
            System.arraycopy(Sheet.int2Col(this.lastColumn), 0, chars, i, c1);
            i += c1;
            chars[i++] = 36;
            ExtBufferedWriter.getChars(this.lastRow, i + r1, chars);
        } else {
            int c0 = this.firstColumn <= 26 ? 1 : (this.firstColumn <= 702 ? 2 : 3);
            chars = new char[c0 + ExtBufferedWriter.stringSize(this.firstRow) + 2];
            chars[0] = 36;
            System.arraycopy(Sheet.int2Col(this.firstColumn), 0, chars, 1, c0);
            chars[c0 + 1] = 36;
            ExtBufferedWriter.getChars(this.firstRow, chars.length, chars);
        }
        return new String(chars);
    }

    public boolean checkRange(int r, int c) {
        return r >= this.firstRow && r <= this.lastRow && c >= this.firstColumn && c <= this.lastColumn;
    }

    public int hashCode() {
        return (this.firstColumn << 24 | this.lastColumn) ^ (this.firstRow << 24 | this.lastRow);
    }

    public boolean equals(Object o) {
        boolean r;
        boolean bl = r = this == o;
        if (!r && o instanceof Dimension) {
            Dimension other = (Dimension)o;
            r = other.firstRow == this.firstRow && other.firstColumn == this.firstColumn && other.lastRow == this.lastRow && other.lastColumn == this.lastColumn;
        }
        return r;
    }
}

