/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.reader.Cache;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.FixSizeLRUCache;
import org.ttzero.excel.reader.IndexSharedStringTable;
import org.ttzero.excel.reader.Tester;
import org.ttzero.excel.util.ExtBufferedWriter;

public class SharedStrings
implements Closeable {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    static final int MAXIMUM_CAPACITY = 0x100000;
    private String[] forward;
    private String[] backward;
    private int page;
    private int max = -1;
    private int offsetM = 0;
    private int offset_forward = -1;
    private int offset_backward = -1;
    private int limit_forward;
    private int limit_backward;
    private Tester tester = null;
    private Cache<Integer, String> hot;
    private int hotSize;
    private Reader reader;
    private char[] cb;
    private int nChar;
    private int length;
    private IndexSharedStringTable sst;
    private int status;
    StringBuilder buf = null;
    private int total;
    private int total_forward;
    private int total_backward;
    private int total_hot;
    private int total_sst;
    private static char[] charBuffer = new char[0];

    public SharedStrings(String[] data) {
        this.max = data.length;
        this.offset_forward = 0;
        this.status = 1;
        if (this.max <= 512) {
            this.forward = new String[this.max];
            System.arraycopy(data, this.offset_forward, this.forward, 0, this.max);
            this.limit_forward = this.max;
        } else {
            this.page = this.max + 1 >> 1;
            this.status <<= 1;
            this.forward = new String[this.page];
            this.limit_forward = this.page;
            System.arraycopy(data, this.offset_forward, this.forward, 0, this.limit_forward);
            this.offset_backward = this.page;
            this.limit_backward = this.max - this.page;
            this.backward = new String[this.limit_backward];
            System.arraycopy(data, this.offset_backward, this.backward, 0, this.limit_backward);
        }
    }

    public SharedStrings(InputStream is, int cacheSize, int hotSize) {
        this.reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        if (cacheSize > 0) {
            this.page = SharedStrings.tableSizeFor(cacheSize);
        }
        this.hotSize = hotSize;
    }

    public SharedStrings(IndexSharedStringTable sst, int cacheSize, int hotSize) throws IOException {
        this.sst = sst;
        this.max = sst.size();
        if (cacheSize > 0) {
            this.page = SharedStrings.tableSizeFor(cacheSize);
        }
        this.hotSize = hotSize;
        this.init();
        this.offset_forward = 0;
        this.limit_forward = sst.get(0, this.forward);
    }

    public int size() {
        return this.max;
    }

    public static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 64 ? 64 : (n >= 0x100000 ? 0x100000 : n + 1);
    }

    public SharedStrings load() throws IOException {
        this.max = this.uniqueCount();
        this.LOGGER.debug("Size of SharedString: {}", (Object)this.max);
        this.init();
        return this;
    }

    private void init() throws IOException {
        this.status = 1;
        if (this.max < 0 || this.max > 16384) {
            if (this.page <= 0) {
                this.page = 16;
            }
            this.status <<= 2;
            this.forward = new String[this.page];
            this.backward = new String[this.page];
            this.tester = new Tester.BinaryTester(this.max > 0 ? Math.min(this.max, 65536) : 65536);
            this.hot = this.hotSize > 0 ? FixSizeLRUCache.create(this.hotSize) : FixSizeLRUCache.create();
            if (this.sst == null) {
                this.sst = new IndexSharedStringTable();
                this.sst.setShortSectorSize(Integer.numberOfTrailingZeros(this.page));
            }
        } else if (this.max > 512) {
            this.status <<= 1;
            this.page = this.max + 1 >> 1;
            this.forward = new String[this.page];
            this.backward = new String[this.page];
        } else {
            this.page = Math.max(16, this.max);
            this.forward = new String[this.page];
        }
    }

    private int uniqueCount() throws IOException {
        int end;
        String uniqueCount;
        int off = -1;
        this.cb = new char[4096];
        this.length = this.reader.read(this.cb);
        if (this.length <= 0) {
            this.status = 0;
            return 0;
        }
        String line = new String(this.cb, 0, Math.min(256, this.length));
        int index = line.indexOf(uniqueCount = " uniqueCount=");
        int n = end = index > 0 ? line.indexOf(34, index += uniqueCount.length() + 1) : -1;
        if (end > 0) {
            off = Integer.parseInt(line.substring(index, end));
        } else {
            String count = " count=";
            index = line.indexOf(count);
            int n2 = end = index > 0 ? line.indexOf(34, index += count.length() + 1) : -1;
            if (end > 0) {
                off = Integer.parseInt(line.substring(index, end));
            }
        }
        if (end > 0) {
            this.nChar = end + 1;
        }
        return off;
    }

    public String get(int index) {
        ++this.total;
        if (this.offset_forward == -1) {
            this.offset_forward = index / this.page * this.page;
            this.readMore();
        }
        String value = null;
        if (this.forwardRange(index)) {
            value = this.forward[index - this.offset_forward];
            ++this.total_forward;
            if (this.test(index)) {
                this.hot.put(index, value);
            }
            return value;
        }
        if (this.status == 1) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.max);
        }
        if (this.backwardRange(index)) {
            value = this.backward[index - this.offset_backward];
            ++this.total_backward;
            if (this.test(index)) {
                this.hot.put(index, value);
            }
            return value;
        }
        if (this.status == 4) {
            value = this.hot.get(index);
        }
        if (value == null) {
            if (this.status == 2 && this.offset_backward > -1) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.max);
            }
            this.copyToBackward();
            this.offset_forward = index / this.page * this.page;
            this.forward[0] = null;
            if (this.status == 4 && index < this.sst.size()) {
                try {
                    this.limit_forward = this.sst.get(this.offset_forward, this.forward);
                }
                catch (IOException e) {
                    throw new ExcelReadException(e);
                }
                ++this.total_sst;
            } else {
                this.readMore();
                ++this.total_forward;
            }
            if (this.forward[0] == null) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.max);
            }
            value = this.forward[index - this.offset_forward];
            if (this.test(index)) {
                this.hot.put(index, value);
            }
        } else {
            ++this.total_hot;
        }
        return value;
    }

    private boolean forwardRange(int index) {
        return this.offset_forward >= 0 && this.offset_forward <= index && this.offset_forward + this.limit_forward > index;
    }

    private boolean backwardRange(int index) {
        return this.offset_backward >= 0 && this.offset_backward <= index && this.offset_backward + this.limit_backward > index;
    }

    private boolean test(int index) {
        return this.status == 4 && this.tester.test(index);
    }

    private void copyToBackward() {
        String[] tmp = this.backward;
        this.backward = this.forward;
        this.forward = tmp;
        this.offset_backward = this.offset_forward;
        this.limit_backward = this.limit_forward;
    }

    protected void readMore() {
        int index = this.offset_forward / this.page;
        try {
            int n = index - this.offsetM;
            while (n-- >= 0) {
                if (this.offset_backward == -1 && this.limit_forward > 0) {
                    this.copyToBackward();
                    this.offset_backward = 0;
                }
                this.readData();
            }
        }
        catch (IOException e) {
            throw new ExcelReadException(e);
        }
    }

    protected int readData() throws IOException {
        int n = 0;
        int len = this.length;
        while (true) {
            int offset;
            int len0 = len - 3;
            int len1 = len0 - 1;
            int[] t = this.findT(this.cb, this.nChar, len, len0, len1, n);
            this.nChar = t[0];
            this.limit_forward = n = t[1];
            if (n == this.page || len < this.cb.length && this.nChar == len - 6) {
                ++this.offsetM;
                break;
            }
            if (this.nChar == 0) {
                this.cb = Arrays.copyOf(this.cb, this.cb.length << 1);
                offset = len;
            } else if (this.nChar < len) {
                offset = len - this.nChar;
                System.arraycopy(this.cb, this.nChar, this.cb, 0, offset);
            } else {
                offset = 0;
            }
            len = this.reader.read(this.cb, offset, this.cb.length - offset);
            if (len <= 0) break;
            this.length = len += offset;
            this.nChar = 0;
        }
        if (this.max < n) {
            this.max = this.offsetM * this.page + n;
        }
        return n;
    }

    private int[] findT(char[] cb, int nChar, int length, int len0, int len1, int n) throws IOException {
        while (nChar < length && n < this.page) {
            int[] subT;
            int a;
            int cursor = nChar;
            while (nChar < len0 && cb[nChar] != '<') {
                ++nChar;
            }
            if (nChar < len0 && cb[nChar + 1] == 's' && cb[nChar + 2] == 'i' && (cb[nChar + 3] == '>' || cb[nChar + 3] == '/' && cb[nChar + 4] == '>')) {
                if (cb[nChar + 3] == '/') {
                    this.forward[n++] = "";
                    if (this.status == 4) {
                        this.sst.push(this.forward[n - 1]);
                    }
                    nChar += 5;
                    continue;
                }
                nChar += 4;
            }
            if ((a = (subT = this.subT(cb, nChar, len0, len1))[0]) == -1) break;
            nChar = subT[1];
            String tmp = SharedStrings.escape(cb, a, nChar);
            if (cb[nChar += 4] != '<') {
                while (nChar < len1 && cb[nChar] != '<') {
                    ++nChar;
                }
            }
            if (nChar < len1 && cb[nChar + 1] == '/' && cb[nChar + 2] == 's' && cb[nChar + 3] == 'i' && cb[nChar + 4] == '>') {
                this.forward[n++] = tmp;
                if (this.status == 4) {
                    this.sst.push(this.forward[n - 1]);
                }
                nChar += 5;
            } else {
                int t = nChar;
                while (nChar < len1 && (cb[nChar] != '<' || cb[nChar + 1] != '/' || cb[nChar + 2] != 's' || cb[nChar + 3] != 'i' || cb[nChar + 4] != '>')) {
                    ++nChar;
                }
                if (nChar >= len1) {
                    nChar = cursor;
                    break;
                }
                int end = nChar;
                nChar = t;
                boolean shouldClear = true;
                while ((a = (subT = this.subT(cb, nChar, end, end - 1))[0]) != -1) {
                    nChar = subT[1];
                    if (this.buf == null) {
                        shouldClear = false;
                        this.buf = new StringBuilder(tmp);
                    } else if (shouldClear) {
                        shouldClear = false;
                        this.buf.delete(0, this.buf.length());
                        this.buf.append(tmp);
                    }
                    this.buf.append(SharedStrings.escape(cb, a, nChar));
                    nChar += 4;
                }
                String string = this.forward[n++] = shouldClear ? tmp : this.buf.toString();
                if (this.status == 4) {
                    this.sst.push(this.forward[n - 1]);
                }
                nChar = end + 5;
            }
            if (n != this.page) continue;
            break;
        }
        return new int[]{nChar, n};
    }

    private int[] subT(char[] cb, int nChar, int len0, int len1) {
        int a;
        while (true) {
            if (nChar < len0 && cb[nChar] != '<') {
                ++nChar;
                continue;
            }
            if (nChar >= len1) {
                return new int[]{-1};
            }
            if (cb[nChar + 1] != 'r' || cb[nChar + 2] != 'P' || cb[nChar + 3] != 'h' || cb[nChar + 4] != '>' && cb[nChar + 4] != ' ') break;
            int len = len1 - 2;
            for (a = nChar + 5; a < len && cb[a] != '<' || cb[a + 1] != '/' || cb[a + 2] != 'r' || cb[a + 3] != 'P' || cb[a + 4] != 'h' || cb[a + 5] != '>'; ++a) {
            }
            if (a >= len1 - 2) {
                return new int[]{-1};
            }
            nChar = a + 6;
            if (nChar >= len1) break;
        }
        if (nChar < len1 && cb[nChar + 1] == '/' && cb[nChar + 2] == 's' && cb[nChar + 3] == 'i' && cb[nChar + 4] == '>') {
            return new int[]{nChar - 4, nChar - 4};
        }
        while (nChar < len0 && (cb[nChar] != '<' || cb[nChar + 1] != 't' || cb[nChar + 2] != '>' && cb[nChar + 2] != ' ' && cb[nChar + 2] != '/')) {
            ++nChar;
        }
        if (nChar >= len0) {
            return new int[]{-1};
        }
        if (cb[nChar + 2] == '/' && cb[nChar + 3] == '>') {
            return new int[]{nChar, nChar};
        }
        a = nChar += 3;
        if (cb[nChar - 1] == ' ') {
            while (nChar < len0 && cb[nChar++] != '>') {
            }
            if (nChar >= len0) {
                return new int[]{-1};
            }
            a = nChar;
        }
        while (nChar < len1 && (cb[nChar] != '<' || cb[nChar + 1] != '/' || cb[nChar + 2] != 't' || cb[nChar + 3] != '>')) {
            ++nChar;
        }
        if (nChar >= len1) {
            return new int[]{-1};
        }
        return new int[]{a, nChar};
    }

    public static String escape(char[] cb, int from, int to) {
        char[] buf;
        int idx_59;
        int n = to - from;
        if (n == 0) {
            return "";
        }
        int idx_38 = SharedStrings.indexOf(cb, '&', from, to);
        int n2 = idx_59 = idx_38 > -1 && idx_38 < to ? SharedStrings.indexOf(cb, ';', idx_38 + 1, Math.min(idx_38 + 9, to)) : -1;
        if (idx_38 < from || idx_38 >= idx_59 || idx_59 > to) {
            return new String(cb, from, to - from);
        }
        if (n <= charBuffer.length) {
            buf = charBuffer;
        } else if (n <= Short.MAX_VALUE) {
            charBuffer = buf = new char[Math.min(n + 100, Short.MAX_VALUE)];
        } else {
            buf = new char[n];
        }
        int offset = 0;
        do {
            n = idx_38 - from;
            System.arraycopy(cb, from, buf, offset, n);
            offset += n;
            if (cb[idx_38 + 1] == '#') {
                char c = cb[idx_38 + 2];
                if (c == 'x') {
                    offset += SharedStrings.toChars(SharedStrings.toIntH(cb, idx_38 + 3, idx_59), buf, offset);
                } else if (c >= '0' && c <= '9') {
                    offset += SharedStrings.toChars(SharedStrings.toInt(cb, idx_38 + 2, idx_59), buf, offset);
                } else {
                    n = idx_59 - idx_38 + 1;
                    System.arraycopy(cb, idx_38, buf, offset, n);
                    offset += n;
                }
            } else {
                n = idx_59 - idx_38 - 1;
                if (n == 2 && cb[idx_38 + 1] == 'l' && cb[idx_38 + 2] == 't') {
                    buf[offset++] = 60;
                } else if (n == 2 && cb[idx_38 + 1] == 'g' && cb[idx_38 + 2] == 't') {
                    buf[offset++] = 62;
                } else if (n == 3 && cb[idx_38 + 1] == 'a' && cb[idx_38 + 2] == 'm' && cb[idx_38 + 3] == 'p') {
                    buf[offset++] = 38;
                } else if (n == 4 && cb[idx_38 + 1] == 'n' && cb[idx_38 + 2] == 'b' && cb[idx_38 + 3] == 's' && cb[idx_38 + 4] == 'p') {
                    buf[offset++] = 32;
                } else if (n == 4 && cb[idx_38 + 1] == 'q' && cb[idx_38 + 2] == 'u' && cb[idx_38 + 3] == 'o' && cb[idx_38 + 4] == 't') {
                    buf[offset++] = 34;
                } else {
                    n = idx_59 - idx_38 + 1;
                    System.arraycopy(cb, idx_38, buf, offset, n);
                    offset += n;
                }
            }
            from = ++idx_59;
            idx_38 = SharedStrings.indexOf(cb, '&', idx_59, to);
            int n3 = idx_59 = idx_38 > -1 && idx_38 < to ? SharedStrings.indexOf(cb, ';', idx_38 + 1, Math.min(idx_38 + 9, to)) : -1;
        } while (idx_38 > -1 && idx_59 > idx_38 && idx_59 <= to);
        if (from < to) {
            n = to - from;
            System.arraycopy(cb, from, buf, offset, n);
            offset += n;
        }
        return new String(buf, 0, offset);
    }

    private static int indexOf(char[] cb, char c, int from, int to) {
        while (from < to && cb[from] != c) {
            ++from;
        }
        return from < to ? from : -1;
    }

    static int toInt(char[] cb, int a, int b) {
        int i;
        int n = 0;
        boolean negative = cb[a] == '-';
        int n2 = i = negative ? a + 1 : a;
        while (b > i) {
            n = n * 10 + cb[i++] - 48;
        }
        return negative ? -n : n;
    }

    static int toIntH(char[] cb, int a, int b) {
        int n = 0;
        while (b > a) {
            int c;
            n = n * 16 + ((c = cb[a++]) <= 57 ? c - 48 : (c >= 97 ? c - 32 : c) - 55);
        }
        return n;
    }

    static int toChars(int codePoint, char[] dst, int i) {
        int n;
        if (Character.isBmpCodePoint(codePoint)) {
            dst[i] = (char)codePoint;
            n = 1;
        } else if (Character.isValidCodePoint(codePoint)) {
            dst[i + 1] = Character.lowSurrogate(codePoint);
            dst[i] = Character.highSurrogate(codePoint);
            n = 2;
        } else {
            dst[i] = ExtBufferedWriter.MALFORMED_CHAR;
            n = 1;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.LOGGER.debug("Count: {}\uff0c uniqueCount: {}\uff0c Repetition rate: {}%", new Object[]{this.total, this.max, this.total > 0 ? (double)(this.total - this.max) * 100.0 / (double)this.total : 0.0});
            this.LOGGER.debug("Forward: {}, Backward: {}, SST: {}, Hot: {}, Tester: {Resize: {}, Size: {}}", new Object[]{this.total_forward, this.total_backward, this.total_sst, this.total_hot, this.tester != null ? this.tester.analysis() : 0, this.tester != null ? this.tester.size() : 0});
            this.reader.close();
        }
        this.cb = null;
        this.forward = null;
        this.backward = null;
        if (this.tester != null) {
            this.tester = null;
        }
        if (this.sst != null) {
            this.sst.close();
        }
    }

    public String toString() {
        return "Count: " + (this.total <= 0 ? this.max : this.total) + "\uff0cUniqueCount: " + this.max;
    }
}

