/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.SAXReaderUtil;
import org.ttzero.excel.util.StringUtil;

public interface IWorkbookWriter
extends Storable,
Closeable {
    public void setWorkbook(Workbook var1);

    public String getSuffix();

    public void writeTo(OutputStream var1) throws IOException;

    default public void writeTo(File file) throws IOException {
        this.writeTo(file.toPath());
    }

    public IWorksheetWriter getWorksheetWriter(Sheet var1);

    default public Path writeBefore() throws IOException {
        return null;
    }

    default public Path moveToPath(Path source, Path target, String defaultName) throws IOException {
        Path outPath = FileUtil.getTargetPath(target, defaultName, this.getSuffix());
        Path parent = outPath.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            FileUtil.mkdir(parent);
        }
        Files.move(source, outPath, StandardCopyOption.REPLACE_EXISTING);
        return outPath;
    }

    public static Properties pom() {
        Properties pom = new Properties();
        try {
            URL url;
            InputStream is = IWorkbookWriter.class.getClassLoader().getResourceAsStream("META-INF/maven/org.ttzero/eec/pom.properties");
            if (is == null && (url = IWorkbookWriter.class.getClassLoader().getResource(".")) != null) {
                Path targetPath = (FileUtil.isWindows() ? Paths.get(url.getFile().substring(1), new String[0]) : Paths.get(url.getFile(), new String[0])).getParent();
                Path pomPath = targetPath.resolve("maven-archiver/pom.properties");
                if (FileUtil.exists(pomPath)) {
                    is = Files.newInputStream(pomPath, new OpenOption[0]);
                } else {
                    pomPath = targetPath.getParent().resolve("pom.xml");
                    SAXReader reader = SAXReaderUtil.createDefault();
                    try {
                        Document document = reader.read(Files.newInputStream(pomPath, new OpenOption[0]));
                        Element pomRoot = document.getRootElement();
                        pom.setProperty("groupId", pomRoot.elementText("groupId"));
                        pom.setProperty("artifactId", pomRoot.elementText("artifactId"));
                        pom.setProperty("version", pomRoot.elementText("version"));
                    }
                    catch (IOException | DocumentException throwable) {
                        // empty catch block
                    }
                }
            }
            if (is != null) {
                pom.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (StringUtil.isEmpty(pom.getProperty("version"))) {
            pom.setProperty("groupId", "org.ttzero");
            pom.setProperty("artifactId", "eec");
            pom.setProperty("version", "1.0.0");
        }
        return pom;
    }
}

