/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.GridFactory;
import org.ttzero.excel.util.StringUtil;

public class ListMapSheet<T>
extends ListSheet<Map<String, T>> {
    public ListMapSheet() {
    }

    public ListMapSheet(String name) {
        super(name);
    }

    public ListMapSheet(Column ... columns) {
        super(columns);
    }

    public ListMapSheet(String name, Column ... columns) {
        super(name, columns);
    }

    public ListMapSheet(List<Map<String, T>> data) {
        super(data);
    }

    public ListMapSheet(String name, List<Map<String, T>> data) {
        super(name, data);
    }

    public ListMapSheet(List<Map<String, T>> data, Column ... columns) {
        super(data, columns);
    }

    public ListMapSheet(String name, List<Map<String, T>> data, Column ... columns) {
        super(name, data, columns);
    }

    @Override
    protected Column[] getHeaderColumns() {
        if (this.headerReady) {
            return this.columns;
        }
        Map first = (Map)this.getFirst();
        if (first == null) {
            if (this.columns == null) {
                this.columns = new Column[0];
            }
        } else if (!this.hasHeaderColumns()) {
            int size = first.size();
            int i = 0;
            this.columns = new Column[size];
            for (Map.Entry entry : first.entrySet()) {
                Column hc = this.createColumn(entry);
                if (hc == null) continue;
                this.columns[i++] = hc;
            }
            if (i < size) {
                this.columns = Arrays.copyOf(this.columns, i);
            }
        } else {
            for (int i = 0; i < this.columns.length; ++i) {
                Column hc = this.columns[i].getTail();
                boolean emptyKey = StringUtil.isEmpty(hc.key);
                boolean emptyName = StringUtil.isEmpty(hc.name);
                if (emptyKey && emptyName) {
                    throw new ExcelWriteException(this.getClass() + " must specify the 'key' name.");
                }
                if (emptyKey) {
                    hc.key = hc.name;
                } else if (emptyName) {
                    hc.name = hc.key;
                }
                if (hc.getClazz() != null) continue;
                Object o = first.get(hc.key);
                hc.setClazz(o != null ? o.getClass() : String.class);
            }
        }
        return this.columns;
    }

    protected Column createColumn(Map.Entry<String, T> entry) {
        T value;
        if (StringUtil.isEmpty(entry.getKey())) {
            return null;
        }
        return new Column(entry.getKey(), entry.getKey(), (value = entry.getValue()) != null ? value.getClass() : String.class);
    }

    @Override
    protected void mergeHeaderCellsIfEquals() {
        super.mergeHeaderCellsIfEquals();
        List existsMergeCells = (List)this.getExtPropValue("merge_cells");
        if (existsMergeCells != null) {
            Grid grid = GridFactory.create(existsMergeCells);
            for (Column col : this.columns) {
                if (!StringUtil.isEmpty(col.key) || !grid.test(1, col.getColNum())) continue;
                Column next = col.next;
                while (next != null && StringUtil.isEmpty(next.key)) {
                    next = next.next;
                }
                if (next == null) continue;
                col.key = next.key;
            }
        }
    }

    @Override
    protected void resetRowData(Row row, Map<String, T> rowData) {
        int len = this.columns.length;
        Cell[] cells = row.realloc(len);
        boolean nonNull = rowData != null;
        for (int i = 0; i < len; ++i) {
            Column hc = this.columns[i];
            Object e = null;
            if (nonNull && (e = (Object)rowData.get(hc.key)) != null && e.getClass() != hc.getClazz()) {
                hc.setClazz(e.getClass());
            }
            this.resetCellValueAndStyle(row, cells[i], rowData, e, hc);
        }
    }
}

