/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.ttzero.excel.annotation.ExcelColumn;
import org.ttzero.excel.annotation.ExcelColumns;
import org.ttzero.excel.annotation.FreezePanes;
import org.ttzero.excel.annotation.HeaderComment;
import org.ttzero.excel.annotation.HeaderStyle;
import org.ttzero.excel.annotation.Hyperlink;
import org.ttzero.excel.annotation.IgnoreExport;
import org.ttzero.excel.annotation.MediaColumn;
import org.ttzero.excel.annotation.StyleDesign;
import org.ttzero.excel.drawing.PresetPictureEffect;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IPushModelSheet;
import org.ttzero.excel.entity.Panes;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.processor.ConversionProcessor;
import org.ttzero.excel.processor.Converter;
import org.ttzero.excel.processor.StyleProcessor;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.ReflectUtil;
import org.ttzero.excel.util.StringUtil;

public class ListSheet<T>
extends Sheet
implements IPushModelSheet<T> {
    protected List<T> data;
    protected int start;
    protected int end;
    protected boolean eof;
    protected Class<?> tClazz;
    protected StyleProcessor<T> styleProcessor;
    protected int forceExport;
    protected BiFunction<Integer, T, List<T>> dataSupplier;

    public Sheet setStyleProcessor(StyleProcessor<T> styleProcessor) {
        this.styleProcessor = styleProcessor;
        this.putExtProp("style_design", styleProcessor);
        return this;
    }

    public StyleProcessor<T> getStyleProcessor() {
        if (this.styleProcessor != null) {
            return this.styleProcessor;
        }
        StyleProcessor<Object> fromExtProp = (StyleProcessor<Object>)this.getExtPropValue("style_design");
        if (fromExtProp == null || StyleProcessor.None.class.isAssignableFrom(fromExtProp.getClass())) {
            this.extPropMark &= 0xFFFFFFFD;
            if (fromExtProp == null) {
                fromExtProp = (o, style, sst) -> style;
            }
        }
        this.styleProcessor = fromExtProp;
        return this.styleProcessor;
    }

    public ListSheet() {
    }

    public ListSheet(String name) {
        super(name);
    }

    public ListSheet(Column ... columns) {
        super(columns);
    }

    public ListSheet(String name, Column ... columns) {
        super(name, columns);
    }

    public ListSheet(List<T> data) {
        this(null, data);
    }

    public ListSheet(String name, List<T> data) {
        super(name);
        this.setData(data);
    }

    public ListSheet(List<T> data, Column ... columns) {
        this(null, data, columns);
    }

    public ListSheet(String name, List<T> data, Column ... columns) {
        super(name, columns);
        this.setData(data);
    }

    public Sheet setClass(Class<?> tClazz) {
        this.tClazz = tClazz;
        return this;
    }

    public ListSheet<T> setData(List<T> data) {
        if (data == null) {
            return this;
        }
        this.data = new ArrayList<T>(data);
        if (this.sheetWriter != null) {
            this.paging();
        }
        return this;
    }

    public ListSheet<T> setData(BiFunction<Integer, T, List<T>> dataSupplier) {
        this.dataSupplier = dataSupplier;
        return this;
    }

    protected T getFirst() {
        T first;
        if (this.data == null || this.data.isEmpty()) {
            List<T> more = this.more();
            if (more != null && !more.isEmpty()) {
                this.data = new ArrayList<T>(more);
            } else {
                return null;
            }
        }
        if ((first = this.data.get(this.start)) != null) {
            return first;
        }
        int i = this.start + 1;
        while ((first = this.data.get(i++)) == null && i < this.data.size()) {
        }
        return first;
    }

    @Override
    public void close() throws IOException {
        List<T> list;
        if (!this.eof && this.rows >= this.getRowLimit() && (list = this.more()) != null && !list.isEmpty()) {
            this.compact();
            this.data.addAll(list);
            ListSheet copy = (ListSheet)this.getClass().cast(this.clone());
            copy.start = 0;
            copy.end = list.size();
            this.workbook.insertSheet(this.id, copy);
            this.shouldClose = false;
        }
        if (this.shouldClose && this.data != null) {
            this.data = null;
        }
        super.close();
    }

    @Override
    protected void resetBlockData() {
        if (!this.eof && this.left() < this.rowBlock.capacity()) {
            this.append();
        }
        this.start = this.getEndIndex();
        this.resetRowBlock(this.data, this.start, this.start);
    }

    protected void append() {
        block4: {
            int rbs = this.rowBlock.capacity();
            while (true) {
                List<T> list;
                if ((list = this.more()) == null || list.isEmpty()) {
                    this.shouldClose = true;
                    this.eof = true;
                    break block4;
                }
                if (this.data == null) {
                    this.setData(list);
                    if (list.size() < rbs) {
                        continue;
                    }
                    break block4;
                }
                this.compact();
                this.data.addAll(list);
                this.start = 0;
                this.end = this.data.size();
                if (this.end >= rbs) break;
            }
            this.paging();
        }
    }

    private void compact() {
        int size = this.left();
        if (this.start > 0 && size > 0) {
            ArrayList<T> last = new ArrayList<T>(size);
            last.addAll(this.data.subList(this.start, this.end));
            this.data.clear();
            this.data.addAll(last);
        } else if (this.start > 0) {
            this.data.clear();
        }
    }

    protected Class<?> getTClass() {
        Type type;
        Class clazz = this.tClazz;
        if (clazz != null) {
            return clazz;
        }
        if (this.getClass().getGenericSuperclass() instanceof ParameterizedType && (type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]) instanceof Class) {
            clazz = (Class)type;
        }
        if (clazz == null) {
            T o = this.getFirst();
            if (o == null) {
                return null;
            }
            clazz = o.getClass();
        }
        this.tClazz = clazz;
        return clazz;
    }

    protected int init() {
        boolean forceExport;
        Class<?> clazz = this.getTClass();
        if (clazz == null) {
            return this.columns != null ? this.columns.length : 0;
        }
        HashMap<String, Method> tmp = new HashMap<String, Method>();
        try {
            tmp.putAll(ReflectUtil.readMethodsMap(clazz, Object.class));
        }
        catch (IntrospectionException e) {
            this.LOGGER.warn("Get class {} methods failed.", clazz);
        }
        Field[] declaredFields = ReflectUtil.listDeclaredFieldsUntilJavaPackage(clazz, c -> !this.ignoreColumn((AccessibleObject)c));
        boolean bl = forceExport = this.forceExport == 1;
        if (!this.hasHeaderColumns()) {
            ArrayList<Column> list = new ArrayList<Column>(declaredFields.length);
            HashMap<String, Method> existsMethod = new HashMap<String, Method>(declaredFields.length);
            for (int i = 0; i < declaredFields.length; ++i) {
                EntryColumn tail;
                EntryColumn column;
                Field field = declaredFields[i];
                field.setAccessible(true);
                String gs = field.getName();
                Method method = (Method)tmp.get(gs);
                if (method != null) {
                    existsMethod.put(gs, method);
                    if (this.ignoreColumn(method)) {
                        declaredFields[i] = null;
                        continue;
                    }
                    column = this.createColumn(method);
                    if (column == null && forceExport) {
                        column = new EntryColumn(gs, "");
                    }
                    if (column != null) {
                        tail = (EntryColumn)column.getTail();
                        tail.method = method;
                        tail.field = field;
                        tail.clazz = method.getReturnType();
                        tail.key = gs;
                        if (StringUtil.isEmpty(tail.name)) {
                            tail.name = gs;
                        }
                        list.add(column);
                        this.buildHeaderStyle(method, field, tail);
                        this.buildHeaderComment(method, field, tail);
                        continue;
                    }
                }
                if ((column = this.createColumn(field)) == null && forceExport) {
                    column = new EntryColumn(gs, "");
                }
                if (column == null) continue;
                list.add(column);
                tail = (EntryColumn)column.getTail();
                tail.field = field;
                tail.key = gs;
                if (StringUtil.isEmpty(tail.name)) {
                    tail.name = gs;
                }
                if (method != null) {
                    tail.clazz = method.getReturnType();
                    tail.method = method;
                } else {
                    tail.clazz = field.getType();
                }
                this.buildHeaderStyle(method, field, tail);
                this.buildHeaderComment(method, field, tail);
            }
            List<Column> attachList = this.attachOtherColumn(existsMethod, clazz);
            if (attachList != null) {
                list.addAll(attachList);
            }
            if (list.isEmpty()) {
                if (this.cellValueAndStyle.isAllowDirectOutput(clazz)) {
                    list.add(new EntryColumn().setClazz(clazz));
                } else {
                    this.shouldClose = true;
                    this.eof = true;
                    this.headerReady = true;
                    this.end = 0;
                    if (Map.class.isAssignableFrom(clazz)) {
                        this.LOGGER.warn("List<Map> has detected, please use ListMapSheet for export.");
                    } else {
                        this.LOGGER.warn("Class [{}] do not contains properties to export.", clazz);
                    }
                    return 0;
                }
            }
            this.columns = new Column[list.size()];
            list.toArray(this.columns);
        } else {
            Method[] others = this.filterOthersMethodsCanExport(Collections.emptyMap(), clazz);
            HashMap<String, Method> otherMap = new HashMap<String, Method>();
            for (Method m : others) {
                ExcelColumn ec = m.getAnnotation(ExcelColumn.class);
                if (ec != null && StringUtil.isNotEmpty(ec.value())) {
                    otherMap.put(ec.value(), m);
                }
                otherMap.put(m.getName(), m);
            }
            for (int i = 0; i < this.columns.length; ++i) {
                Column hc;
                this.columns[i] = hc = new EntryColumn(this.columns[i]);
                if (hc.tail != null) {
                    hc = hc.tail;
                }
                if (StringUtil.isEmpty(hc.key)) {
                    hc.key = hc.name;
                }
                Column ec = hc;
                if (((EntryColumn)ec).method == null) {
                    Method method = (Method)tmp.get(hc.key);
                    if (method != null) {
                        ((EntryColumn)ec).method = method;
                    } else {
                        method = (Method)otherMap.get(hc.key);
                        if (method != null) {
                            ((EntryColumn)ec).method = method;
                        }
                    }
                }
                if (((EntryColumn)ec).field == null) {
                    for (Field field : declaredFields) {
                        if (!field.getName().equals(hc.key)) continue;
                        field.setAccessible(true);
                        ((EntryColumn)ec).field = field;
                        break;
                    }
                }
                if (((EntryColumn)ec).method == null && ((EntryColumn)ec).field == null) {
                    if (this.columns.length > 1) {
                        this.LOGGER.warn("Column [" + hc.getName() + "(" + hc.key + ")] not declare in class " + clazz);
                        hc.ignoreValue();
                    } else {
                        this.LOGGER.warn("Column one does not specify method or filed");
                    }
                } else if (hc.getClazz() == null) {
                    hc.setClazz(((EntryColumn)ec).method != null ? ((EntryColumn)ec).method.getReturnType() : ((EntryColumn)ec).field.getType());
                }
                if (hc.getHeaderStyleIndex() == -1) {
                    this.buildHeaderStyle(((EntryColumn)ec).method, ((EntryColumn)ec).field, hc);
                }
                if (hc.headerComment != null) continue;
                this.buildHeaderComment(((EntryColumn)ec).method, ((EntryColumn)ec).field, hc);
            }
        }
        this.mergeGlobalSetting(clazz);
        return this.columns.length;
    }

    protected EntryColumn createColumn(AccessibleObject ao) {
        Hyperlink Hyperlink2;
        MediaColumn mediaColumn;
        if (this.ignoreColumn(ao)) {
            return null;
        }
        ao.setAccessible(true);
        StyleProcessor<?> sp = this.getDesignStyle(ao);
        EntryColumn root = null;
        ExcelColumns cs = ao.getAnnotation(ExcelColumns.class);
        if (cs != null) {
            ExcelColumn[] ecs;
            for (ExcelColumn ec : ecs = cs.value()) {
                EntryColumn column = this.createColumnByAnnotation(ec);
                if (sp != null) {
                    column.styleProcessor = sp;
                }
                if (root == null) {
                    root = column;
                    continue;
                }
                root.addSubColumn(column);
            }
        } else {
            ExcelColumn ec = ao.getAnnotation(ExcelColumn.class);
            if (ec != null) {
                root = this.createColumnByAnnotation(ec);
                if (sp != null) {
                    root.styleProcessor = sp;
                }
            }
        }
        if ((mediaColumn = ao.getAnnotation(MediaColumn.class)) != null) {
            if (root == null) {
                root = new EntryColumn(" ", "");
            }
            Column tail = root.getTail();
            tail.writeAsMedia();
            if (mediaColumn.presetEffect() != PresetPictureEffect.None) {
                tail.setEffect(mediaColumn.presetEffect().getEffect());
            }
        } else if (root != null && (Hyperlink2 = ao.getAnnotation(Hyperlink.class)) != null) {
            root.getTail().writeAsHyperlink();
        }
        return root;
    }

    protected EntryColumn createColumnByAnnotation(ExcelColumn ec) {
        if (ec == null) {
            return null;
        }
        EntryColumn column = new EntryColumn(ec.value(), "");
        column.setShare(ec.share());
        if (StringUtil.isNotEmpty(ec.format())) {
            column.setNumFmt(ec.format());
        }
        column.setWrapText(ec.wrapText());
        if (ec.colIndex() > -1) {
            column.colIndex = ec.colIndex();
        }
        if (ec.hide()) {
            column.hide();
        }
        if (ec.maxWidth() >= 0.0) {
            column.width = ec.maxWidth();
        }
        if (!Converter.None.class.isAssignableFrom(ec.converter())) {
            try {
                column.setConverter(ec.converter().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.LOGGER.warn("Construct {} error occur, it will be ignore.", ec.converter(), (Object)e);
            }
        }
        return column;
    }

    protected void buildHeaderStyle(AccessibleObject main, AccessibleObject sub, Column column) {
        HeaderStyle hs = null;
        if (main != null) {
            hs = main.getAnnotation(HeaderStyle.class);
        }
        if (hs == null && sub != null) {
            hs = sub.getAnnotation(HeaderStyle.class);
        }
        if (hs != null) {
            column.setHeaderStyle(this.buildHeadStyle(hs.fontColor(), hs.fillFgColor()));
        }
    }

    protected void buildHeaderComment(AccessibleObject main, AccessibleObject sub, Column column) {
        ExcelColumn ec;
        HeaderComment comment = null;
        if (main != null && (comment = main.getAnnotation(HeaderComment.class)) == null && (ec = main.getAnnotation(ExcelColumn.class)) != null) {
            comment = ec.comment();
        }
        if (comment == null && sub != null && (comment = sub.getAnnotation(HeaderComment.class)) == null && (ec = sub.getAnnotation(ExcelColumn.class)) != null) {
            comment = ec.comment();
        }
        if (comment != null && (StringUtil.isNotEmpty(comment.value()) || StringUtil.isNotEmpty(comment.title()))) {
            column.headerComment = new Comment(comment.title(), comment.value(), comment.width(), comment.height());
        }
    }

    protected void mergeGlobalSetting(Class<?> clazz) {
        StyleProcessor<?> styleProcessor;
        HeaderStyle headerStyle = clazz.getDeclaredAnnotation(HeaderStyle.class);
        int style = 0;
        if (headerStyle != null) {
            style = this.buildHeadStyle(headerStyle.fontColor(), headerStyle.fillFgColor());
        }
        for (Column column : this.columns) {
            if (style <= 0 || column.getHeaderStyleIndex() != -1 || column.headerStyle != null) continue;
            column.setHeaderStyle(style);
        }
        if (this.styleProcessor == null && (styleProcessor = this.getDesignStyle(clazz)) != null) {
            this.setStyleProcessor(styleProcessor);
        }
        this.attachFreezePanes(clazz);
    }

    protected StyleProcessor<?> getDesignStyle(Class<?> clazz) {
        StyleDesign styleDesign = clazz.getDeclaredAnnotation(StyleDesign.class);
        return this.getDesignStyle(styleDesign);
    }

    protected StyleProcessor<?> getDesignStyle(AccessibleObject ao) {
        StyleDesign styleDesign = ao.getAnnotation(StyleDesign.class);
        return this.getDesignStyle(styleDesign);
    }

    protected StyleProcessor<?> getDesignStyle(StyleDesign styleDesign) {
        if (styleDesign != null && !StyleProcessor.None.class.isAssignableFrom(styleDesign.using())) {
            try {
                return styleDesign.using().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.LOGGER.warn("Construct {} error occur, it will be ignore.", styleDesign.using(), (Object)e);
            }
        }
        return null;
    }

    protected boolean ignoreColumn(AccessibleObject ao) {
        return ao.getAnnotation(IgnoreExport.class) != null;
    }

    protected List<Column> attachOtherColumn(Map<String, Method> existsMethodMapper, Class<?> clazz) {
        Method[] readMethods = this.filterOthersMethodsCanExport(existsMethodMapper, clazz);
        if (readMethods != null) {
            HashSet<Method> existsMethods = new HashSet<Method>(existsMethodMapper.values());
            ArrayList<Column> list = new ArrayList<Column>();
            for (Method method : readMethods) {
                EntryColumn column;
                if (existsMethods.contains(method) || (column = this.createColumn(method)) == null) continue;
                list.add(column);
                EntryColumn tail = (EntryColumn)column.getTail();
                tail.method = method;
                tail.clazz = method.getReturnType();
                tail.key = method.getName();
                if (StringUtil.isEmpty(tail.name)) {
                    tail.name = method.getName();
                    if (tail.name.startsWith("get")) {
                        tail.name = StringUtil.lowFirstKey(tail.name.substring(3));
                    } else if (tail.name.startsWith("is")) {
                        tail.name = StringUtil.lowFirstKey(tail.name.substring(2));
                    }
                }
                this.buildHeaderStyle(method, null, tail);
                this.buildHeaderComment(method, null, tail);
            }
            return list;
        }
        return null;
    }

    @Override
    protected Column[] getHeaderColumns() {
        int size;
        if (!this.headerReady && (size = this.init()) <= 0) {
            this.columns = new Column[0];
        }
        return this.columns;
    }

    protected int getEndIndex() {
        int rowLimit;
        int blockSize = this.rowBlock.capacity();
        if (this.rows + blockSize > (rowLimit = this.getRowLimit())) {
            blockSize = rowLimit - this.rows;
        }
        int end = this.start + blockSize;
        return Math.min(end, this.end);
    }

    protected int left() {
        return this.end - this.start;
    }

    @Override
    protected void paging() {
        int limit;
        int len = this.dataSize();
        if (len + this.rows > (limit = this.getRowLimit())) {
            this.end = limit - this.rows + this.start;
            this.shouldClose = false;
            this.eof = true;
            int n = this.id;
            int i = this.end;
            while (i < len) {
                ListSheet copy = (ListSheet)this.getClass().cast(this.clone());
                copy.start = i;
                copy.end = i = Math.min(i + limit, len);
                copy.eof = copy.end - copy.start == limit;
                this.workbook.insertSheet(n++, copy);
            }
            this.workbook.getSheetAt((int)(n - 1)).shouldClose = true;
        } else {
            this.end = len;
        }
    }

    public int dataSize() {
        return this.data != null ? this.data.size() : 0;
    }

    protected List<T> more() {
        if (this.dataSupplier != null) {
            int offset = this.left() + (this.rowBlock != null ? this.rowBlock.getTotal() : 0);
            if (this.copySheet) {
                offset += this.copyCount * this.workbook.getSheetAt(this.id - 2).size();
            }
            return this.dataSupplier.apply(offset, (Integer)(this.data != null && !this.data.isEmpty() ? (Object)this.data.get(this.data.size() - 1) : null));
        }
        return null;
    }

    protected void attachFreezePanes(Class<?> clazz) {
        if (this.getExtPropValue("freeze") != null) {
            return;
        }
        FreezePanes panes = clazz.getAnnotation(FreezePanes.class);
        if (panes == null) {
            return;
        }
        if (panes.topRow() < 0 || panes.firstColumn() < 0) {
            throw new IllegalArgumentException("negative number occur.");
        }
        if ((panes.topRow() | panes.firstColumn()) == 0) {
            return;
        }
        this.putExtProp("freeze", Panes.of(panes.topRow(), panes.firstColumn()));
    }

    protected Method[] filterOthersMethodsCanExport(Map<String, Method> existsMethodMapper, Class<?> clazz) {
        Method[] readMethods = null;
        try {
            Collection<Method> values = existsMethodMapper.values();
            readMethods = ReflectUtil.listReadMethods(clazz, method -> method.getAnnotation(ExcelColumn.class) != null && method.getAnnotation(IgnoreExport.class) == null && !values.contains(method));
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return readMethods;
    }

    public Sheet forceExport() {
        this.forceExport = 1;
        return this;
    }

    public Sheet cancelForceExport() {
        this.forceExport = 2;
        return this;
    }

    @Override
    public int getForceExport() {
        return this.forceExport;
    }

    @Override
    public int writeData(List<T> data) throws IOException {
        if (this.workbook == null) {
            throw new IOException("Before writing data, worksheet must be added to the workbook.");
        }
        if (!this.headerReady) {
            this.forWrite();
        }
        this.sheetWriter.writeData(this.fillRowBlock(data));
        return this.rows;
    }

    protected RowBlock fillRowBlock(List<T> data) {
        if (data == null || data.isEmpty()) {
            return this.rowBlock;
        }
        if (this.rows + data.size() > this.sheetWriter.getRowLimit()) {
            throw new IndexOutOfBoundsException("Max rows:" + this.sheetWriter.getRowLimit() + ", current:" + (this.rows + data.size()));
        }
        if (!this.headerReady) {
            this.data = data;
            this.getAndSortHeaderColumns();
            this.data = null;
            if (this.rowBlock == null) {
                this.rowBlock = new RowBlock(Math.max(this.getRowBlockSize(), data.size()));
            }
        } else if (this.rowBlock.capacity() < data.size()) {
            this.rowBlock = new RowBlock(data.size());
        } else {
            this.rowBlock.clear();
        }
        this.resetRowBlock(data, 0, data.size());
        return this.rowBlock.flip();
    }

    protected void resetRowBlock(List<T> data, int fromIndex, int toIndex) {
        if (data == null || fromIndex >= data.size()) {
            return;
        }
        while (fromIndex < toIndex) {
            Row row = this.rowBlock.next();
            row.index = this.rows++;
            row.height = this.getRowHeight();
            this.resetRowData(row, data.get(fromIndex));
            ++fromIndex;
        }
    }

    protected void resetRowData(Row row, T rowData) {
        int len = this.columns.length;
        Cell[] cells = row.realloc(len);
        boolean nonNull = rowData != null;
        try {
            for (int i = 0; i < len; ++i) {
                Object e = null;
                EntryColumn column = (EntryColumn)this.columns[i];
                if (nonNull && !column.isIgnoreValue()) {
                    e = column.getMethod() != null ? column.getMethod().invoke(rowData, new Object[0]) : (column.getField() != null ? column.getField().get(rowData) : (Object)rowData);
                }
                this.resetCellValueAndStyle(row, cells[i], rowData, e, column);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ExcelWriteException(e);
        }
    }

    protected void resetCellValueAndStyle(Row row, Cell cell, T rowData, Object cellData, Column column) {
        this.cellValueAndStyle.reset(row, cell, cellData, column);
        if ((this.extPropMark & 2) == 2) {
            this.cellValueAndStyle.setStyleDesign(rowData, cell, column, this.getStyleProcessor());
        }
    }

    public static class EntryColumn
    extends Column {
        public Method method;
        public Field field;

        public EntryColumn() {
        }

        public EntryColumn(String name) {
            this.name = name;
        }

        public EntryColumn(String name, Class<?> clazz) {
            super(name, clazz);
        }

        public EntryColumn(String name, String key) {
            super(name, key);
        }

        public EntryColumn(String name, String key, Class<?> clazz) {
            super(name, key, clazz);
        }

        public EntryColumn(String name, Class<?> clazz, ConversionProcessor processor) {
            super(name, clazz, processor);
        }

        public EntryColumn(String name, String key, ConversionProcessor processor) {
            super(name, key, processor);
        }

        @Deprecated
        public EntryColumn(String name, Class<?> clazz, boolean share) {
            super(name, clazz, share);
        }

        @Deprecated
        public EntryColumn(String name, String key, boolean share) {
            super(name, key, share);
        }

        @Deprecated
        public EntryColumn(String name, Class<?> clazz, ConversionProcessor processor, boolean share) {
            super(name, clazz, processor, share);
        }

        @Deprecated
        public EntryColumn(String name, String key, Class<?> clazz, ConversionProcessor processor) {
            super(name, key, clazz, processor);
        }

        @Deprecated
        public EntryColumn(String name, String key, ConversionProcessor processor, boolean share) {
            super(name, key, processor, share);
        }

        @Deprecated
        public EntryColumn(String name, Class<?> clazz, int cellStyle) {
            super(name, clazz, cellStyle);
        }

        @Deprecated
        public EntryColumn(String name, String key, int cellStyle) {
            super(name, key, cellStyle);
        }

        @Deprecated
        public EntryColumn(String name, Class<?> clazz, int cellStyle, boolean share) {
            super(name, clazz, cellStyle, share);
        }

        @Deprecated
        public EntryColumn(String name, String key, int cellStyle, boolean share) {
            super(name, key, cellStyle, share);
        }

        public EntryColumn(Column other) {
            super.from(other);
            if (other instanceof EntryColumn) {
                EntryColumn o = (EntryColumn)other;
                this.method = o.method;
                this.field = o.field;
            }
            if (other.next != null) {
                this.addSubColumn(new EntryColumn(other.next));
            }
        }

        public Method getMethod() {
            return this.method;
        }

        public Field getField() {
            return this.field;
        }
    }
}

