/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.Comments;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.ICellValueAndStyle;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.entity.TooManyColumnsException;
import org.ttzero.excel.entity.Watermark;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.entity.e7.XMLWorksheetWriter;
import org.ttzero.excel.entity.style.Border;
import org.ttzero.excel.entity.style.BorderStyle;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.PatternType;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.util.ExtBufferedWriter;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

public abstract class Sheet
implements Cloneable,
Storable {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Workbook workbook;
    protected String name;
    protected Column[] columns;
    protected Watermark watermark;
    protected RelManager relManager;
    protected int id;
    protected Comments comments;
    protected int autoSize;
    protected double width = 20.0;
    protected int rows;
    protected boolean hidden;
    protected int headStyleIndex = -1;
    protected int headStyle;
    protected int zebraFillStyle = -1;
    protected Fill zebraFill;
    protected boolean copySheet;
    protected int copyCount;
    protected RowBlock rowBlock;
    protected IWorksheetWriter sheetWriter;
    protected boolean headerReady;
    protected boolean shouldClose = true;
    protected ICellValueAndStyle cellValueAndStyle;
    protected int nonHeader = -1;
    private int rowLimit;
    protected Map<String, Object> extProp = new HashMap<String, Object>();
    protected int extPropMark;
    protected Boolean showGridLines;
    protected double headerRowHeight = 20.5;
    protected Double rowHeight;
    protected long startCoordinate;
    protected BiConsumer<Sheet, Integer> progressConsumer;
    private static final char[][] tmpBuf = new char[][]{{'A'}, {'A', 'A'}, {'A', 'A', 'A'}};

    public int getId() {
        return this.id;
    }

    public Sheet setId(int id) {
        this.id = id;
        return this;
    }

    public Sheet setSheetWriter(IWorksheetWriter sheetWriter) {
        this.sheetWriter = sheetWriter;
        this.sheetWriter.setWorksheet(this);
        return this;
    }

    public IWorksheetWriter getSheetWriter() {
        return this.sheetWriter;
    }

    public Sheet setCellValueAndStyle(ICellValueAndStyle cellValueAndStyle) {
        this.cellValueAndStyle = cellValueAndStyle;
        return this;
    }

    public ICellValueAndStyle getCellValueAndStyle() {
        return this.cellValueAndStyle;
    }

    public Sheet() {
        this.relManager = new RelManager();
    }

    public Sheet(String name) {
        this.name = name;
        this.relManager = new RelManager();
    }

    public Sheet(Column ... columns) {
        this((String)null, columns);
    }

    public Sheet(String name, Column ... columns) {
        this.name = name;
        this.columns = columns;
        this.relManager = new RelManager();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet setWorkbook(Workbook workbook) {
        this.workbook = workbook;
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].styles = workbook.getStyles();
            }
        }
        return this;
    }

    public double getDefaultWidth() {
        return this.width;
    }

    public Sheet autoSize() {
        this.autoSize = 1;
        return this;
    }

    public int getAutoSize() {
        return this.autoSize;
    }

    public boolean isAutoSize() {
        return this.autoSize == 1;
    }

    public Sheet fixedSize() {
        this.autoSize = 2;
        return this;
    }

    public Sheet fixedSize(double width) {
        if (width < 0.0) {
            this.LOGGER.warn("Negative number {}", (Object)width);
            width = 0.0;
        } else if (width > 255.0) {
            this.LOGGER.warn("Maximum width is {}, current is {}", (Object)255, (Object)width);
            width = 255.0;
        }
        this.autoSize = 2;
        this.width = width;
        if (this.headerReady) {
            for (Column hc : this.columns) {
                hc.fixedSize(width);
            }
        }
        return this;
    }

    public Sheet setZebraLine(Fill fill) {
        this.zebraFill = fill;
        return this;
    }

    public Sheet cancelZebraLine() {
        this.zebraFill = null;
        this.zebraFillStyle = 0;
        return this;
    }

    public Fill getZebraFill() {
        return this.zebraFill != null ? this.zebraFill : this.workbook.getZebraFill();
    }

    public int getZebraFillStyle() {
        if (this.zebraFillStyle < 0 && this.zebraFill != null) {
            this.zebraFillStyle = this.workbook.getStyles().addFill(this.zebraFill);
        }
        return this.zebraFillStyle;
    }

    public Sheet defaultZebraLine() {
        return this.setZebraLine(new Fill(PatternType.solid, new Color(233, 234, 236)));
    }

    public String getName() {
        return this.name;
    }

    public Sheet setName(String name) {
        if (name != null && name.length() > 31) {
            this.LOGGER.warn("The worksheet name is too long, maximum length of 31 characters. Currently {}", (Object)name.length());
            name = name.substring(0, 31);
        }
        this.name = name;
        return this;
    }

    public Comments getComments() {
        if (this.comments != null && this.comments.id == 0) {
            this.comments.id = this.id;
        }
        return this.comments;
    }

    public Comments createComments() {
        if (this.comments == null) {
            this.comments = new Comments(this.id, this.workbook != null ? this.workbook.getCreator() : null);
            if (this.id > 0) {
                this.addRel(new Relationship("../drawings/vmlDrawing" + this.id + ".vml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing"));
                this.addRel(new Relationship("../comments" + this.id + ".xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments"));
            }
        }
        return this.comments;
    }

    public boolean isShowGridLines() {
        return this.showGridLines == null || this.showGridLines != false;
    }

    public Sheet showGridLines() {
        this.showGridLines = true;
        return this;
    }

    public Sheet hideGridLines() {
        this.showGridLines = false;
        return this;
    }

    public double getHeaderRowHeight() {
        return this.headerRowHeight;
    }

    public Sheet setHeaderRowHeight(double headerRowHeight) {
        this.headerRowHeight = headerRowHeight;
        return this;
    }

    public Double getRowHeight() {
        return this.rowHeight;
    }

    public Sheet setRowHeight(double rowHeight) {
        this.rowHeight = rowHeight;
        return this;
    }

    public int getStartRowNum() {
        return this.startCoordinate != 0L ? (int)(Math.abs(this.startCoordinate) >>> 16) : 1;
    }

    public int getStartColNum() {
        return this.startCoordinate != 0L ? (int)(Math.abs(this.startCoordinate) & 0x7FFFL) : 1;
    }

    public boolean isScrollToVisibleArea() {
        return this.startCoordinate > 0L;
    }

    public Sheet setStartCoordinate(String coordinate) {
        return this.setStartCoordinate(coordinate, false);
    }

    public Sheet setStartCoordinate(String coordinate, boolean scrollToVisibleArea) {
        long f = ExcelReader.coordinateToLong(coordinate);
        return this.setStartCoordinate((int)(f >> 16), (int)f & Short.MAX_VALUE, scrollToVisibleArea);
    }

    public Sheet setStartCoordinate(int startRowNum) {
        return this.setStartCoordinate(startRowNum, 1, false);
    }

    public Sheet setStartCoordinate(int startRowNum, boolean scrollToVisibleArea) {
        return this.setStartCoordinate(startRowNum, 1, scrollToVisibleArea);
    }

    public Sheet setStartCoordinate(int startRowNum, int startColNum) {
        return this.setStartCoordinate(startRowNum, startColNum, false);
    }

    public Sheet setStartCoordinate(int startRowNum, int startColNum, boolean scrollToVisibleArea) {
        if (startRowNum <= 0) {
            throw new IndexOutOfBoundsException("The start row num must be greater than 0, current = " + startRowNum);
        }
        if (this.sheetWriter != null && this.sheetWriter.getRowLimit() <= startRowNum) {
            throw new IndexOutOfBoundsException("The start row num must be less than row-limit, current(" + startRowNum + ") >= limit(" + this.sheetWriter.getRowLimit() + ")");
        }
        if (startColNum <= 0) {
            throw new IndexOutOfBoundsException("The start col num must be greater than 0, current = " + startColNum);
        }
        if (this.sheetWriter != null && this.sheetWriter.getColumnLimit() <= startColNum) {
            throw new IndexOutOfBoundsException("The start col num must be less than col-limit, current(" + startColNum + ") >= limit(" + this.sheetWriter.getColumnLimit() + ")");
        }
        long coordinate = (long)startRowNum << 16 | (long)(startColNum & Short.MAX_VALUE);
        this.startCoordinate = scrollToVisibleArea ? coordinate : -coordinate;
        return this;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Sheet onProgress(BiConsumer<Sheet, Integer> progressConsumer) {
        this.progressConsumer = progressConsumer;
        return this;
    }

    public BiConsumer<Sheet, Integer> getProgressConsumer() {
        return this.progressConsumer;
    }

    protected Column[] getHeaderColumns() {
        if (!this.headerReady && this.columns == null) {
            this.columns = new Column[0];
        }
        return this.columns;
    }

    public Column[] getAndSortHeaderColumns() {
        if (!this.headerReady) {
            this.columns = this.getHeaderColumns();
            this.headerReady |= this.columns.length > 0;
            if (this.headerReady) {
                this.sortColumns(this.columns);
                this.calculateRealColIndex();
                this.reverseHeadColumn();
                this.mergeHeaderCellsIfEquals();
                this.resetCommonProperties(this.columns);
                this.checkColumnLimit();
            }
            this.markExtProp();
        }
        return this.columns;
    }

    protected void resetCommonProperties(Column[] columns) {
        for (Column column : columns) {
            if (column == null) continue;
            if (column.styles == null) {
                column.styles = this.workbook.getStyles();
            }
            if (column.next != null) {
                Column col = column.next;
                while (col != null) {
                    col.styles = this.workbook.getStyles();
                    col = col.next;
                }
            }
            if (column.getAutoSize() != 0 || this.autoSize <= 0) continue;
            column.option |= this.autoSize << 1;
        }
    }

    protected void sortColumns(Column[] columns) {
        if (columns.length <= 1) {
            return;
        }
        int j = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getTail().colIndex < 0) continue;
            int n = this.search(columns, j, columns[i].getTail().colIndex);
            if (n < i) {
                this.insert(columns, n, i);
            }
            ++j;
        }
        if (j == columns.length) {
            return;
        }
        int n = columns[0].getTail().colIndex;
        int i = 0;
        while (i < columns.length && j < columns.length) {
            if (n > i) {
                int k = Math.min(n - i, columns.length - j);
                while (k > 0) {
                    this.insert(columns, i++, j);
                    --k;
                    ++j;
                }
            } else {
                ++i;
            }
            if (i >= columns.length) continue;
            n = columns[i].getTail().colIndex;
        }
    }

    protected int search(Column[] columns, int n, int k) {
        int i;
        for (i = 0; i < n && columns[i].getTail().colIndex <= k; ++i) {
        }
        return i;
    }

    protected void insert(Column[] columns, int n, int k) {
        Column t = columns[k];
        System.arraycopy(columns, n, columns, n + 1, k - n);
        columns[n] = t;
    }

    protected void calculateRealColIndex() {
        int startColNum = this.getStartColNum();
        for (int i = 0; i < this.columns.length; ++i) {
            Column hc = this.columns[i].getTail();
            hc.colNum = hc.colIndex;
            hc.colNum = i > 0 && this.columns[i - 1].colNum >= hc.colNum ? this.columns[i - 1].colNum + 1 : (hc.colNum <= i ? i + startColNum : hc.colIndex + startColNum);
            if (hc.prev == null) continue;
            Column col = hc.prev;
            while (col != null) {
                col.colNum = hc.colNum;
                col = col.prev;
            }
        }
    }

    public Sheet setColumns(Column ... columns) {
        this.columns = columns;
        return this;
    }

    public Sheet setColumns(List<Column> columns) {
        if (columns != null && !columns.isEmpty()) {
            this.columns = new Column[columns.size()];
            columns.toArray(this.columns);
        }
        return this;
    }

    public Watermark getWatermark() {
        return this.watermark;
    }

    public Sheet setWatermark(Watermark watermark) {
        this.watermark = watermark;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Sheet hidden() {
        this.hidden = true;
        return this;
    }

    public int getForceExport() {
        return 0;
    }

    public void close() throws IOException {
        if (this.sheetWriter != null) {
            this.sheetWriter.close();
        }
    }

    @Override
    public void writeTo(Path path) throws IOException {
        if (this.sheetWriter == null) {
            throw new ExcelWriteException("Worksheet writer is not instanced.");
        }
        if (!this.headerReady) {
            this.getAndSortHeaderColumns();
        }
        if (this.rowBlock == null) {
            this.rowBlock = new RowBlock(this.getRowBlockSize());
        } else {
            this.rowBlock.reopen();
        }
        if (!this.copySheet) {
            this.paging();
        }
        this.sheetWriter.writeTo(path);
    }

    protected void paging() {
    }

    public Sheet addRel(Relationship rel) {
        this.relManager.add(rel);
        return this;
    }

    public Relationship findRel(String key) {
        return this.relManager.likeByTarget(key);
    }

    public RelManager getRelManager() {
        return this.relManager;
    }

    public String getFileName() {
        return "sheet" + this.id + this.sheetWriter.getFileSuffix();
    }

    public Sheet setHeadStyle(int style) {
        this.headStyle = style;
        this.headStyleIndex = this.workbook.getStyles().of(style);
        return this;
    }

    public Sheet setHeadStyleIndex(int styleIndex) {
        this.headStyleIndex = styleIndex;
        this.headStyle = this.workbook.getStyles().getStyleByIndex(styleIndex);
        return this;
    }

    public int getHeadStyle() {
        return this.headStyle;
    }

    public int getHeadStyleIndex() {
        return this.headStyleIndex;
    }

    public int buildHeadStyle(String fontColor, String fillBgColor) {
        Styles styles = this.workbook.getStyles();
        return styles.addFont(new Font("\u5b8b\u4f53", 12, 2, Styles.toColor(fontColor))) | styles.addFill(Fill.parse(fillBgColor)) | styles.addBorder(new Border(BorderStyle.THIN, new Color(191, 191, 191))) | 0 | 6;
    }

    public int defaultHeadStyle() {
        return this.headStyle != 0 ? this.headStyle : (this.headStyle = this.buildHeadStyle("black", "#E9EAEC"));
    }

    public int defaultHeadStyleIndex() {
        if (this.headStyleIndex == -1) {
            this.setHeadStyle(this.buildHeadStyle("black", "#E9EAEC"));
        }
        return this.headStyleIndex;
    }

    public int size() {
        return this.rows;
    }

    public RowBlock nextBlock() {
        this.rowBlock.clear();
        if (this.columns.length > 0) {
            this.resetBlockData();
        }
        return this.rowBlock.flip();
    }

    public int getRowBlockSize() {
        return 32;
    }

    public void afterSheetDataWriter(int total) {
    }

    public void afterSheetAccess(Path workSheetPath) throws IOException {
        if (this.sheetWriter instanceof XMLWorksheetWriter) {
            this.relManager.write(workSheetPath, this.getFileName());
        }
    }

    protected String getCopySheetName() {
        int sub = this.copyCount;
        String _name = this.name;
        int i = this.name.lastIndexOf(40);
        if (i > 0) {
            int fs = Integer.parseInt(this.name.substring(i + 1, this.name.lastIndexOf(41)));
            _name = this.name.substring(0, this.name.charAt(i - 1) == ' ' ? i - 1 : i);
            if (++fs > sub) {
                sub = fs;
            }
        }
        return _name + " (" + sub + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sheet clone() {
        Sheet copy;
        block10: {
            copy = null;
            try {
                copy = (Sheet)super.clone();
            }
            catch (CloneNotSupportedException e) {
                ObjectOutputStream oos = null;
                ObjectInputStream ois = null;
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    oos = new ObjectOutputStream(bos);
                    oos.writeObject(this);
                    ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
                    copy = (Sheet)ois.readObject();
                    FileUtil.close(oos);
                }
                catch (IOException | ClassNotFoundException e1) {
                    try {
                        copy = (Sheet)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                    break block10;
                }
                finally {
                    FileUtil.close(oos);
                    FileUtil.close(ois);
                }
                FileUtil.close(ois);
            }
        }
        if (copy != null) {
            copy.copyCount = ++this.copyCount;
            copy.id = 0;
            copy.name = this.getCopySheetName();
            copy.relManager = this.relManager.deepClone();
            copy.sheetWriter = this.sheetWriter.clone().setWorksheet(copy);
            copy.copySheet = true;
            copy.rows = 0;
        }
        return copy;
    }

    public void checkColumnLimit() {
        int b;
        int a = this.columns.length > 0 ? this.columns[this.columns.length - 1].getColNum() : 0;
        if (a > (b = this.sheetWriter.getColumnLimit())) {
            throw new TooManyColumnsException(a, b);
        }
        if (this.nonHeader == -1 && this.headerReady) {
            boolean noneHeader;
            boolean bl = noneHeader = this.columns == null || this.columns.length == 0;
            if (!noneHeader) {
                int n = 0;
                for (Column column : this.columns) {
                    if (!StringUtil.isEmpty(column.name) || !StringUtil.isEmpty(column.key)) continue;
                    ++n;
                }
                boolean bl2 = noneHeader = n == this.columns.length;
            }
            if (noneHeader) {
                if (this.rows > 0) {
                    --this.rows;
                }
                this.ignoreHeader();
            } else {
                this.nonHeader = 0;
            }
        }
    }

    public boolean hasHeaderColumns() {
        return this.columns != null && this.columns.length > 0;
    }

    public static char[] int2Col(int n) {
        char[] c;
        int A = 65;
        if (n <= 26) {
            c = tmpBuf[0];
            c[0] = (char)(n - 1 + A);
        } else if (n <= 702) {
            int t = n / 26;
            int w = n % 26;
            if (w == 0) {
                --t;
                w = 26;
            }
            c = tmpBuf[1];
            c[0] = (char)(t - 1 + A);
            c[1] = (char)(w - 1 + A);
        } else {
            int tt = n / 26;
            int t = tt / 26;
            int w = n % 26;
            int m = tt % 26;
            if (w == 0) {
                --m;
                w = 26;
            }
            if (m <= 0) {
                --t;
                m += 26;
            }
            c = tmpBuf[2];
            c[0] = (char)(t - 1 + A);
            c[1] = (char)(m - 1 + A);
            c[2] = (char)(w - 1 + A);
        }
        return c;
    }

    public static String toCoordinate(int row, int col) {
        char[] cols = Sheet.int2Col(col);
        char[] chars = new char[cols.length + ExtBufferedWriter.stringSize(row)];
        System.arraycopy(cols, 0, chars, 0, cols.length);
        ExtBufferedWriter.getChars(row, chars.length, chars);
        return new String(chars);
    }

    public Sheet ignoreHeader() {
        this.nonHeader = 1;
        return this;
    }

    public int getNonHeader() {
        return this.nonHeader;
    }

    protected int getRowLimit() {
        return this.rowLimit > 0 ? this.rowLimit : (this.rowLimit = this.sheetWriter.getRowLimit() - (this.nonHeader == 1 || this.columns.length == 0 ? 0 : this.columns[0].subColumnSize()) - this.getStartRowNum() + 1);
    }

    public Sheet putExtProp(String key, Object value) {
        this.extProp.put(key, value);
        return this;
    }

    public Sheet putExtPropIfAbsent(String key, Object value) {
        this.extProp.putIfAbsent(key, value);
        return this;
    }

    public Sheet putAllExtProp(Map<String, Object> m) {
        if (m != null) {
            this.extProp.putAll(m);
        }
        return this;
    }

    public Object getExtPropValue(String key) {
        return this.extProp.get(key);
    }

    public Map<String, Object> getExtPropAsMap() {
        return new HashMap<String, Object>(this.extProp);
    }

    protected void markExtProp() {
        this.extPropMark |= this.getExtPropValue("freeze") != null ? 1 : 0;
        this.extPropMark |= this.getExtPropValue("style_design") != null ? 2 : 0;
        this.extPropMark |= this.getExtPropValue("merge_cells") != null ? 4 : 0;
        this.extPropMark |= this.getExtPropValue("auto_filter") != null ? 8 : 0;
        this.extPropMark |= this.getExtPropValue("data_validation") != null ? 16 : 0;
        this.extPropMark |= this.getExtPropValue("zoom_scale") != null ? 32 : 0;
    }

    protected void reverseHeadColumn() {
        int i;
        if (!this.headerReady) {
            this.columns = this.getHeaderColumns();
        }
        if (this.columns == null || this.columns.length == 0) {
            return;
        }
        int[] lenArray = new int[this.columns.length];
        int maxSubColumnSize = 1;
        int len = this.columns.length;
        for (i = 0; i < len; ++i) {
            int a;
            Column col = this.columns[i];
            lenArray[i] = a = col.subColumnSize();
            if (a <= maxSubColumnSize) continue;
            maxSubColumnSize = a;
        }
        if (maxSubColumnSize == 1) {
            return;
        }
        int len2 = this.columns.length;
        for (i = 0; i < len2; ++i) {
            Column col = this.columns[i];
            if (col.tail != null) {
                Column head = col.tail;
                Column tmp = head.prev;
                head.tail = null;
                head.prev = null;
                head.next = null;
                while (tmp != null) {
                    Column ptmp = tmp.prev;
                    tmp.tail = null;
                    tmp.prev = null;
                    tmp.next = null;
                    head.addSubColumn(tmp);
                    tmp = ptmp;
                }
                head.prev = null;
                if (head.tail != null) {
                    head.tail.next = null;
                }
                this.columns[i] = head;
                col = head;
            }
            if (lenArray[i] >= maxSubColumnSize) continue;
            for (int k = lenArray[i]; k < maxSubColumnSize; ++k) {
                Column sub = new Column().setColIndex(col.colIndex);
                sub.colNum = col.colNum;
                col.addSubColumn(sub);
            }
        }
    }

    protected void mergeHeaderCellsIfEquals() {
        int x = this.columns.length;
        int y = x > 0 ? this.columns[0].subColumnSize() : 0;
        int n = x * y;
        if (y <= 1) {
            return;
        }
        Column[] array = new Column[n];
        for (int i = 0; i < x; ++i) {
            System.arraycopy(this.columns[i].toArray(), 0, array, y * i, y);
        }
        int[] marks = new int[n];
        int fc = 0;
        int fr = 0;
        int lc = 0;
        int lr = 0;
        ArrayList<Dimension> mergeCells = new ArrayList<Dimension>();
        ArrayList<Dimension> _tmpCells = new ArrayList<Dimension>();
        for (int i = 0; i < n; ++i) {
            int tail;
            if (marks[i] == 1) continue;
            Column col = array[i];
            marks[i] = 1;
            if (StringUtil.isEmpty(col.name)) continue;
            int a = 0;
            if (i + y < n && col.name.equals(array[i + y].name)) {
                int c;
                fc = i / y;
                fr = i % y;
                lc = fc + 1;
                lr = fr;
                a = 1;
                marks[i + y] = 1;
                while ((c = i + y * (a + 1)) < n && col.name.equals(array[c].name)) {
                    ++lc;
                    marks[c] = 1;
                    ++a;
                }
            }
            if (i + 1 < (tail = i / y * y + y) && (col.name.equals(array[i + 1].name) || StringUtil.isEmpty(array[i + 1].name))) {
                int r;
                marks[r] = 1;
                fc = i / y;
                fr = i % y;
                lc = fc + a;
                lr = fr;
                block3: for (r = i + 1; r < tail; ++r) {
                    int k;
                    for (k = 0; k <= a; ++k) {
                        if (!col.name.equals(array[r + k * y].name) && StringUtil.isNotEmpty(array[r + k * y].name)) break block3;
                    }
                    for (k = 0; k <= a; ++k) {
                        marks[r + k * y] = 1;
                    }
                    ++lr;
                }
                i = r - 1;
            }
            if (fc >= lc && fr >= lr) continue;
            mergeCells.add(new Dimension(y - lr, (short)array[y - lr - 1 + fc * y].getColNum(), y - fr, (short)array[y - fr - 1 + lc * y].getColNum()));
            _tmpCells.add(new Dimension(y - lr, (short)(fc + 1), y - fr, (short)(lc + 1)));
            fc = lc;
            fr = lr;
        }
        if (!mergeCells.isEmpty()) {
            List existsMergeCells;
            for (Dimension dim : _tmpCells) {
                Column col = array[(dim.firstColumn - 1) * y + (y - dim.lastRow)];
                Comment headerComment = col.headerComment;
                Column tmp = new Column().from(col);
                for (int m = dim.firstColumn - 1; m < dim.lastColumn; ++m) {
                    for (int o = y - dim.firstRow; o >= y - dim.lastRow; --o) {
                        Column currentCol = array[m * y + o];
                        currentCol.name = null;
                        currentCol.key = null;
                        if (currentCol.headerComment == null) continue;
                        if (headerComment == null) {
                            headerComment = currentCol.headerComment;
                        }
                        currentCol.headerComment = null;
                    }
                }
                Column lastCol = array[(dim.firstColumn - 1) * y + (y - dim.firstRow)];
                lastCol.from(tmp);
                lastCol.headerComment = headerComment;
            }
            if (this.getStartRowNum() > 1) {
                ArrayList<Dimension> tmp = new ArrayList<Dimension>();
                for (Dimension dim : mergeCells) {
                    tmp.add(new Dimension(dim.firstRow + this.getStartRowNum() - 1, dim.firstColumn, dim.lastRow + this.getStartRowNum() - 1, dim.lastColumn));
                }
                mergeCells = tmp;
            }
            if ((existsMergeCells = (List)this.getExtPropValue("merge_cells")) != null && !existsMergeCells.isEmpty()) {
                existsMergeCells.addAll(mergeCells);
            } else {
                this.putExtProp("merge_cells", mergeCells);
            }
        }
    }

    public Sheet forWrite() {
        if (StringUtil.isEmpty(this.getName())) {
            this.setName("Sheet" + this.getId());
        }
        if (this.getSheetWriter() == null && this.workbook.getWorkbookWriter() != null) {
            this.setSheetWriter(this.workbook.getWorkbookWriter().getWorksheetWriter(this));
        }
        if (this.workbook.isAutoSize() && this.getAutoSize() == 0) {
            this.autoSize();
        }
        if (this.workbook.getZebraFill() != null && this.getZebraFillStyle() < 0) {
            this.setZebraLine(this.workbook.getZebraFill());
        }
        if (this.getCellValueAndStyle() == null) {
            this.setCellValueAndStyle(this.getSheetWriter().getCellValueAndStyle());
        }
        if (this.workbook.getForceExport() > this.getForceExport() && ListSheet.class.isAssignableFrom(this.getClass())) {
            ((ListSheet)this).forceExport();
        }
        if (this.workbook.getProgressConsumer() != null && this.getProgressConsumer() == null) {
            this.onProgress(this.workbook.getProgressConsumer());
        }
        return this;
    }

    protected abstract void resetBlockData();
}

