/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.util.FileSignatures;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

public class Watermark {
    private static final Logger LOGGER = LoggerFactory.getLogger(Watermark.class);
    private Path imagePath;
    private boolean temp;
    private FileSignatures.Signature signature;
    private String txt;

    public Watermark(String word) {
        this.txt = word;
    }

    public Watermark(Path imagePath) {
        this.imagePath = imagePath;
    }

    public Watermark(InputStream inputStream) throws IOException {
        this.imagePath = this.createTemp();
        Files.copy(inputStream, this.imagePath, StandardCopyOption.REPLACE_EXISTING);
    }

    public Path get() {
        this.init();
        return this.canWrite() ? this.imagePath : null;
    }

    public static Watermark of(String mark) {
        return new Watermark(mark);
    }

    public static Watermark of(Path path) {
        return new Watermark(path);
    }

    public static Watermark of(InputStream is) throws IOException {
        return new Watermark(is);
    }

    private Path createWatermark(String watermark) {
        try {
            Path temp = this.createTemp();
            int width = 510;
            int height = 300;
            BufferedImage bi = new BufferedImage(width, height, 1);
            int minx = bi.getMinX();
            int miny = bi.getMinY();
            for (int i = minx; i < width; ++i) {
                for (int j = miny; j < height; ++j) {
                    bi.setRGB(i, j, 0xFFFFFF);
                }
            }
            Graphics2D g2d = bi.createGraphics();
            g2d.setColor(new Color(230, 230, 230));
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setFont(new Font("\u534e\u6587\u7ec6\u9ed1", 2, 24));
            g2d.rotate(Math.toRadians(-25.0));
            g2d.drawString(watermark, 100, 250);
            g2d.setComposite(AlphaComposite.getInstance(3));
            g2d.dispose();
            ImageIO.write((RenderedImage)bi, "png", temp.toFile());
            return temp;
        }
        catch (IOException e) {
            LOGGER.error("Create watermark error.", (Throwable)e);
            return null;
        }
    }

    private Path createTemp() throws IOException {
        this.temp = true;
        return Files.createTempFile("eec+watermark", "png", new FileAttribute[0]);
    }

    public boolean delete() {
        if (this.imagePath != null && this.temp) {
            FileUtil.rm(this.imagePath);
        }
        return true;
    }

    public String getSuffix() {
        this.init();
        return "." + this.signature.extension;
    }

    public String getContentType() {
        this.init();
        return this.signature.contentType;
    }

    public boolean canWrite() {
        this.init();
        return this.signature.isTrusted();
    }

    private void init() {
        if (this.signature == null) {
            if (this.imagePath == null && StringUtil.isNotEmpty(this.txt)) {
                this.imagePath = this.createWatermark(this.txt);
            }
            if (this.imagePath != null && this.signature == null) {
                this.signature = FileSignatures.test(this.imagePath);
            }
            if (this.signature == null) {
                this.signature = new FileSignatures.Signature(null, "image/unknown");
            }
        }
    }
}

