/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IPushModelSheet;
import org.ttzero.excel.entity.IWorkbookWriter;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.entity.csv.CSVWorksheetWriter;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;
import org.ttzero.excel.util.ZipUtil;

public class CSVWorkbookWriter
implements IWorkbookWriter {
    protected Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Workbook workbook;
    private String suffix = ".csv";
    protected boolean withBom;
    protected Charset charset;
    protected Path tmpPath;

    public CSVWorkbookWriter() {
    }

    public CSVWorkbookWriter(Workbook workbook) {
        this.workbook = workbook;
    }

    public CSVWorkbookWriter(Workbook workbook, boolean withBom) {
        this.workbook = workbook;
        this.withBom = withBom;
    }

    @Override
    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        Path path = null;
        try {
            path = this.createTemp();
            Files.copy(path, os);
        }
        finally {
            if (path != null) {
                FileUtil.rm(path);
            }
            this.close();
        }
    }

    @Override
    public void writeTo(Path root) throws IOException {
        Path path = null;
        try {
            path = this.createTemp();
            this.moveToPath(path, root);
        }
        finally {
            if (path != null) {
                FileUtil.rm(path);
            }
            this.close();
        }
    }

    protected void moveToPath(Path source, Path target) throws IOException {
        String name = StringUtil.isEmpty(this.workbook.getName()) ? "\u65b0\u5efa\u6587\u4ef6" : this.workbook.getName();
        Path resultPath = this.moveToPath(source, target, name);
        this.LOGGER.debug("Write completed. {}", (Object)resultPath);
    }

    @Override
    public Path writeBefore() throws IOException {
        if (this.tmpPath == null) {
            this.tmpPath = FileUtil.mktmp("eec+");
            this.LOGGER.debug("Create temporary folder {}", (Object)this.tmpPath);
        }
        return this.tmpPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path createTemp() throws IOException, ExcelWriteException {
        Path root = this.writeBefore();
        for (int i = 0; i < this.workbook.getSize(); ++i) {
            try (Sheet sheet = this.workbook.getSheetAt(i);){
                if (IPushModelSheet.class.isAssignableFrom(sheet.getClass()) && sheet.size() > 0) continue;
                sheet.forWrite();
                sheet.writeTo(root);
                continue;
            }
        }
        if (this.workbook.getSize() > 1) {
            this.suffix = ".zip";
            Path zipFile = ZipUtil.zipExcludeRoot(root, this.workbook.getCompressionLevel(), root);
            this.LOGGER.debug("Compression completed. {}", (Object)zipFile);
            return zipFile;
        }
        return root.resolve(this.workbook.getSheetAt(0).getName() + ".csv");
    }

    @Override
    public void close() {
        if (this.tmpPath != null) {
            FileUtil.rm_rf(this.tmpPath);
        }
    }

    public CSVWorkbookWriter setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public IWorksheetWriter getWorksheetWriter(Sheet sheet) {
        return new CSVWorksheetWriter(sheet, this.withBom).setCharset(this.charset);
    }
}

