/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.csv;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.ICellValueAndStyle;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.csv.CSVCellValueAndStyle;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.CSVUtil;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.StringUtil;

public class CSVWorksheetWriter
implements IWorksheetWriter {
    protected Sheet sheet;
    protected CSVUtil.Writer writer;
    protected BiConsumer<Sheet, Integer> progressConsumer;
    protected boolean withBom;
    protected boolean ready;
    protected Charset charset;
    protected char delimiter = (char)44;
    protected Path workSheetPath;

    public CSVWorksheetWriter() {
    }

    public CSVWorksheetWriter(Sheet sheet) {
        this.sheet = sheet;
    }

    public CSVWorksheetWriter(Sheet sheet, boolean withBom) {
        this.sheet = sheet;
        this.withBom = withBom;
    }

    @Override
    public int getRowLimit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getColumnLimit() {
        return 16384;
    }

    public CSVWorksheetWriter setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    @Override
    public IWorksheetWriter setWorksheet(Sheet sheet) {
        this.sheet = sheet;
        return this;
    }

    @Override
    public IWorksheetWriter clone() {
        throw new ExcelWriteException("Overflow the max row limit.");
    }

    @Override
    public String getFileSuffix() {
        return ".csv";
    }

    @Override
    public void writeData(RowBlock rowBlock) throws IOException {
        if (!this.ready) {
            Path path = this.sheet.getWorkbook().getWorkbookWriter().writeBefore();
            this.initWriter(path);
            this.writeBefore();
        }
        if (this.progressConsumer == null) {
            this.writeRowBlock(rowBlock);
        } else {
            this.writeRowBlockFireProgress(rowBlock);
        }
    }

    @Override
    public void close() throws IOException {
        this.sheet.afterSheetAccess(this.workSheetPath);
        this.ready = false;
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Override
    public void writeTo(Path root) throws IOException {
        this.initWriter(root);
        RowBlock rowBlock = this.sheet.nextBlock();
        this.writeBefore();
        if (rowBlock.hasNext()) {
            if (this.progressConsumer == null) {
                while (true) {
                    this.writeRowBlock(rowBlock);
                    if (!rowBlock.isEOF()) {
                        rowBlock = this.sheet.nextBlock();
                        continue;
                    }
                    break;
                }
            } else {
                while (true) {
                    this.writeRowBlockFireProgress(rowBlock);
                    if (rowBlock.isEOF()) break;
                    rowBlock = this.sheet.nextBlock();
                }
                if (rowBlock.lastRow() != null) {
                    this.progressConsumer.accept(this.sheet, rowBlock.lastRow().getIndex());
                }
            }
        }
    }

    protected Path initWriter(Path root) throws IOException {
        this.workSheetPath = root.resolve(this.sheet.getName() + ".csv");
        if (this.ready) {
            return this.workSheetPath;
        }
        if (this.charset == null) {
            this.writer = CSVUtil.newWriter(this.workSheetPath, this.delimiter);
            if (this.withBom) {
                this.writer.writeWithBom();
            }
        } else {
            this.writer = CSVUtil.newWriter(this.workSheetPath, this.delimiter, this.charset);
            if (this.withBom && this.charset.name().toLowerCase().startsWith("utf")) {
                this.writer.writeWithBom();
            }
        }
        this.progressConsumer = this.sheet.getProgressConsumer();
        this.ready = true;
        return this.workSheetPath;
    }

    protected void writeBefore() throws IOException {
        boolean noneHeader;
        Column[] columns = this.sheet.getAndSortHeaderColumns();
        boolean bl = noneHeader = columns == null || columns.length == 0;
        if (!noneHeader) {
            int i;
            int subColumnSize = columns[0].subColumnSize();
            Column[][] columnsArray = new Column[columns.length][];
            for (i = 0; i < columns.length; ++i) {
                columnsArray[i] = columns[i].toArray();
            }
            for (i = subColumnSize - 1; i >= 0; --i) {
                for (int j = 0; j < columns.length; ++j) {
                    Column hc = columnsArray[j][i];
                    this.writer.write(StringUtil.isNotEmpty(hc.getName()) ? hc.getName() : hc.key);
                }
                this.writer.newLine();
            }
        }
    }

    protected void writeRowBlock(RowBlock rowBlock) throws IOException {
        while (rowBlock.hasNext()) {
            this.writeRow(rowBlock.next());
        }
    }

    protected void writeRowBlockFireProgress(RowBlock rowBlock) throws IOException {
        while (rowBlock.hasNext()) {
            Row row = rowBlock.next();
            this.writeRow(row);
            if (row.getIndex() % 1000 != 0) continue;
            this.progressConsumer.accept(this.sheet, row.getIndex());
        }
    }

    protected void writeRow(Row row) throws IOException {
        Cell[] cells;
        block12: for (Cell cell : cells = row.getCells()) {
            switch (cell.t) {
                case 'r': 
                case 's': {
                    this.writer.write(cell.stringVal);
                    continue block12;
                }
                case 'n': {
                    this.writer.write(cell.intVal);
                    continue block12;
                }
                case 'l': {
                    this.writer.write(cell.longVal);
                    continue block12;
                }
                case 'd': {
                    this.writer.write(cell.doubleVal);
                    continue block12;
                }
                case 'b': {
                    this.writer.write(cell.boolVal);
                    continue block12;
                }
                case 'm': {
                    this.writer.write(cell.decimal.toString());
                    continue block12;
                }
                case 'c': {
                    this.writer.writeChar(cell.charVal);
                    continue block12;
                }
                case 'a': {
                    this.writer.write(DateUtil.toDateString(DateUtil.toDate(cell.intVal)));
                    continue block12;
                }
                case 'i': {
                    this.writer.write(DateUtil.toDateTimeString(DateUtil.toDate(cell.doubleVal)));
                    continue block12;
                }
                case 't': {
                    this.writer.write(DateUtil.toTimeString(DateUtil.toDate(cell.doubleVal)));
                    continue block12;
                }
                default: {
                    this.writer.writeEmpty();
                }
            }
        }
        this.writer.newLine();
    }

    public CSVWorksheetWriter setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public ICellValueAndStyle getCellValueAndStyle() {
        return new CSVCellValueAndStyle();
    }
}

