/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.awt.Color;
import org.ttzero.excel.util.StringUtil;

public class HlsColor {
    public float a;
    public float h;
    public float l;
    public float s;

    public static HlsColor rgbToHls(Color rgbColor) {
        HlsColor hlsColor = new HlsColor();
        float r = (float)rgbColor.getRed() / 255.0f;
        float g = (float)rgbColor.getGreen() / 255.0f;
        float b = (float)rgbColor.getBlue() / 255.0f;
        float a = (float)rgbColor.getAlpha() / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float delta = max - min;
        if (max == min) {
            hlsColor.h = 0.0f;
            hlsColor.s = 0.0f;
            hlsColor.l = max;
            return hlsColor;
        }
        hlsColor.l = (min + max) / 2.0f;
        hlsColor.s = hlsColor.l < 0.5f ? delta / (max + min) : delta / (2.0f - max - min);
        if (r == max) {
            hlsColor.h = (g - b) / delta;
        }
        if (g == max) {
            hlsColor.h = 2.0f + (b - r) / delta;
        }
        if (b == max) {
            hlsColor.h = 4.0f + (r - g) / delta;
        }
        hlsColor.h *= 60.0f;
        if (hlsColor.h < 0.0f) {
            hlsColor.h += 360.0f;
        }
        hlsColor.a = a;
        return hlsColor;
    }

    public static Color hlsToRgb(HlsColor hlsColor) {
        if (hlsColor.s == 0.0f) {
            return new Color(hlsColor.l, hlsColor.l, hlsColor.l, hlsColor.a);
        }
        float t1 = hlsColor.l < 0.5f ? hlsColor.l * (1.0f + hlsColor.s) : hlsColor.l + hlsColor.s - hlsColor.l * hlsColor.s;
        float t2 = 2.0f * hlsColor.l - t1;
        float h = hlsColor.h / 360.0f;
        float r = HlsColor.hueToRGB(t1, t2, h + 0.33333334f);
        float g = HlsColor.hueToRGB(t1, t2, h);
        float b = HlsColor.hueToRGB(t1, t2, h - 0.33333334f);
        return new Color(r, g, b, hlsColor.a);
    }

    private static float hueToRGB(float t1, float t2, float t3) {
        if (t3 < 0.0f) {
            t3 += 1.0f;
        }
        if (t3 > 1.0f) {
            t3 -= 1.0f;
        }
        float color = 6.0f * t3 < 1.0f ? t2 + (t1 - t2) * 6.0f * t3 : (2.0f * t3 < 1.0f ? t1 : (3.0f * t3 < 2.0f ? t2 + (t1 - t2) * (0.6666667f - t3) * 6.0f : t2));
        return color;
    }

    public static float calculateFinalLumValue(Double tint, float lum) {
        if (tint == null) {
            return lum;
        }
        lum = tint < 0.0 ? (float)((double)lum * (1.0 + tint)) : (float)((double)lum * (1.0 - tint) + (255.0 - 255.0 * (1.0 - tint)));
        return lum;
    }

    public static Color calculateColor(Color theme, String tintV) {
        Double tint = null;
        if (StringUtil.isNotEmpty(tintV)) {
            try {
                tint = Double.parseDouble(tintV);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        HlsColor hls = HlsColor.rgbToHls(theme);
        hls.l = HlsColor.calculateFinalLumValue(tint, hls.l * 255.0f) / 255.0f;
        return HlsColor.hlsToRgb(hls);
    }
}

