/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.awt.Color;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.style.BuildInColor;
import org.ttzero.excel.entity.style.ColorIndex;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.util.SAXReaderUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={""}, uri={"http://schemas.openxmlformats.org/drawingml/2006/main"}, value="a")
public class Theme {
    private static final Logger LOGGER = LoggerFactory.getLogger(Theme.class);
    private ClrScheme[] clrs;
    private Font minorFont;
    private Font majorFont;
    static final char[] digits_uppercase = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static Theme load(InputStream is) {
        Theme self = new Theme();
        SAXReader reader = SAXReaderUtil.createDefault();
        try {
            Element fontScheme;
            List clrSchemes;
            Document document = reader.read(is);
            Element themeElements = document.getRootElement().element("themeElements");
            Element clrScheme = themeElements.element("clrScheme");
            if (clrScheme != null && (clrSchemes = clrScheme.elements()) != null && !clrSchemes.isEmpty()) {
                ClrScheme tmp;
                ClrScheme[] clrs = new ClrScheme[clrSchemes.size()];
                self.clrs = clrs;
                int i = 0;
                for (Element e : clrSchemes) {
                    self.clrs[i++] = Theme.toClrScheme(e);
                }
                if (clrs.length >= 2 && "dk1".equals(clrs[0].tag) && "lt1".equals(clrs[1].tag)) {
                    tmp = clrs[1];
                    clrs[1] = clrs[0];
                    clrs[0] = tmp;
                }
                if (clrs.length >= 4 && "dk2".equals(clrs[2].tag) && "lt2".equals(clrs[3].tag)) {
                    tmp = clrs[3];
                    clrs[3] = clrs[2];
                    clrs[2] = tmp;
                }
                int len = Math.min(clrs.length, ColorIndex.themeColors.length);
                for (i = 0; i < len; ++i) {
                    ColorIndex.themeColors[i] = clrs[i].color;
                }
            }
            if ((fontScheme = themeElements.element("fontScheme")) != null) {
                String typeface;
                Element latin;
                Element fontElement = fontScheme.element("majorFont");
                if (fontElement != null && (latin = fontElement.element("latin")) != null && StringUtil.isNotEmpty(typeface = latin.attributeValue("typeface"))) {
                    self.majorFont = new Font(typeface, 11);
                }
                if ((fontElement = fontScheme.element("minorFont")) != null && (latin = fontElement.element("latin")) != null && StringUtil.isNotEmpty(typeface = latin.attributeValue("typeface"))) {
                    self.minorFont = new Font(typeface, 11);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Read the theme failed and ignore the style to continue.", (Throwable)e);
        }
        return self;
    }

    static ClrScheme toClrScheme(Element e) {
        ClrScheme c = new ClrScheme();
        c.tag = e.getName();
        List subs = e.elements();
        Color color = null;
        if (subs != null && !subs.isEmpty()) {
            Element sub = (Element)subs.get(0);
            String v = Styles.getAttr(sub, "lastClr");
            if (v == null) {
                v = Styles.getAttr(sub, "val");
            } else {
                try {
                    color = Styles.toColor(v);
                }
                catch (Exception ex) {
                    v = Styles.getAttr(sub, "val");
                }
            }
            if (color == null) {
                try {
                    color = Styles.toColor(v);
                }
                catch (Exception ex) {
                    color = new BuildInColor(64);
                }
            }
        } else {
            color = new BuildInColor(64);
        }
        c.color = color;
        return c;
    }

    public Color[] getClrSchemes() {
        if (this.clrs != null && this.clrs.length > 0) {
            Color[] colors = new Color[this.clrs.length];
            for (int i = 0; i < this.clrs.length; ++i) {
                colors[i] = this.clrs[i].color;
            }
            return colors;
        }
        return ColorIndex.themeColors;
    }

    public Font getMinorFont() {
        return this.minorFont;
    }

    public Font getMajorFont() {
        return this.majorFont;
    }

    public static class ClrScheme {
        public String tag;
        public Color color;

        public ClrScheme() {
        }

        public ClrScheme(String tag, Color color) {
            this.tag = tag;
            this.color = color;
        }

        public String toString() {
            if (this.color == null) {
                return this.tag;
            }
            int r = this.color.getRed();
            int g = this.color.getGreen();
            int b = this.color.getBlue();
            return this.tag + ": " + new String(new char[]{digits_uppercase[r >> 4], digits_uppercase[r & 0xF], digits_uppercase[g >> 4], digits_uppercase[g & 0xF], digits_uppercase[b >> 4], digits_uppercase[b & 0xF]});
        }
    }
}

