/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.hash;

import java.nio.ByteBuffer;
import org.ttzero.excel.hash.AbstractStreamingHasher;

final class Murmur3_128Hasher
extends AbstractStreamingHasher {
    private static final int CHUNK_SIZE = 16;
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private static final byte[] unsafeBytes = new byte[16];
    private final int seed;
    private long h1;
    private long h2;
    private int length;

    Murmur3_128Hasher(int seed) {
        super(16);
        this.seed = seed;
        this.h1 = seed;
        this.h2 = seed;
        this.length = 0;
    }

    @Override
    protected void process(ByteBuffer bb) {
        long k1 = bb.getLong();
        long k2 = bb.getLong();
        this.bmix64(k1, k2);
        this.length += 16;
    }

    private void bmix64(long k1, long k2) {
        this.h1 ^= Murmur3_128Hasher.mixK1(k1);
        this.h1 = Long.rotateLeft(this.h1, 27);
        this.h1 += this.h2;
        this.h1 = this.h1 * 5L + 1390208809L;
        this.h2 ^= Murmur3_128Hasher.mixK2(k2);
        this.h2 = Long.rotateLeft(this.h2, 31);
        this.h2 += this.h1;
        this.h2 = this.h2 * 5L + 944331445L;
    }

    @Override
    protected void processRemaining(ByteBuffer bb) {
        long k1 = 0L;
        long k2 = 0L;
        this.length += bb.remaining();
        switch (bb.remaining()) {
            case 15: {
                k2 ^= (long)Byte.toUnsignedInt(bb.get(14)) << 48;
            }
            case 14: {
                k2 ^= (long)Byte.toUnsignedInt(bb.get(13)) << 40;
            }
            case 13: {
                k2 ^= (long)Byte.toUnsignedInt(bb.get(12)) << 32;
            }
            case 12: {
                k2 ^= (long)Byte.toUnsignedInt(bb.get(11)) << 24;
            }
            case 11: {
                k2 ^= (long)Byte.toUnsignedInt(bb.get(10)) << 16;
            }
            case 10: {
                k2 ^= (long)Byte.toUnsignedInt(bb.get(9)) << 8;
            }
            case 9: {
                k2 ^= (long)Byte.toUnsignedInt(bb.get(8));
            }
            case 8: {
                k1 ^= bb.getLong();
                break;
            }
            case 7: {
                k1 ^= (long)Byte.toUnsignedInt(bb.get(6)) << 48;
            }
            case 6: {
                k1 ^= (long)Byte.toUnsignedInt(bb.get(5)) << 40;
            }
            case 5: {
                k1 ^= (long)Byte.toUnsignedInt(bb.get(4)) << 32;
            }
            case 4: {
                k1 ^= (long)Byte.toUnsignedInt(bb.get(3)) << 24;
            }
            case 3: {
                k1 ^= (long)Byte.toUnsignedInt(bb.get(2)) << 16;
            }
            case 2: {
                k1 ^= (long)Byte.toUnsignedInt(bb.get(1)) << 8;
            }
            case 1: {
                k1 ^= (long)Byte.toUnsignedInt(bb.get(0));
                break;
            }
            default: {
                throw new AssertionError((Object)"Should never get here.");
            }
        }
        this.h1 ^= Murmur3_128Hasher.mixK1(k1);
        this.h2 ^= Murmur3_128Hasher.mixK2(k2);
    }

    @Override
    public byte[] makeHash() {
        this.h1 ^= (long)this.length;
        this.h2 ^= (long)this.length;
        this.h1 += this.h2;
        this.h2 += this.h1;
        this.h1 = Murmur3_128Hasher.fmix64(this.h1);
        this.h2 = Murmur3_128Hasher.fmix64(this.h2);
        this.h1 += this.h2;
        this.h2 += this.h1;
        Murmur3_128Hasher.unsafeBytes[0] = (byte)(this.h1 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[1] = (byte)(this.h1 >> 8 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[2] = (byte)(this.h1 >> 16 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[3] = (byte)(this.h1 >> 24 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[4] = (byte)(this.h1 >> 32 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[5] = (byte)(this.h1 >> 40 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[6] = (byte)(this.h1 >> 48 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[7] = (byte)(this.h1 >> 56 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[8] = (byte)(this.h2 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[9] = (byte)(this.h2 >> 8 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[10] = (byte)(this.h2 >> 16 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[11] = (byte)(this.h2 >> 24 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[12] = (byte)(this.h2 >> 32 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[13] = (byte)(this.h2 >> 40 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[14] = (byte)(this.h2 >> 48 & 0xFFL);
        Murmur3_128Hasher.unsafeBytes[15] = (byte)(this.h2 >> 56 & 0xFFL);
        return unsafeBytes;
    }

    private static long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    private static long mixK1(long k1) {
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        return k1 *= 5545529020109919103L;
    }

    private static long mixK2(long k2) {
        k2 *= 5545529020109919103L;
        k2 = Long.rotateLeft(k2, 33);
        return k2 *= -8663945395140668459L;
    }

    @Override
    public Murmur3_128Hasher clear() {
        super.clear();
        this.h1 = this.seed;
        this.h2 = this.seed;
        this.length = 0;
        return this;
    }
}

