/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.manager.docProps;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

public abstract class XmlEntity
implements Storable {
    @Override
    public void writeTo(Path path) throws IOException {
        TopNS topNs = this.getClass().getAnnotation(TopNS.class);
        if (topNs == null) {
            throw new IOException(this.getClass() + " top namespace is required.");
        }
        String[] prefixs = topNs.prefix();
        String[] uris = topNs.uri();
        DocumentFactory factory = DocumentFactory.getInstance();
        Element rootElement = prefixs.length > 0 && StringUtil.isEmpty(prefixs[0]) ? factory.createElement(topNs.value(), uris[0]) : factory.createElement(topNs.value());
        HashMap<String, Namespace> namespaceMap = new HashMap<String, Namespace>(prefixs.length);
        for (int i = 0; i < prefixs.length; ++i) {
            namespaceMap.put(prefixs[i], Namespace.get((String)prefixs[i], (String)uris[i]));
            rootElement.add(Namespace.get((String)prefixs[i], (String)uris[i]));
        }
        this.toDom(rootElement, namespaceMap);
        Document doc = factory.createDocument(rootElement);
        FileUtil.writeToDiskNoFormat(doc, path);
    }

    abstract void toDom(Element var1, Map<String, Namespace> var2);
}

