/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.file.Path;

public class Cell {
    public static final char SST = 's';
    public static final char BOOL = 'b';
    public static final char FUNCTION = 'f';
    public static final char INLINESTR = 'r';
    public static final char LONG = 'l';
    public static final char DOUBLE = 'd';
    public static final char NUMERIC = 'n';
    public static final char BLANK = 'k';
    public static final char CHARACTER = 'c';
    public static final char DECIMAL = 'm';
    public static final char DATETIME = 'i';
    public static final char DATE = 'a';
    public static final char TIME = 't';
    public static final char UNALLOCATED = '\u0000';
    public static final char EMPTY_TAG = 'e';
    public static final char BINARY = 'y';
    public static final char FILE = 'x';
    public static final char INPUT_STREAM = 'p';
    public static final char REMOTE_URL = 'u';
    public static final char BYTE_BUFFER = 'o';
    public static final Cell UNALLOCATED_CELL = new Cell();
    public char t;
    public String stringVal;
    public int intVal;
    public long longVal;
    public double doubleVal;
    public boolean boolVal;
    public char charVal;
    public BigDecimal decimal;
    public int xf;
    public String formula;
    public int si = -1;
    public boolean f;
    public byte[] binary;
    public ByteBuffer byteBuffer;
    public Path path;
    public InputStream isv;
    public boolean h;
    public char mediaType;
    public transient short i;

    public Cell() {
    }

    public Cell(short i) {
        this.i = i;
    }

    public Cell(int i) {
        this.i = (short)(i & Short.MAX_VALUE);
    }

    public Cell setT(char t) {
        this.t = t;
        return this;
    }

    public Cell setString(String sv) {
        this.t = (char)114;
        this.stringVal = sv;
        return this;
    }

    public Cell setInt(int nv) {
        this.t = (char)110;
        this.intVal = nv;
        return this;
    }

    public Cell setDouble(double dv) {
        this.t = (char)100;
        this.doubleVal = dv;
        return this;
    }

    public Cell setBool(boolean bv) {
        this.t = (char)98;
        this.boolVal = bv;
        return this;
    }

    public Cell setChar(char c) {
        this.t = (char)99;
        this.charVal = c;
        return this;
    }

    public Cell blank() {
        this.t = (char)107;
        return this;
    }

    public Cell emptyTag() {
        this.t = (char)101;
        return this;
    }

    public Cell setLong(long lv) {
        this.t = (char)108;
        this.longVal = lv;
        return this;
    }

    public Cell setDecimal(BigDecimal mv) {
        this.t = (char)109;
        this.decimal = mv;
        return this;
    }

    public Cell setDateTime(double i) {
        this.t = (char)105;
        this.doubleVal = i;
        return this;
    }

    public Cell setDate(int a) {
        this.t = (char)97;
        this.intVal = a;
        return this;
    }

    public Cell setTime(double t) {
        this.t = (char)116;
        this.doubleVal = t;
        return this;
    }

    public Cell setBinary(byte[] bytes) {
        this.mediaType = (char)121;
        this.binary = bytes;
        return this;
    }

    public Cell setPath(Path path) {
        this.mediaType = (char)120;
        this.path = path;
        return this;
    }

    public Cell setInputStream(InputStream stream) {
        this.mediaType = (char)112;
        this.isv = stream;
        return this;
    }

    public Cell setByteBuffer(ByteBuffer byteBuffer) {
        this.mediaType = (char)111;
        this.byteBuffer = byteBuffer;
        return this;
    }

    public Cell setFormula(String formula) {
        if (formula != null && !formula.isEmpty()) {
            this.f = true;
            this.formula = formula;
        }
        return this;
    }

    public Cell setHyperlink(String hyperlink) {
        this.t = (char)114;
        this.stringVal = hyperlink;
        this.h = true;
        return this;
    }

    public Cell clear() {
        this.t = '\u0000';
        this.stringVal = null;
        this.intVal = 0;
        this.doubleVal = 0.0;
        this.boolVal = false;
        this.longVal = 0L;
        this.charVal = '\u0000';
        this.decimal = null;
        this.xf = 0;
        this.formula = null;
        this.f = false;
        this.si = -1;
        this.binary = null;
        this.path = null;
        this.isv = null;
        this.byteBuffer = null;
        this.mediaType = '\u0000';
        this.h = false;
        return this;
    }

    public Cell from(Cell cell) {
        this.t = cell.t;
        this.stringVal = cell.stringVal;
        this.intVal = cell.intVal;
        this.doubleVal = cell.doubleVal;
        this.boolVal = cell.boolVal;
        this.longVal = cell.longVal;
        this.charVal = cell.charVal;
        this.decimal = cell.decimal;
        this.xf = cell.xf;
        this.formula = cell.formula;
        this.f = cell.f;
        this.si = cell.si;
        this.binary = cell.binary;
        this.path = cell.path;
        this.isv = cell.isv;
        this.byteBuffer = cell.byteBuffer;
        this.mediaType = cell.mediaType;
        this.h = cell.h;
        return this;
    }
}

