/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

interface Tester {
    public boolean test(int var1);

    public int limit();

    public int size();

    public int analysis();

    public static class BinaryTester
    implements Tester {
        private int start;
        private int limit;
        private final int initial_size;
        private final long[] marks;
        private int total_resize;

        BinaryTester(int expectedInsertions) {
            this.initial_size = (expectedInsertions - 1 >> 6) + 1;
            this.marks = new long[this.initial_size];
            this.limit = (this.initial_size << 6) - 1;
        }

        @Override
        public boolean test(int i) {
            int m;
            if (i < this.start) {
                return true;
            }
            if (i > this.limit && !this.resize(i)) {
                return false;
            }
            int n = (i -= this.start) >> 6;
            boolean a = (this.marks[n] >> 63 - (m = i - (n << 6)) & 1L) == 1L;
            int n2 = n;
            this.marks[n2] = this.marks[n2] | 1L << 63 - m;
            return a;
        }

        @Override
        public int limit() {
            return this.limit;
        }

        @Override
        public int size() {
            return this.marks.length;
        }

        @Override
        public int analysis() {
            return this.total_resize;
        }

        private boolean resize(int i) {
            int ii;
            ++this.total_resize;
            int n = this.marks.length;
            int l = (i - this.start >> 6) + 1;
            for (ii = 0; ii < n && this.marks[ii] == -1L; ++ii) {
            }
            if (l - ii > this.initial_size) {
                while (ii < n && (Long.bitCount(this.marks[ii]) > 48 || this.marks[ii] == 0L)) {
                    ++ii;
                }
            }
            if (l - ii <= this.initial_size) {
                int j = n - ii;
                if (j > 0) {
                    System.arraycopy(this.marks, ii, this.marks, 0, j);
                }
                while (j < n) {
                    this.marks[j++] = 0L;
                }
                this.start += ii << 6;
                this.limit = (this.marks.length << 6) + this.start - 1;
                return true;
            }
            return false;
        }
    }
}

