/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.MergeCalcFunc;
import org.ttzero.excel.reader.MergeValueFunc;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.XMLRow;
import org.ttzero.excel.util.StringUtil;

class XMLFullRow
extends XMLRow {
    MergeCalcFunc calcFun;
    boolean hasCalcFunc;
    MergeValueFunc mergedFunc;
    Grid mergeGrid;
    Double height;
    boolean hidden;

    XMLFullRow(XMLRow row) {
        this.sst = row.sst;
        this.styles = row.styles;
    }

    @Override
    protected XMLFullRow empty(char[] cb, int from, int size) {
        super.empty(cb, from, size);
        this.searchSpan0();
        return this;
    }

    XMLFullRow setCalcFun(MergeCalcFunc calcFun) {
        this.calcFun = calcFun;
        this.hasCalcFunc = calcFun != null;
        return this;
    }

    @Override
    protected void parseCells() {
        Cell cell;
        this.height = null;
        this.hidden = false;
        this.cursor = this.searchSpan0();
        while (this.cb[this.cursor++] != '>') {
        }
        boolean bl = this.unknownLength = this.lc < 0;
        if (this.hasCalcFunc) {
            this.calcFun.accept(this.getRowNum(), this.cells, this.lc > this.fc ? this.lc - this.fc : -1);
        }
        int i = 1;
        int r = this.getRowNum();
        while ((cell = this.nextCell()) != null) {
            if (cell.i > i) {
                while (i < cell.i) {
                    this.subParseCellValue(this.cells[i - 1]);
                    ++i;
                }
            }
            this.subParseCellValue(cell);
            ++i;
        }
        while (this.mergeGrid.test(r, i)) {
            if (this.lc < i) {
                if (this.cells.length < i) {
                    this.cells = this.copyCells(i);
                }
                this.lc = i;
            }
            this.subParseCellValue(this.cells[i - 1]);
            ++i;
        }
    }

    protected void subParseCellValue(Cell cell) {
        this.parseCalcFunc(cell);
        super.parseCellValue(cell);
        this.mergedFunc.accept(this.getRowNum(), cell);
    }

    void parseCalcFunc(Cell cell) {
        if (cell.t == '\u0000') {
            return;
        }
        int _cursor = this.cursor;
        int a = this.getF(cell);
        boolean bl = cell.f = a < this.cursor || cell.si >= 0;
        if (a == this.e) {
            this.cursor = _cursor;
            return;
        }
        if (a < this.cursor) {
            cell.formula = SharedStrings.escape(this.cb, a, this.cursor);
            if (cell.si > -1) {
                this.setCalc(cell.si, cell.formula);
            }
        } else if (cell.si > -1) {
            cell.formula = this.getCalc(cell.si, (long)this.getRowNum() << 14 | (long)cell.i);
        }
    }

    int getF(Cell cell) {
        int a;
        while (this.cursor < this.e && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != 'f' || this.cb[this.cursor + 2] != '>' && this.cb[this.cursor + 2] > ' ' && this.cb[this.cursor + 2] != '/')) {
            ++this.cursor;
        }
        if (this.cursor == this.e) {
            return this.cursor;
        }
        if (this.cb[this.cursor + 2] == '>') {
            a = this.cursor += 3;
        } else if (this.cb[this.cursor + 2] == ' ') {
            int i = this.cursor + 3;
            while (this.cursor < this.e && this.cb[this.cursor] != '>') {
                ++this.cursor;
            }
            this.parseFunAttr(cell, this.cb, i, this.cb[this.cursor - 1] != '/' ? this.cursor : this.cursor - 1);
            ++this.cursor;
            if (this.cb[this.cursor - 2] == '/' || this.cursor == this.e) {
                return this.cursor;
            }
            a = this.cursor;
        } else {
            if (this.cb[this.cursor + 2] == '/') {
                this.cursor += 3;
                return this.cursor;
            }
            a = this.cursor += 3;
        }
        while (this.cursor < this.e && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != '/' || this.cb[this.cursor + 2] != 'f' || this.cb[this.cursor + 3] != '>')) {
            ++this.cursor;
        }
        return a;
    }

    void parseFunAttr(Cell cell, char[] cb, int a, int b) {
        String[] values = new String[10];
        int index = 0;
        boolean sv = false;
        int i = a;
        while (true) {
            if (a < b && cb[a] > ' ' && cb[a] != '=') {
                ++a;
                continue;
            }
            values[index++] = new String(cb, i, sv ? a - i - 1 : a - i);
            sv = false;
            if (a + 1 >= b) break;
            if (cb[a + 1] == '\"') {
                a += 2;
                sv = true;
            } else if (cb[a + 1] == ' ') {
                values[index++] = "1";
            } else {
                ++a;
            }
            i = ++a;
        }
        if (index < 2 || (index & 1) == 1) {
            this.LOGGER.warn("The function format error.[{}]", (Object)new String(cb, a, b - a));
            return;
        }
        int len = index >> 1;
        for (i = 0; i < len; ++i) {
            int _i = i << 1;
            int vl = values[_i].length();
            if (vl - 1 == i) continue;
            int _n = vl - 1;
            if (_n > index - 1) {
                this.LOGGER.warn("Unknown attribute on function tag.[{}]", (Object)values[_i]);
                return;
            }
            StringUtil.swap(values, _n << 1, _i);
            StringUtil.swap(values, (_n << 1) + 1, _i + 1);
        }
        if ("si".equals(values[2]) && StringUtil.isNotEmpty(values[3])) {
            int si = Integer.parseInt(values[3]);
            if (index > 4) {
                this.addRef(si, values[5]);
            }
            cell.si = si;
        }
    }

    XMLFullRow setCopyValueFunc(Grid mergeGrid, MergeValueFunc mergedFunc) {
        this.mergeGrid = mergeGrid;
        this.mergedFunc = mergedFunc;
        return this;
    }

    int searchSpan0() {
        int idx = super.searchSpan();
        int i = this.from + 4;
        Double ht = null;
        while (this.cb[i] != '>') {
            if (this.cb[i] <= ' ' && this.cb[i + 1] == 'h' && this.cb[i + 2] == 't' && (this.cb[i + 3] == '=' || this.cb[i + 3] <= ' ')) {
                int j = i += 5;
                while (this.cb[i] != '\"' && this.cb[i] != '>') {
                    ++i;
                }
                if (i > j && this.cb[i] == '\"') {
                    ht = Double.valueOf(new String(this.cb, j, i - j).trim());
                }
            } else if (this.cb[i] <= ' ' && this.cb[i + 1] == 'h' && this.cb[i + 2] == 'i' && this.cb[i + 3] == 'd' && this.cb[i + 4] == 'd' && this.cb[i + 5] == 'e' && this.cb[i + 6] == 'n' && (this.cb[i + 7] == '=' || this.cb[i + 7] <= ' ') && this.cb[i += 9] == '1') {
                this.hidden = true;
            }
            ++i;
        }
        if (ht != null) {
            this.height = ht;
        }
        return Math.max(i, idx);
    }

    @Override
    public Double getHeight() {
        return this.height;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

