/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.Comments;
import org.ttzero.excel.entity.Panes;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Col;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.reader.FullSheet;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.GridFactory;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.XMLFullRow;
import org.ttzero.excel.reader.XMLRow;
import org.ttzero.excel.reader.XMLSheet;
import org.ttzero.excel.util.SAXReaderUtil;
import org.ttzero.excel.util.StringUtil;
import org.ttzero.excel.validation.Validation;

class XMLFullSheet
extends XMLSheet
implements FullSheet {
    long[] calc;
    boolean ready;
    boolean tailPared;
    Grid mergeGrid;
    List<Dimension> mergeCells;
    int showGridLines = 1;
    Panes panes;
    double defaultColWidth = -1.0;
    double defaultRowHeight = -1.0;
    List<Col> cols;
    Dimension filter;
    Integer zoomScale;
    Map<Long, Comment> comments;
    String legacyDrawing;
    List<Validation> validations;

    XMLFullSheet(XMLSheet sheet) {
        super(sheet);
        if (this.path != null && this.reader != null && !this.ready) {
            this.load0();
        }
    }

    @Override
    public XMLFullSheet load() throws IOException {
        super.load();
        this.load0();
        return this;
    }

    void load0() {
        Grid grid;
        if (this.ready || this.eof) {
            return;
        }
        ZipEntry entry = ExcelReader.getEntry(this.zipFile, "xl/calcChain.xml");
        long[][] calcArray = null;
        try {
            calcArray = entry != null ? XMLFullSheet.parseCalcChain(this.zipFile.getInputStream(entry)) : (long[][])null;
        }
        catch (IOException e) {
            LOGGER.warn("Parse calcChain failed, formula will be ignored");
        }
        if (calcArray != null && calcArray.length >= this.id) {
            this.calc = calcArray[this.id - 1];
        }
        if (!(this.sRow instanceof XMLFullRow)) {
            this.sRow = this.sRow.asFullRow();
        }
        if (this.calc != null) {
            ((XMLFullRow)this.sRow).setCalcFun(this::findCalc);
        }
        boolean gridNotNull = (grid = this.getMergeGrid()) != null;
        ((XMLFullRow)this.sRow).setCopyValueFunc(gridNotNull ? grid : new Grid.FastGrid(Dimension.of("A1")), gridNotNull && (this.option >> 17 & 1) == 1 ? this.mergeGrid::merge : (row, cells) -> {});
        this.ready = true;
        if (this.cols == null && this.defaultRowHeight < 0.0 && this.defaultColWidth < 0.0 && this.panes == null && this.showGridLines == 1) {
            XMLSheet.Marker marker = XMLSheet.Marker.of(this);
            try {
                super.load();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            marker.reset();
        }
    }

    @Override
    protected Row createHeader(char[] cb, int start, int n) {
        return ((XMLRow)super.createHeader(cb, start, n)).asFullRow().setCalcFun(this::findCalc);
    }

    void findCalc(int row, Cell[] cells, int n) {
        long r = (long)row << 16;
        int i = Arrays.binarySearch(this.calc, r);
        if (i < 0 && (i ^= 0xFFFFFFFF) >= this.calc.length) {
            return;
        }
        long a = this.calc[i];
        if ((int)(a >> 16) != row) {
            return;
        }
        cells[((int)a & Short.MAX_VALUE) - 1].f = true;
        int j = 1;
        if (n == -1) {
            n = cells.length;
        }
        n = Math.min(n, this.calc.length - i);
        while (j < n && this.calc[i + j] >> 16 == (long)row) {
            cells[((int)this.calc[i + j] & Short.MAX_VALUE) - 1].f = true;
            ++j;
        }
    }

    void parseTails() {
        ArrayList<Dimension> mergeCells = new ArrayList<Dimension>();
        try (InputStream is = this.zipFile.getInputStream(this.entry);){
            int n;
            if (this.lastRowMark > 0L) {
                is.skip(this.lastRowMark);
            }
            int offset = 0;
            int limit = 16384;
            byte[] buf = new byte[limit];
            while ((n = is.read(buf, offset, limit - offset)) > 0) {
                int i;
                int len = n + offset;
                if (len < 11) {
                    offset = len;
                    continue;
                }
                n = len - 12;
                for (i = 0; i < n && (buf[i] != 60 || buf[i + 1] != 47 || buf[i + 2] != 115 || buf[i + 3] != 104 || buf[i + 4] != 101 || buf[i + 5] != 101 || buf[i + 6] != 116 || buf[i + 7] != 68 || buf[i + 8] != 97 || buf[i + 9] != 116 || buf[i + 10] != 97 || buf[i + 11] != 62); ++i) {
                }
                if (i >= n) {
                    if (buf[i] == 60) {
                        offset = len - i;
                        System.arraycopy(buf, i, buf, 0, offset);
                        continue;
                    }
                    offset = 0;
                    continue;
                }
                if (len - i < 11) {
                    offset = len - i;
                    System.arraycopy(buf, i, buf, 0, offset);
                    n = is.read(buf, offset, limit - offset);
                    if (n <= 0) {
                        return;
                    }
                    len = n + offset;
                    if (len < 11) {
                        while ((n = is.read(buf, offset, limit - offset)) > 0 && (len = n + offset) < 11) {
                            offset = len;
                        }
                    }
                    i = 0;
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("", (Throwable)e);
        }
        this.mergeCells = mergeCells;
        this.tailPared = true;
    }

    static long[][] parseCalcChain(InputStream is) {
        Element calcChain;
        SAXReader reader = SAXReaderUtil.createDefault();
        try {
            calcChain = reader.read(is).getRootElement();
        }
        catch (DocumentException e) {
            LOGGER.warn("Part of `calcChain` has be damaged, It will be ignore all formulas.");
            return null;
        }
        Iterator ite = calcChain.elementIterator();
        int i = 1;
        int n = 10;
        long[][] array = new long[n][];
        int[] indices = new int[n];
        while (ite.hasNext()) {
            long[] sub;
            Element e = (Element)ite.next();
            String si = e.attributeValue("i");
            String r = e.attributeValue("r");
            if (StringUtil.isNotEmpty(si)) {
                i = SharedStrings.toInt(si.toCharArray(), 0, si.length());
            }
            if (!StringUtil.isNotEmpty(r)) continue;
            if (n < i) {
                indices = Arrays.copyOf(indices, n <<= 1);
                long[][] _array = new long[n][];
                for (int j = 0; j < n; ++j) {
                    _array[j] = array[j];
                }
                array = _array;
            }
            if ((sub = array[i - 1]) == null) {
                array[i - 1] = sub = new long[10];
            }
            int n2 = i - 1;
            indices[n2] = indices[n2] + 1;
            if (indices[n2] > sub.length) {
                long[] _sub = new long[sub.length << 1];
                System.arraycopy(sub, 0, _sub, 0, sub.length);
                sub = _sub;
                array[i - 1] = _sub;
            }
            sub[indices[i - 1] - 1] = ExcelReader.coordinateToLong(r);
        }
        for (i = 0; i < n; ++i) {
            if (indices[i] > 0) {
                long[] a = Arrays.copyOf(array[i], indices[i]);
                Arrays.sort(a);
                array[i] = a;
                continue;
            }
            array[i] = null;
        }
        return array;
    }

    @Override
    public Grid getMergeGrid() {
        if (this.mergeGrid != null) {
            return this.mergeGrid;
        }
        List<Dimension> dims = this.getMergeCells();
        if (dims != null) {
            this.mergeGrid = GridFactory.create(dims);
            LOGGER.debug("Grid: {} ===> Size: {}", (Object)this.mergeGrid.getClass().getSimpleName(), (Object)this.mergeGrid.size());
        }
        return this.mergeGrid;
    }

    @Override
    public List<Dimension> getMergeCells() {
        if (this.mergeCells == null) {
            this.parseTails();
        }
        return this.mergeCells != null && !this.mergeCells.isEmpty() ? this.mergeCells : null;
    }

    @Override
    protected void subElement(char[] cb, int offset, int n) {
        String v = new String(cb, offset, n);
        v = v.replace("x14ac:", "").replace("r:", "").replace("mc:", "");
        Element e = null;
        if (cb[offset + n - 2] == '/') {
            try {
                Document doc = DocumentHelper.parseText((String)v);
                e = doc.getRootElement();
                switch (e.getName()) {
                    case "dimension": {
                        String ref = e.attributeValue("ref");
                        if (!StringUtil.isNotEmpty(ref)) break;
                        Dimension dim = Dimension.of(ref);
                        if (dim.width <= 1 && dim.height <= 1) break;
                        this.dimension = dim;
                        break;
                    }
                    case "col": {
                        String min = e.attributeValue("min");
                        String max = e.attributeValue("max");
                        String width = e.attributeValue("width");
                        String hidden = e.attributeValue("hidden");
                        String style = e.attributeValue("style");
                        if (this.cols == null) {
                            this.cols = new ArrayList<Col>();
                        }
                        Col col = new Col(Integer.parseInt(min), Integer.parseInt(max), Double.parseDouble(width), "1".equals(hidden));
                        if (StringUtil.isNotEmpty(style)) {
                            col.styleIndex = SharedStrings.toInt(style.toCharArray(), 0, style.length());
                        }
                        this.cols.add(col);
                        break;
                    }
                    case "pane": {
                        String xSplit = e.attributeValue("xSplit");
                        String ySplit = e.attributeValue("ySplit");
                        if (StringUtil.isNotEmpty(ySplit) && Row.testNumberType(ySplit.toCharArray(), 0, ySplit.length()) == 1) {
                            this.panes = Panes.row(Integer.parseInt(ySplit));
                        }
                        if (!StringUtil.isNotEmpty(xSplit) || Row.testNumberType(xSplit.toCharArray(), 0, xSplit.length()) != 1) break;
                        int colIdx = Integer.parseInt(xSplit);
                        if (this.panes != null) {
                            this.panes.col = colIdx;
                            break;
                        }
                        this.panes = Panes.col(colIdx);
                        break;
                    }
                    case "sheetFormatPr": {
                        String defaultColWidth = e.attributeValue("defaultColWidth");
                        String defaultRowHeight = e.attributeValue("defaultRowHeight");
                        if (StringUtil.isNotEmpty(defaultColWidth) && Row.testNumberType(defaultColWidth.toCharArray(), 0, defaultColWidth.length()) > 0) {
                            this.defaultColWidth = Double.parseDouble(defaultColWidth);
                        }
                        if (!StringUtil.isNotEmpty(defaultRowHeight) || Row.testNumberType(defaultRowHeight.toCharArray(), 0, defaultRowHeight.length()) <= 0) break;
                        this.defaultRowHeight = Double.parseDouble(defaultRowHeight);
                    }
                }
            }
            catch (DocumentException ex) {
                LOGGER.warn("Parse header tag [{}] failed.", (Object)v, (Object)ex);
            }
        } else if (v.startsWith("<sheetView") && v.charAt(10) <= ' ') {
            char[] ncb = new char[n + 1];
            System.arraycopy(cb, offset, ncb, 0, n);
            ncb[n - 1] = 47;
            ncb[n] = 62;
            try {
                Document doc = DocumentHelper.parseText((String)new String(ncb, 0, n + 1));
                e = doc.getRootElement();
            }
            catch (DocumentException ex) {
                LOGGER.warn("Parse header tag [{}] failed.", (Object)v, (Object)ex);
            }
        }
        if (e != null && e.getName().equals("sheetView")) {
            String showGridLines = e.attributeValue("showGridLines");
            String zoomScale = e.attributeValue("zoomScale");
            if ("0".equals(showGridLines)) {
                this.showGridLines = 0;
            }
            if (StringUtil.isNotEmpty(zoomScale)) {
                try {
                    this.zoomScale = Integer.parseInt(zoomScale.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public FullSheet copyOnMerged() {
        if (this.sRow != null && this.getMergeGrid() != null) {
            ((XMLFullRow)this.sRow).setCopyValueFunc(this.getMergeGrid(), this.mergeGrid::merge);
        } else {
            this.option |= 0x20000;
        }
        return this;
    }

    @Override
    public Panes getFreezePanes() {
        return this.panes;
    }

    @Override
    public List<Col> getCols() {
        return this.cols;
    }

    @Override
    public Dimension getFilter() {
        if (this.filter == null && !this.tailPared) {
            this.parseTails();
        }
        return this.filter;
    }

    @Override
    public boolean isShowGridLines() {
        return this.showGridLines == 1;
    }

    @Override
    public double getDefaultColWidth() {
        return this.defaultColWidth;
    }

    @Override
    public double getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    @Override
    public Integer getZoomScale() {
        return this.zoomScale;
    }

    @Override
    public Map<Long, Comment> getComments() {
        if (this.comments == null) {
            Relationship commentsRel;
            RelManager relManager = this.getRelManager();
            Relationship relationship = commentsRel = relManager != null ? relManager.getByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments") : null;
            if (commentsRel != null) {
                Relationship vmlRel;
                if (this.mergeCells == null) {
                    this.getMergeCells();
                }
                Relationship relationship2 = vmlRel = StringUtil.isNotEmpty(this.legacyDrawing) ? relManager.getById(this.legacyDrawing) : null;
                if (vmlRel != null) {
                    ZipEntry commentEntry = ExcelReader.getEntry(this.zipFile, "xl/" + ExcelReader.toZipPath(commentsRel.getTarget()));
                    ZipEntry vmlEntry = ExcelReader.getEntry(this.zipFile, "xl/" + ExcelReader.toZipPath(vmlRel.getTarget()));
                    if (commentEntry != null) {
                        try {
                            this.comments = Comments.parseComments(this.zipFile.getInputStream(commentEntry), vmlEntry != null ? this.zipFile.getInputStream(vmlEntry) : null);
                        }
                        catch (IOException ex) {
                            throw new ExcelReadException(ex);
                        }
                    }
                }
            }
            if (this.comments == null) {
                this.comments = Collections.emptyMap();
            }
        }
        return this.comments;
    }
}

