/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.reader.ExcelReader;

public class Dimension {
    public final int firstRow;
    public final int lastRow;
    public final short firstColumn;
    public final short lastColumn;

    public Dimension(int firstRow, short firstColumn) {
        this.firstRow = firstRow;
        this.firstColumn = firstColumn;
        this.lastRow = 0;
        this.lastColumn = 0;
    }

    public Dimension(int firstRow, short firstColumn, int lastRow, short lastColumn) {
        this.firstRow = firstRow;
        this.firstColumn = firstColumn;
        this.lastRow = lastRow;
        this.lastColumn = lastColumn;
    }

    public static Dimension of(String range) {
        int i = range.indexOf(58);
        long f = 0L;
        long t = 0L;
        if (i < 0) {
            f = ExcelReader.cellRangeToLong(range);
        } else if (i == 0) {
            t = ExcelReader.cellRangeToLong(range.substring(i + 1));
        } else {
            f = ExcelReader.cellRangeToLong(range.substring(0, i));
            t = ExcelReader.cellRangeToLong(range.substring(i + 1));
        }
        return new Dimension((int)(f >> 16), (short)f, (int)(t >> 16), (short)t);
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public short getFirstColumn() {
        return this.firstColumn;
    }

    public short getLastColumn() {
        return this.lastColumn;
    }

    public String toString() {
        return new String(Sheet.int2Col(this.firstColumn)) + this.firstRow + (this.lastRow > 0 ? ":" + new String(Sheet.int2Col(this.lastColumn)) + this.lastRow : "");
    }

    public boolean checkRange(int r, int c) {
        return r >= this.firstRow && r <= this.lastRow && c >= this.firstColumn && c <= this.lastColumn;
    }

    public boolean equals(Object o) {
        if (o instanceof Dimension) {
            Dimension other = (Dimension)o;
            return other.firstRow == this.firstRow && other.firstColumn == this.firstColumn && other.lastRow == this.lastRow && other.lastColumn == this.lastColumn;
        }
        return false;
    }
}

