/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Grid;

public class GridFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GridFactory.class);

    private GridFactory() {
    }

    public static Grid create(List<Dimension> mergeCells) {
        Dimension dim = mergeCells.get(0);
        int fr = dim.firstRow;
        int lr = dim.lastRow;
        short fc = dim.firstColumn;
        short lc = dim.lastColumn;
        int n = (lr - fr + 1) * (lc - fc + 1);
        int len = mergeCells.size();
        for (int j = 1; j < len; ++j) {
            dim = mergeCells.get(j);
            n += (dim.lastRow - dim.firstRow + 1) * (dim.lastColumn - dim.firstColumn + 1);
            if (fr > dim.firstRow) {
                fr = dim.firstRow;
            }
            if (lr < dim.lastRow) {
                lr = dim.lastRow;
            }
            if (fc > dim.firstColumn) {
                fc = dim.firstColumn;
            }
            if (lc >= dim.lastColumn) continue;
            lc = dim.lastColumn;
        }
        Dimension range = new Dimension(fr, fc, lr, lc);
        int r = lr - fr + 1;
        int c = lc - fc + 1;
        n = r * c;
        Grid grid = c <= 64 && r < 16384 ? new Grid.FastGrid(range) : (n > 1024 ? new Grid.FractureGrid(range) : new Grid.IndexGrid(range, n));
        for (Dimension d : mergeCells) {
            grid.mark(d);
            LOGGER.debug("merged cells range {}", (Object)d);
        }
        return grid;
    }
}

