/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import org.ttzero.excel.util.StringUtil;

public final class BuiltInNumFmt {
    private static final NumFmt[][] data;
    private static final NumFmt[] idData;

    public static int indexOf(String code) {
        NumFmt v = BuiltInNumFmt.get(code);
        return v != null ? v.id : -1;
    }

    public static NumFmt get(String code) {
        int index = code.length();
        if (index >= data.length) {
            return null;
        }
        NumFmt[] array = data[index];
        if (array == null) {
            return null;
        }
        NumFmt v = null;
        for (NumFmt nf : array) {
            if (!nf.code.equals(code)) continue;
            v = nf;
            break;
        }
        return v;
    }

    public static NumFmt get(int id) {
        return id >= 0 && id < idData.length ? idData[id] : null;
    }

    static {
        InputStream is = BuiltInNumFmt.class.getClassLoader().getResourceAsStream("numFmt");
        if (is != null) {
            ArrayList<NumFmt> list = new ArrayList<NumFmt>();
            int maxLen = 0;
            try (BufferedReader br2 = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String v;
                Locale locale = Locale.ROOT;
                boolean unicode = false;
                boolean damaged = false;
                while ((v = br2.readLine()) != null) {
                    int id;
                    int index;
                    if (StringUtil.isEmpty(v)) continue;
                    if ((v = v.trim()).charAt(0) == '[') {
                        int end = v.indexOf(93);
                        if (end == -1 || end == 1) {
                            damaged = true;
                            continue;
                        }
                        String[] loc = v.substring(1, end).split("-");
                        if (loc.length < 2) {
                            damaged = true;
                            continue;
                        }
                        damaged = false;
                        locale = new Locale(loc[0], loc[1]);
                        unicode = loc.length >= 3 && "unicode".equals(loc[2]);
                        continue;
                    }
                    if (damaged || (index = v.indexOf(61)) <= 0) continue;
                    String v1 = v.substring(0, index).trim();
                    String v2 = v.substring(index + 1).trim();
                    try {
                        id = Integer.parseInt(v1);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    if (v2.charAt(0) != '\'' || v2.charAt(v2.length() - 1) != '\'') continue;
                    NumFmt fmt = new NumFmt();
                    fmt.id = id;
                    fmt.code = v2.substring(1, v2.length() - 1);
                    fmt.locale = locale;
                    fmt.unicode = unicode;
                    list.add(fmt);
                    if (fmt.code.length() <= maxLen) continue;
                    maxLen = fmt.code.length();
                }
            }
            catch (IOException br2) {
                // empty catch block
            }
            idData = new NumFmt[list.size()];
            list.toArray(idData);
            data = new NumFmt[maxLen + 1][];
            for (int i = 1; i <= maxLen; ++i) {
                int length = i;
                BuiltInNumFmt.data[i] = (NumFmt[])list.stream().filter(o -> o.code.length() == length).sorted(Comparator.comparingInt(org.ttzero.excel.entity.style.NumFmt::getId)).toArray(NumFmt[]::new);
                if (data[i].length != 0) continue;
                BuiltInNumFmt.data[i] = null;
            }
        } else {
            data = new NumFmt[0][];
            idData = new NumFmt[0];
        }
    }

    public static class NumFmt
    extends org.ttzero.excel.entity.style.NumFmt {
        private Locale locale;
        private boolean unicode;

        public Locale getLocale() {
            return this.locale;
        }

        public boolean isUnicode() {
            return this.unicode;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (!Locale.ROOT.equals(this.locale)) {
                buf.append('[').append(this.locale.getLanguage()).append('-').append(this.locale.getCountry());
                if (this.unicode) {
                    buf.append('-').append("unicode");
                }
                buf.append("] ");
            }
            buf.append(this.id).append('=').append(this.code);
            return buf.toString();
        }
    }
}

