/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.util.StringUtil;

public interface Grid {
    default public void mark(String coordinate) {
        this.mark(Dimension.of(coordinate));
    }

    default public void mark(char[] chars, int from, int to) {
        this.mark(Dimension.of(new String(chars, from, to - from + 1)));
    }

    public void mark(Dimension var1);

    public boolean test(int var1, int var2);

    public void merge(int var1, Cell var2);

    public int size();

    public static class LinkedScanner
    implements Scanner {
        Node head;
        Node tail;
        private int size;

        @Override
        public void put(Scanner.Entry entry) {
            E e = entry instanceof E ? (E)entry : new E(entry.getDim(), entry.getCell());
            if (this.head != null) {
                Node f = this.head;
                Node bf = null;
                while (f != null) {
                    int p = ((Node)f).entry.getDim().firstRow - entry.getDim().firstRow;
                    if (p > 0 || p == 0 && ((Node)f).entry.getDim().firstColumn > entry.getDim().firstColumn) {
                        Node newNode = new Node(e, f);
                        if (f == this.head) {
                            this.head = newNode;
                            break;
                        }
                        bf.next = newNode;
                        break;
                    }
                    bf = f;
                    f = f.next;
                }
                if (f == null) {
                    this.tail = bf.next = new Node(e, null);
                }
            } else {
                this.head = this.tail = new Node(e, null);
            }
            ++this.size;
        }

        @Override
        public Scanner.Entry get(int r, int c) {
            Node val = null;
            if (this.head == null) {
                return null;
            }
            Node f = this.head;
            Node bf = null;
            while (f != null) {
                if (f.entry.getDim().checkRange(r, c)) {
                    val = f;
                    break;
                }
                bf = f;
                f = f.next;
            }
            if (val != null) {
                int n = --val.entry.n;
                if (n > 0 && val != this.head && ((E)((Node)val).entry).dim.width > 1) {
                    bf.next = val.next;
                    val.next = this.head;
                    this.head = val;
                } else if (n == 0) {
                    if (bf != null) {
                        bf.next = val.next;
                    } else {
                        this.head = val.next;
                    }
                    val.next = null;
                    this.tail.next = val;
                    this.tail = val;
                }
            } else {
                return null;
            }
            return val.entry;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<Scanner.Entry> iterator() {
            return new ForwardIterator(this.head);
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner("->");
            for (Scanner.Entry entry : this) {
                joiner.add(entry.getDim().toString());
            }
            return joiner.toString();
        }

        private static class ForwardIterator
        implements Iterator<Scanner.Entry> {
            private Node first;

            ForwardIterator(Node first) {
                this.first = first;
            }

            @Override
            public boolean hasNext() {
                return this.first != null;
            }

            @Override
            public Scanner.Entry next() {
                E e = this.first.entry;
                this.first = this.first.next;
                return e;
            }
        }

        private static class Node {
            private Node next;
            private final E entry;

            Node(E entry, Node next) {
                this.entry = entry;
                this.next = next;
            }
        }

        static final class E
        implements Scanner.Entry {
            private final Dimension dim;
            private final Cell cell;
            private int n;

            E(Dimension dim, Cell cell) {
                this.dim = dim;
                this.cell = cell;
                this.n = (dim.lastRow - dim.firstRow + 1) * (dim.lastColumn - dim.firstColumn + 1);
            }

            @Override
            public Dimension getDim() {
                return this.dim;
            }

            @Override
            public Cell getCell() {
                return this.cell;
            }
        }
    }

    public static interface Scanner
    extends Iterable<Entry> {
        public void put(Entry var1);

        public Entry get(int var1, int var2);

        public int size();

        public static interface Entry {
            public Dimension getDim();

            public Cell getCell();
        }
    }

    public static final class FractureGrid
    implements Grid {
        private final int fr;
        private final int fc;
        private final int lr;
        private final int lc;
        private final LinkedScanner scanner;

        FractureGrid(Dimension dim) {
            this.fr = dim.firstRow;
            this.lr = dim.lastRow;
            this.fc = dim.firstColumn;
            this.lc = dim.lastColumn;
            this.scanner = new LinkedScanner();
        }

        @Override
        public void mark(Dimension dim) {
            this.scanner.put(new LinkedScanner.E(dim, new Cell()));
        }

        @Override
        public boolean test(int r, int c) {
            return this.range(r, c) && this.scanner.get(r, c) != null;
        }

        @Override
        public void merge(int r, Cell cell) {
            if (!this.range(r, cell.i)) {
                return;
            }
            Scanner.Entry e = this.scanner.get(r, cell.i);
            if (e == null) {
                return;
            }
            if (cell.t == 'e' || cell.t == 'k') {
                cell.from(e.getCell());
            } else {
                e.getCell().from(cell);
            }
        }

        @Override
        public int size() {
            return this.scanner.size;
        }

        boolean range(int r, int c) {
            return r >= this.fr && r <= this.lr && c >= this.fc && c <= this.lc;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " has " + this.scanner.size() + " dimensions";
        }
    }

    public static final class IndexGrid
    implements Grid {
        private final int fr;
        private final int fc;
        private final int lr;
        private final int lc;
        private final Map<Long, Cell> index;
        private int size;

        IndexGrid(Dimension dim, int n) {
            this.fr = dim.firstRow;
            this.lr = dim.lastRow;
            this.fc = dim.firstColumn;
            this.lc = dim.lastColumn;
            this.index = new HashMap<Long, Cell>(n);
        }

        @Override
        public void mark(Dimension dim) {
            Cell cell = new Cell();
            for (int i = dim.firstRow; i <= dim.lastRow; ++i) {
                for (int j = dim.firstColumn; j <= dim.lastColumn; ++j) {
                    this.index.put((long)i << 16 | (long)j, cell);
                }
            }
            ++this.size;
        }

        @Override
        public boolean test(int r, int c) {
            return this.range(r, c) && this.index.containsKey((long)r << 16 | (long)c);
        }

        @Override
        public void merge(int r, Cell cell) {
            if (!this.range(r, cell.i)) {
                return;
            }
            Cell c = this.index.get((long)r << 16 | (long)cell.i);
            if (c == null) {
                return;
            }
            if (cell.t == 'e' || cell.t == 'k') {
                cell.from(c);
            } else {
                c.from(cell);
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        boolean range(int r, int c) {
            return r >= this.fr && r <= this.lr && c >= this.fc && c <= this.lc;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " has " + this.index.size() + " keys";
        }
    }

    public static final class FastGrid
    implements Grid {
        private final int fr;
        private final int fc;
        private final int lr;
        private final int lc;
        private final long[] g;
        private final int c;
        private final Scanner scanner;
        private final char[] chars = new char[64];

        FastGrid(Dimension dim) {
            this.fr = dim.firstRow;
            this.lr = dim.lastRow;
            this.fc = dim.firstColumn;
            this.lc = dim.lastColumn;
            int nc = this.lc - this.fc + 1;
            int nr = this.lr - this.fr + 1;
            int b = FastGrid.powerOneBit(nc);
            this.c = Integer.numberOfTrailingZeros(b + 1) + (FastGrid.isPowerOfTwo(nc) ? -1 : 0);
            int n = 6 - this.c;
            int len = nr >> n;
            this.g = new long[len > 0 ? (nr > len << n ? len + 1 : len) : 1];
            this.scanner = new FastLinkedScanner();
        }

        static int powerOneBit(int i) {
            i |= i >> 1;
            i |= i >> 2;
            i |= i >> 4;
            i |= i >> 8;
            i |= i >> 16;
            return i;
        }

        static boolean isPowerOfTwo(int n) {
            return (n & -n) == n;
        }

        @Override
        public void mark(Dimension dimension) {
            int n = dimension.lastColumn - dimension.firstColumn + 1;
            int p = 1 << 6 - this.c;
            long l = (-1L >> n << n ^ 0xFFFFFFFFFFFFFFFFL) << dimension.firstColumn - this.fc;
            for (int i = dimension.firstRow; i <= dimension.lastRow; ++i) {
                int n2 = this.getRow(i);
                this.g[n2] = this.g[n2] | l << (p - (i - this.fr + 1 & p - 1) << this.c);
            }
            this.scanner.put(new LinkedScanner.E(dimension, new Cell()));
        }

        @Override
        public boolean test(int r, int c) {
            if (!this.range(r, c)) {
                return false;
            }
            long l = this.g[this.getRow(r)];
            int p = 1 << 6 - this.c;
            l >>= p - (r - this.fr + 1 & p - 1) << this.c;
            return ((l >>= c - this.fc) & 1L) == 1L;
        }

        @Override
        public void merge(int r, Cell cell) {
            if (!this.test(r, cell.i)) {
                return;
            }
            Scanner.Entry e = this.scanner.get(r, cell.i);
            if (cell.t == 'e' || cell.t == 'k') {
                cell.from(e.getCell());
            } else {
                e.getCell().from(cell);
            }
        }

        @Override
        public int size() {
            return this.scanner.size();
        }

        boolean range(int r, int c) {
            return r >= this.fr && r <= this.lr && c >= this.fc && c <= this.lc;
        }

        int getRow(int i) {
            return i - this.fr >> 6 - this.c;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner("\n");
            joiner.add(this.getClass().getSimpleName() + " Size: " + StringUtil.formatBinarySize(this.g.length << 3));
            int last = this.lr - this.fr + 1;
            int j = 0;
            block0: for (long l : this.g) {
                String s = this.append(Long.toBinaryString(l));
                int n = 1 << 6 - this.c;
                for (int i = 0; i < n; ++i) {
                    joiner.add(s.substring(i << this.c, i + 1 << this.c));
                    if (++j >= last) break block0;
                }
            }
            return joiner.toString();
        }

        private String append(String s) {
            int n = s.length();
            s.getChars(0, n, this.chars, this.chars.length - n);
            Arrays.fill(this.chars, 0, this.chars.length - n, '0');
            return new String(this.chars);
        }

        private static class FastLinkedScanner
        extends LinkedScanner {
            private FastLinkedScanner() {
            }

            @Override
            public Scanner.Entry get(int r, int c) {
                if (this.size() == 1) {
                    return this.head.entry;
                }
                return super.get(r, c);
            }
        }
    }
}

