/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.util.Arrays;
import org.ttzero.excel.reader.CalcSheet;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.XMLCalcRow;
import org.ttzero.excel.reader.XMLSheet;

class XMLCalcSheet
extends XMLSheet
implements CalcSheet {
    private long[] calc;
    boolean ready;

    XMLCalcSheet(XMLSheet sheet) {
        this.name = sheet.name;
        this.index = sheet.index;
        this.path = sheet.path;
        this.sst = sheet.sst;
        this.styles = sheet.styles;
        this.id = sheet.id;
        this.startRow = sheet.startRow;
        this.header = sheet.header;
        this.hidden = sheet.hidden;
        this.dimension = sheet.dimension;
        this.drawings = sheet.drawings;
        this.reader = sheet.reader;
        this.cb = sheet.cb;
        this.nChar = sheet.nChar;
        this.length = sheet.length;
        this.eof = sheet.eof;
        this.heof = sheet.heof;
        this.mark = sheet.mark;
        this.sRow = sheet.sRow;
        this.lastRowMark = sheet.lastRowMark;
        if (this.path != null && this.reader != null && !this.ready) {
            this.load0();
        }
    }

    @Override
    public XMLCalcSheet load() throws IOException {
        super.load();
        this.load0();
        return this;
    }

    void load0() {
        if (this.ready) {
            return;
        }
        long[][] calcArray = ExcelReader.parseCalcChain(this.path.getParent());
        if (calcArray != null && calcArray.length >= this.id) {
            this.setCalc(calcArray[this.id - 1]);
        }
        if (!this.eof && !(this.sRow instanceof XMLCalcRow)) {
            this.sRow = this.sRow.asCalcRow();
            if (this.calc != null) {
                ((XMLCalcRow)this.sRow).setCalcFun(this::findCalc);
            }
        }
        this.ready = true;
    }

    XMLCalcSheet setCalc(long[] calc) {
        this.calc = calc;
        return this;
    }

    @Override
    Row createHeader(char[] cb, int start, int n) {
        return new XMLCalcRow(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1, this::findCalc).with(cb, start, n);
    }

    private void findCalc(int row, Cell[] cells, int n) {
        long r = (long)row << 16;
        int i = Arrays.binarySearch(this.calc, r);
        if (i < 0 && (i ^= 0xFFFFFFFF) >= this.calc.length) {
            return;
        }
        long a = this.calc[i];
        if ((int)(a >> 16) != row) {
            return;
        }
        cells[((int)a & Short.MAX_VALUE) - 1].f = true;
        int j = 1;
        if (n == -1) {
            n = cells.length;
        }
        n = Math.min(n, this.calc.length - i);
        while (j < n && this.calc[i + j] >> 16 == (long)row) {
            cells[((int)this.calc[i + j] & Short.MAX_VALUE) - 1].f = true;
            ++j;
        }
    }
}

