/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.GridFactory;
import org.ttzero.excel.reader.MergeSheet;
import org.ttzero.excel.reader.XMLMergeRow;
import org.ttzero.excel.reader.XMLSheet;

class XMLMergeSheet
extends XMLSheet
implements MergeSheet {
    private Grid mergeCells;
    boolean ready;

    XMLMergeSheet(XMLSheet sheet) {
        this.name = sheet.name;
        this.index = sheet.index;
        this.path = sheet.path;
        this.sst = sheet.sst;
        this.styles = sheet.styles;
        this.id = sheet.id;
        this.startRow = sheet.startRow;
        this.header = sheet.header;
        this.hidden = sheet.hidden;
        this.dimension = sheet.dimension;
        this.drawings = sheet.drawings;
        this.reader = sheet.reader;
        this.cb = sheet.cb;
        this.nChar = sheet.nChar;
        this.length = sheet.length;
        this.eof = sheet.eof;
        this.heof = sheet.heof;
        this.mark = sheet.mark;
        this.sRow = sheet.sRow;
        this.lastRowMark = sheet.lastRowMark;
        if (this.path != null && this.reader != null && !this.ready) {
            this.load0();
        }
    }

    @Override
    public XMLMergeSheet load() throws IOException {
        super.load();
        this.load0();
        return this;
    }

    void load0() {
        if (this.ready) {
            return;
        }
        if (this.mergeCells == null && !this.eof) {
            this.parseMerge();
        }
        if (!this.eof && !(this.sRow instanceof XMLMergeRow) && this.mergeCells != null) {
            this.sRow = this.sRow.asMergeRow().setCopyValueFunc(this::mergeCell);
        }
        this.ready = true;
    }

    void parseMerge() {
        try (SeekableByteChannel channel = Files.newByteChannel(this.path, StandardOpenOption.READ);){
            boolean getit;
            ByteBuffer buffer;
            int block;
            block21: {
                long position = Files.size(this.path);
                block = (int)Math.min(2048L, position);
                int c = 12;
                buffer = ByteBuffer.allocate(block);
                int left_size = 0;
                getit = false;
                if (this.lastRowMark > 0L) {
                    channel.position(this.lastRowMark);
                    channel.read(buffer);
                    buffer.flip();
                    getit = true;
                } else {
                    int i;
                    byte[] left = new byte[12];
                    while (true) {
                        channel.position(position -= (long)(block - left_size));
                        channel.read(buffer);
                        if (left_size > 0) {
                            buffer.limit(block);
                            buffer.put(left, 0, left_size);
                        }
                        buffer.flip();
                        boolean eof = buffer.limit() < block;
                        int limit = buffer.limit();
                        for (i = limit - 1; i >= 12 && (buffer.get(i) != 62 || buffer.get(i - 1) != 97 || buffer.get(i - 2) != 116 || buffer.get(i - 3) != 97 || buffer.get(i - 4) != 68 || buffer.get(i - 5) != 116 || buffer.get(i - 6) != 101 || buffer.get(i - 7) != 101 || buffer.get(i - 8) != 104 || buffer.get(i - 9) != 115 || buffer.get(i - 10) != 47 || buffer.get(i - 11) != 60); --i) {
                        }
                        if (i >= 12) break;
                        if (!eof) {
                            buffer.position(0);
                            left_size = 12;
                            buffer.get(left, 0, left_size);
                            buffer.clear();
                            buffer.limit(block - left_size);
                            continue;
                        }
                        break block21;
                        break;
                    }
                    buffer.position(i + 1);
                    getit = true;
                    channel.position(channel.position() + (long)left_size);
                }
            }
            if (getit) {
                this.parseMerge(channel, buffer, block);
            }
        }
        catch (IOException e) {
            this.LOGGER.warn("", (Throwable)e);
        }
    }

    void parseMerge(SeekableByteChannel channel, ByteBuffer buffer, int block) throws IOException {
        ArrayList<Dimension> mergeCells = new ArrayList<Dimension>();
        boolean eof = false;
        int limit = buffer.limit();
        int i = buffer.position();
        byte[] bytes = new byte[32];
        while (true) {
            if (i < limit - 11 && (buffer.get(i) != 60 || buffer.get(i + 1) != 109 || buffer.get(i + 2) != 101 || buffer.get(i + 3) != 114 || buffer.get(i + 4) != 103 || buffer.get(i + 5) != 101 || buffer.get(i + 6) != 67 || buffer.get(i + 7) != 101 || buffer.get(i + 8) != 108 || buffer.get(i + 9) != 108 || buffer.get(i + 10) > 32)) {
                ++i;
                continue;
            }
            if (i >= limit - 22) {
                if (eof) break;
                buffer.position(limit - 22);
                while (i < buffer.limit() && buffer.get() != 60) {
                    ++i;
                }
                if (buffer.get(buffer.position() - 1) == 60) {
                    buffer.position(buffer.position() - 1);
                }
                buffer.compact();
                channel.read(buffer);
                buffer.flip();
                limit = buffer.limit();
                if (limit <= 0) break;
                i = 0;
                eof = limit < block;
                continue;
            }
            i += 11;
            while (i < limit - 5 && (buffer.get(i) != 114 || buffer.get(i + 1) != 101 || buffer.get(i + 2) != 102 || buffer.get(i + 3) != 61 || buffer.get(i + 4) != 34)) {
                ++i;
            }
            int f = i += 5;
            while (i < limit && buffer.get(i) != 34) {
                ++i;
            }
            if (i >= limit) {
                buffer.compact();
                channel.read(buffer);
                buffer.flip();
                limit = buffer.limit();
                if (limit <= 0) break;
                i = 0;
                eof = limit < block;
                continue;
            }
            int n = i - f;
            if (n > bytes.length) {
                bytes = new byte[n];
            }
            buffer.position(f);
            buffer.get(bytes, 0, n);
            mergeCells.add(Dimension.of(new String(bytes, 0, n, StandardCharsets.US_ASCII)));
            buffer.get();
        }
        if (!mergeCells.isEmpty()) {
            this.mergeCells = GridFactory.create(mergeCells);
            this.LOGGER.debug("Grid: Size: {} ==> {}", (Object)this.mergeCells.size(), (Object)this.mergeCells);
        }
    }

    private void mergeCell(int row, Cell cell) {
        this.mergeCells.merge(row, cell);
    }

    @Override
    public Grid getMergeGrid() {
        return this.mergeCells;
    }
}

