/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class ExtBufferedWriter
extends BufferedWriter {
    private static final int defaultCharBufferSize = 8192;
    private final char[][] cache_char_array = new char[25][];
    static final char[] MIN_INTEGER_CHARS = new char[]{'-', '2', '1', '4', '7', '4', '8', '3', '6', '4', '8'};
    static final char[] MIN_LONG_CHARS = "-9223372036854775808".toCharArray();
    private static final char[][] ESCAPE_CHARS = new char[63][];
    private static final int[] sizeTable;
    private static final char[] digitTens;
    private static final char[] digitOnes;
    private static final char[] digits;

    public ExtBufferedWriter(Writer out) {
        this(out, 8192);
    }

    public ExtBufferedWriter(Writer out, int sz) {
        super(out, sz);
        for (int i = 0; i < this.cache_char_array.length; ++i) {
            this.cache_char_array[i] = new char[i + 1];
        }
    }

    public void writeInt(int n) throws IOException {
        char[] temp = this.toChars(n);
        this.write(temp);
    }

    public void write(long l) throws IOException {
        char[] temp = this.toChars(l);
        this.write(temp);
    }

    public void write(float f) throws IOException {
        this.write(Float.toString(f));
    }

    public void escapeWrite(char c) throws IOException {
        if (c > '>') {
            this.write(c);
        } else if (c >= ' ') {
            char[] entity = ESCAPE_CHARS[c];
            if (entity != null) {
                this.write(entity);
            } else {
                this.write(c);
            }
        }
    }

    public void escapeWrite(String text) throws IOException {
        int i;
        char[] block = text.toCharArray();
        int last = 0;
        int size = text.length();
        for (i = 0; i < size; ++i) {
            char[] entity;
            char c = block[i];
            if (c > '>' || (entity = ESCAPE_CHARS[c]) == null) continue;
            this.write(block, last, i - last);
            this.write(entity);
            last = i + 1;
        }
        if (last < size) {
            this.write(block, last, i - last);
        }
    }

    public void write(double d) throws IOException {
        this.write(Double.toString(d));
    }

    private char[] toChars(int i) {
        if (i == Integer.MIN_VALUE) {
            return MIN_INTEGER_CHARS;
        }
        int size = ExtBufferedWriter.stringSize(i);
        ExtBufferedWriter.getChars(i, size, this.cache_char_array[size - 1]);
        return this.cache_char_array[size - 1];
    }

    public static int stringSize(int x) {
        boolean negative;
        boolean bl = negative = x < 0;
        if (negative) {
            x = ~x + 1;
        }
        int i = 0;
        while (true) {
            if (x <= sizeTable[i]) break;
            ++i;
        }
        int l = i + 1;
        return negative ? l + 1 : l;
    }

    static void getChars(int i, int index, char[] buf) {
        int r;
        int q;
        int charPos = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = digitOnes[r];
            buf[--charPos] = digitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    private char[] toChars(long i) {
        if (i == Long.MIN_VALUE) {
            return MIN_LONG_CHARS;
        }
        int size = ExtBufferedWriter.stringSize(i);
        ExtBufferedWriter.getChars(i, size, this.cache_char_array[size - 1]);
        return this.cache_char_array[size - 1];
    }

    public static int stringSize(long x) {
        int i;
        boolean negative;
        boolean bl = negative = x < 0L;
        if (negative) {
            x = (x ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
        }
        int l = 0;
        long p = 10L;
        for (i = 1; i < 19; ++i) {
            if (x < p) {
                l = i;
                break;
            }
            p = 10L * p;
        }
        if (i >= 19) {
            l = 19;
        }
        return negative ? l + 1 : l;
    }

    static void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = digitOnes[r];
            buf[--charPos] = digitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = digitOnes[r];
            buf[--charPos] = digitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    static {
        ExtBufferedWriter.ESCAPE_CHARS[60] = "&lt;".toCharArray();
        ExtBufferedWriter.ESCAPE_CHARS[62] = "&gt;".toCharArray();
        ExtBufferedWriter.ESCAPE_CHARS[38] = "&amp;".toCharArray();
        ExtBufferedWriter.ESCAPE_CHARS[34] = "&quot;".toCharArray();
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        digitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        digitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    }
}

