/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.ttzero.excel.annotation.TopNS;
import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.util.ExtBufferedWriter;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={""}, value="comments", uri={"http://schemas.openxmlformats.org/spreadsheetml/2006/main"})
public class Comments
implements Storable,
Closeable {
    public List<C> commentList = new ArrayList<C>();
    public int id;
    public String author;

    public Comments() {
    }

    public Comments(int id, String author) {
        this.id = id;
        this.author = author;
    }

    public C addComment(String ref, String title, String value) {
        C c = new C();
        c.ref = ref;
        c.text = new ArrayList<R>();
        if (StringUtil.isNotEmpty(title)) {
            this.parse(title, true, c.text);
        }
        if (StringUtil.isNotEmpty(value)) {
            this.parse(value, false, c.text);
        }
        this.commentList.add(c);
        return c;
    }

    public C addComment(String ref, Comment comment) {
        C c = new C();
        c.ref = ref;
        c.text = new ArrayList<R>();
        c.width = comment.getWidth();
        c.height = comment.getHeight();
        if (StringUtil.isNotEmpty(comment.getTitle())) {
            this.parse(comment.getTitle(), true, c.text);
        }
        if (StringUtil.isNotEmpty(comment.getValue())) {
            this.parse(comment.getValue(), false, c.text);
        }
        this.commentList.add(c);
        return c;
    }

    protected void parse(String val, boolean bold, List<R> list) {
        R r = new R();
        r.rPr = new Pr("\u5b8b\u4f53", 9);
        if (bold) {
            r.rPr.bold();
            if (val.charAt(val.length() - 1) != '\n') {
                val = val + '\n';
            }
        }
        r.t = val;
        list.add(r);
    }

    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void writeTo(Path root) throws IOException {
        if (this.commentList.isEmpty()) {
            return;
        }
        try (ExtBufferedWriter writer = new ExtBufferedWriter(Files.newBufferedWriter(root.resolve("comments" + this.id + ".xml"), new OpenOption[0]));){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            writer.newLine();
            TopNS topNS = this.getClass().getAnnotation(TopNS.class);
            writer.write(60);
            writer.write(topNS.value());
            writer.write(" xmlns=\"");
            writer.write(topNS.uri()[0]);
            writer.write("\"><authors><author>");
            writer.escapeWrite(StringUtil.isNotEmpty(this.author) ? this.author : System.getProperty("user.name"));
            writer.write("</author></authors><commentList>");
            for (C c : this.commentList) {
                writer.write("<comment ref=\"");
                writer.write(c.ref);
                writer.write("\" authorId=\"0\"><text>");
                for (R r : c.text) {
                    writer.write("<r>");
                    writer.write(r.rPr.toString());
                    writer.write("<t");
                    writer.write(r.t.indexOf(10) > 0 ? " xml:space=\"preserve\">" : ">");
                    writer.escapeWrite(r.t);
                    writer.write("</t></r>");
                }
                writer.write("</text></comment>");
            }
            writer.write("</commentList></comments>");
        }
        this.vml(root);
    }

    protected void vml(Path root) throws IOException {
        Path parent = root.resolve("drawings");
        if (!Files.exists(parent, new LinkOption[0])) {
            FileUtil.mkdir(parent);
        }
        try (ExtBufferedWriter writer = new ExtBufferedWriter(Files.newBufferedWriter(parent.resolve("vmlDrawing" + this.id + ".vml"), new OpenOption[0]));){
            writer.write("<xml xmlns:v=\"urn:schemas-microsoft-com:vml\"");
            writer.write(" xmlns:o=\"urn:schemas-microsoft-com:office:office\"");
            writer.write(" xmlns:x=\"urn:schemas-microsoft-com:office:excel\">");
            writer.write(" <o:shapelayout v:ext=\"edit\">");
            writer.write("  <o:idmap v:ext=\"edit\" data=\"1\"/>");
            writer.write(" </o:shapelayout>");
            writer.write(" <v:shapetype id=\"_x0000_t202\" coordsize=\"21600,21600\" o:spt=\"202\"");
            writer.write("  path=\"m,l,21600r21600,l21600,xe\">");
            writer.write("  <v:stroke joinstyle=\"miter\"/>");
            writer.write("  <v:path gradientshapeok=\"t\" o:connecttype=\"rect\"/>");
            writer.write(" </v:shapetype>");
            int i = 1;
            for (C c : this.commentList) {
                long cr = ExcelReader.cellRangeToLong(c.ref);
                writer.write(" <v:shape id=\"_x0000_s");
                writer.write(100 + i);
                writer.write("\" type=\"#_x0000_t202\" style='width:" + (c.width != null ? c.width : 100.8) + "pt;height:" + (c.height != null ? c.height : 60.6) + " pt;z-index:");
                writer.writeInt(i++);
                writer.write(";  visibility:hidden' fillcolor=\"#ffffe1\" o:insetmode=\"auto\">");
                writer.write("  <v:fill color2=\"#ffffe1\"/>");
                writer.write("  <v:shadow on=\"t\" color=\"black\" obscured=\"t\"/>");
                writer.write("  <v:path o:connecttype=\"none\"/>");
                writer.write("  <v:textbox style='mso-direction-alt:auto'>");
                writer.write("   <div style='text-align:left'></div>");
                writer.write("  </v:textbox>");
                writer.write("  <x:ClientData ObjectType=\"Note\">");
                writer.write("   <x:MoveWithCells/>");
                writer.write("   <x:SizeWithCells/>");
                writer.write("   <x:Anchor/>");
                writer.write("   <x:AutoFill>False</x:AutoFill>");
                writer.write("   <x:Row>");
                writer.write((cr >> 16) - 1L);
                writer.write("</x:Row>");
                writer.write("   <x:Column>");
                writer.write((cr & 0x7FFFL) - 1L);
                writer.write("</x:Column>");
                writer.write("  </x:ClientData>");
                writer.write(" </v:shape>");
            }
            writer.write("</xml>");
        }
    }

    public static class Pr
    extends Font {
        public static final String[] STYLE = new String[]{"", "<u/>", "<b/>", "<u/><b/>", "<i/>", "<i/><u/>", "<b/><i/>", "<i/><b/><u/>"};

        public Pr(String name, int size) {
            super(name, size);
        }

        @Override
        public String toString() {
            return "<rPr>" + STYLE[this.getStyle() & 7] + "<sz val=\"" + this.getSize() + "\"/><rFont val=\"" + this.getName() + "\"/><charset val=\"" + this.getCharset() + "\"/></rPr>";
        }
    }

    public static class R {
        public Pr rPr;
        public String t;

        public String toString() {
            return "<r>" + this.rPr + "<t" + (this.t.indexOf(10) > 0 ? " xml:space=\"preserve\">" : ">") + this.t + "</t></r>";
        }
    }

    public static class C {
        public String ref;
        public List<R> text;
        public Double width;
        public Double height;

        public String toString() {
            StringBuilder buf = new StringBuilder("<comment ref=\"").append(this.ref).append("\" authorId=\"0\"><text>");
            for (R r : this.text) {
                buf.append(r);
            }
            buf.append("</text>").append("</comment>");
            return buf.toString();
        }
    }
}

