/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.StringUtil;

public class ListMapSheet
extends ListSheet<Map<String, ?>> {
    public ListMapSheet() {
    }

    public ListMapSheet(String name) {
        super(name);
    }

    public ListMapSheet(String name, Column ... columns) {
        super(name, columns);
    }

    public ListMapSheet(String name, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
    }

    public ListMapSheet(List<Map<String, ?>> data) {
        this((String)null, data);
    }

    public ListMapSheet(String name, List<Map<String, ?>> data) {
        super(name);
        this.setData(data);
    }

    public ListMapSheet(List<Map<String, ?>> data, Column ... columns) {
        this((String)null, data, columns);
    }

    public ListMapSheet(String name, List<Map<String, ?>> data, Column ... columns) {
        this(name, data, (WaterMark)null, columns);
    }

    public ListMapSheet(List<Map<String, ?>> data, WaterMark waterMark, Column ... columns) {
        this((String)null, data, waterMark, columns);
    }

    public ListMapSheet(String name, List<Map<String, ?>> data, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
        this.setData(data);
    }

    @Override
    protected void resetBlockData() {
        boolean hasGlobalStyleProcessor;
        if (!this.eof && this.left() < this.getRowBlockSize()) {
            this.append();
        }
        int end = this.getEndIndex();
        int len = this.columns.length;
        boolean bl = hasGlobalStyleProcessor = (this.extPropMark & 2) == 2;
        while (this.start < end) {
            Row row = this.rowBlock.next();
            row.index = this.rows;
            Cell[] cells = row.realloc(len);
            Map rowDate = (Map)this.data.get(this.start);
            for (int i = 0; i < len; ++i) {
                Column hc = this.columns[i];
                Object e = rowDate != null ? rowDate.get(hc.key) : null;
                Cell cell = cells[i];
                cell.clear();
                this.cellValueAndStyle.reset(this.rows, cell, e, hc);
                if (!hasGlobalStyleProcessor) continue;
                this.cellValueAndStyle.setStyleDesign(rowDate, cell, hc, this.getStyleProcessor());
            }
            ++this.rows;
            ++this.start;
        }
    }

    @Override
    protected Column[] getHeaderColumns() {
        if (this.headerReady) {
            return this.columns;
        }
        Map first = (Map)this.getFirst();
        if (first == null) {
            if (this.columns == null) {
                this.columns = new Column[0];
            }
        } else if (!this.hasHeaderColumns()) {
            int size = first.size();
            int i = 0;
            this.columns = new Column[size];
            for (Map.Entry entry : first.entrySet()) {
                Column hc = this.createColumn(entry);
                if (hc == null) continue;
                this.columns[i++] = hc;
            }
            if (i < size) {
                this.columns = Arrays.copyOf(this.columns, i);
            }
        } else {
            for (int i = 0; i < this.columns.length; ++i) {
                Column hc;
                Column column = hc = this.columns[i].tail != null ? this.columns[i].tail : this.columns[i];
                if (StringUtil.isEmpty(hc.key)) {
                    throw new ExcelWriteException(this.getClass() + " must specify the 'key' name.");
                }
                if (hc.getClazz() != null) continue;
                Object o = first.get(hc.key);
                hc.setClazz(o != null ? o.getClass() : String.class);
            }
        }
        return this.columns;
    }

    protected Column createColumn(Map.Entry<String, ?> entry) {
        Object value;
        if (StringUtil.isEmpty(entry.getKey())) {
            return null;
        }
        return new Column(entry.getKey(), entry.getKey(), (value = entry.getValue()) != null ? value.getClass() : String.class);
    }
}

