/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.ResultSetSheet;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.processor.ParamProcessor;

public class StatementSheet
extends ResultSetSheet {
    private PreparedStatement ps;

    public StatementSheet() {
    }

    public StatementSheet(String name) {
        super(name);
    }

    public StatementSheet(Column ... columns) {
        super(columns);
    }

    public StatementSheet(String name, Column ... columns) {
        super(name, columns);
    }

    public StatementSheet(String name, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
    }

    public StatementSheet(Connection con, String sql) {
        this(null, con, sql);
    }

    public StatementSheet(String name, Connection con, String sql) {
        super(name);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql, 1003, 1007);
            ps.setFetchSize(Integer.MIN_VALUE);
            ps.setFetchDirection(1001);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (ps == null) {
            throw new ExcelWriteException("Constructor worksheet error.\nMiss the parameter Statement");
        }
        this.ps = ps;
    }

    public StatementSheet(Connection con, String sql, ParamProcessor pp) {
        this(null, con, sql, pp);
    }

    public StatementSheet(String name, Connection con, String sql, ParamProcessor pp) {
        super(name);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql, 1003, 1007);
            ps.setFetchSize(Integer.MIN_VALUE);
            ps.setFetchDirection(1001);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (ps == null) {
            throw new ExcelWriteException("Constructor worksheet error.\nMiss the parameter Statement");
        }
        if (pp != null) {
            try {
                pp.build(ps);
            }
            catch (SQLException e) {
                throw new ExcelWriteException(e);
            }
        }
        this.ps = ps;
    }

    public StatementSheet(Connection con, String sql, Column ... columns) {
        this(null, con, sql, columns);
    }

    public StatementSheet(String name, Connection con, String sql, Column ... columns) {
        this(name, con, sql, (ParamProcessor)null, columns);
    }

    public StatementSheet(Connection con, String sql, ParamProcessor pp, Column ... columns) {
        this(null, con, sql, pp, columns);
    }

    public StatementSheet(String name, Connection con, String sql, ParamProcessor pp, Column ... columns) {
        super(name, columns);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql, 1003, 1007);
            ps.setFetchSize(Integer.MIN_VALUE);
            ps.setFetchDirection(1001);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (ps == null) {
            throw new ExcelWriteException("Constructor worksheet error.\nMiss the parameter Statement");
        }
        if (pp != null) {
            try {
                pp.build(ps);
            }
            catch (SQLException e) {
                throw new ExcelWriteException(e);
            }
        }
        this.ps = ps;
    }

    public StatementSheet setPs(PreparedStatement ps) {
        this.ps = ps;
        return this;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.shouldClose && this.ps != null) {
            try {
                this.ps.close();
            }
            catch (SQLException e) {
                this.what("9006", e.getMessage());
            }
        }
    }

    @Override
    public void writeTo(Path path) throws IOException {
        if (this.sheetWriter != null) {
            if (!this.copySheet) {
                if (this.ps == null) {
                    throw new ExcelWriteException("Constructor worksheet error.\nMiss the parameter Statement");
                }
                try {
                    this.rs = this.ps.executeQuery();
                }
                catch (SQLException e) {
                    throw new ExcelWriteException(e);
                }
                this.getAndSortHeaderColumns();
            }
            if (this.rowBlock == null) {
                this.rowBlock = new RowBlock(this.getRowBlockSize());
            } else {
                this.rowBlock.reopen();
            }
        } else {
            throw new ExcelWriteException("Worksheet writer is not instanced.");
        }
        this.sheetWriter.writeTo(path);
    }
}

