/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.dom4j.Element;
import org.ttzero.excel.entity.style.BorderParseException;
import org.ttzero.excel.entity.style.BorderStyle;
import org.ttzero.excel.entity.style.ColorIndex;
import org.ttzero.excel.entity.style.ColorParseException;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.util.StringUtil;

public class Border {
    private static final Color defaultColor = new Color(51, 51, 51);
    private final SubBorder[] borders = new SubBorder[6];
    static final String[] direction = new String[]{"left", "right", "top", "bottom", "diagonal", "diagonal"};

    public Border() {
    }

    public Border(BorderStyle style, Color color) {
        this.setBorder(style, color);
    }

    public Border setBorderTop(BorderStyle style) {
        this.borders[2] = new SubBorder(style, defaultColor);
        return this;
    }

    public Border setBorderRight(BorderStyle style) {
        this.borders[1] = new SubBorder(style, defaultColor);
        return this;
    }

    public Border setBorderBottom(BorderStyle style) {
        this.borders[3] = new SubBorder(style, defaultColor);
        return this;
    }

    public Border setBorderLeft(BorderStyle style) {
        this.borders[0] = new SubBorder(style, defaultColor);
        return this;
    }

    public Border setDiagonalDown(BorderStyle style) {
        this.borders[4] = new SubBorder(style, defaultColor);
        return this;
    }

    public Border setDiagonalUp(BorderStyle style) {
        this.borders[5] = new SubBorder(style, defaultColor);
        return this;
    }

    public Border setBorder(BorderStyle style) {
        this.borders[0] = new SubBorder(style, defaultColor);
        this.borders[2] = this.borders[3] = this.borders[0];
        this.borders[1] = this.borders[3];
        return this;
    }

    public Border setDiagonal(BorderStyle style) {
        this.borders[4] = new SubBorder(style, defaultColor);
        this.borders[5] = this.borders[4];
        return this;
    }

    public Border setBorderTop(BorderStyle style, Color color) {
        this.borders[2] = new SubBorder(style, color);
        return this;
    }

    public Border setBorderRight(BorderStyle style, Color color) {
        this.borders[1] = new SubBorder(style, color);
        return this;
    }

    public Border setBorderBottom(BorderStyle style, Color color) {
        this.borders[3] = new SubBorder(style, color);
        return this;
    }

    public Border setBorderLeft(BorderStyle style, Color color) {
        this.borders[0] = new SubBorder(style, color);
        return this;
    }

    public Border setDiagonalDown(BorderStyle style, Color color) {
        this.borders[4] = new SubBorder(style, color);
        return this;
    }

    public Border setDiagonalUp(BorderStyle style, Color color) {
        this.borders[5] = new SubBorder(style, color);
        return this;
    }

    public Border setDiagonal(BorderStyle style, Color color) {
        this.borders[4] = new SubBorder(style, color);
        this.borders[5] = this.borders[4];
        return this;
    }

    public Border setBorder(BorderStyle style, Color color) {
        this.borders[0] = new SubBorder(style, color);
        this.borders[1] = this.borders[0];
        this.borders[2] = this.borders[0];
        this.borders[3] = this.borders[0];
        return this;
    }

    Border setBorder(int index, BorderStyle style) {
        this.borders[index] = new SubBorder(style, defaultColor);
        return this;
    }

    Border setBorder(int index, BorderStyle style, Color color) {
        this.borders[index] = new SubBorder(style, color);
        return this;
    }

    public SubBorder getBorderTop() {
        return this.borders[2];
    }

    public SubBorder getBorderRight() {
        return this.borders[1];
    }

    public SubBorder getBorderBottom() {
        return this.borders[3];
    }

    public SubBorder getBorderLeft() {
        return this.borders[0];
    }

    public SubBorder getDiagonalDown() {
        return this.borders[4];
    }

    public SubBorder getDiagonalUp() {
        return this.borders[5];
    }

    public SubBorder getBorder(int axis) {
        return axis >= 0 && axis < this.borders.length ? this.borders[axis] : null;
    }

    public SubBorder[] getBorders() {
        return this.borders;
    }

    Border delBorder(int index) {
        this.borders[index] = null;
        return this;
    }

    public int hashCode() {
        int down = this.borders[4] != null ? 1 : 0;
        int up = this.borders[5] != null ? 2 : 0;
        int hash = down | up;
        for (SubBorder sub : this.borders) {
            hash += sub != null ? sub.hashCode() : 0;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof Border) {
            Border other = (Border)o;
            for (int i = 0; i < this.borders.length; ++i) {
                if (!(other.borders[i] != null ? !other.borders[i].equals(this.borders[i]) : this.borders[i] != null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Border parse(String text) {
        Border border = new Border();
        if (StringUtil.isEmpty(text)) {
            return border;
        }
        String[] values = text.split(" ");
        int index = 0;
        Color color = null;
        for (int i = 0; i < values.length; ++i) {
            BorderStyle style = BorderStyle.getByName(values[i]);
            if (style == null) {
                throw new BorderParseException("Border style error.");
            }
            int n = i + 1;
            if (values.length <= n) break;
            String v = values[n];
            BorderStyle style1 = BorderStyle.getByName(v);
            if (style1 == null) {
                if (v.charAt(0) == '#') {
                    color = Color.decode(v);
                } else {
                    try {
                        Field field = Color.class.getDeclaredField(v);
                        color = (Color)field.get(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new ColorParseException("Color \"" + v + "\" not support.");
                    }
                }
                border.setBorder(index++, style, color);
                ++i;
                continue;
            }
            if (color != null) {
                border.setBorder(index++, style, color);
                continue;
            }
            border.setBorder(index++, style);
        }
        if (index == 1) {
            border.borders[1] = border.borders[0];
            border.borders[2] = border.borders[0];
            border.borders[3] = border.borders[0];
        }
        return border;
    }

    public Element toDom4j(Element root) {
        boolean up;
        Element element = root.addElement(StringUtil.lowFirstKey(this.getClass().getSimpleName()));
        for (int i = 0; i < direction.length; ++i) {
            Element sub = element.element(direction[i]);
            if (sub == null) {
                sub = element.addElement(direction[i]);
            }
            this.writeProperties(sub, this.borders[i]);
        }
        boolean down = this.borders[4] != null;
        boolean bl = up = this.borders[5] != null;
        if (down) {
            element.addAttribute("diagonalDown", "1");
        }
        if (up) {
            element.addAttribute("diagonalUp", "1");
        }
        return element;
    }

    public static List<Border> domToBorder(Element root) {
        Element ele = root.element("borders");
        if (ele == null) {
            return new ArrayList<Border>();
        }
        return ele.elements().stream().map(Border::parseBorderTag).collect(Collectors.toList());
    }

    static Border parseBorderTag(Element tag) {
        List sub = tag.elements();
        String diagonalDown = Styles.getAttr(tag, "diagonalDown");
        int padding = "1".equals(diagonalDown) || "true".equalsIgnoreCase(diagonalDown) ? 1 : 0;
        String diagonalUp = Styles.getAttr(tag, "diagonalUp");
        padding |= "1".equals(diagonalUp) || "true".equalsIgnoreCase(diagonalUp) ? 2 : 0;
        Border border = new Border();
        for (Element e : sub) {
            int i = StringUtil.indexOf(direction, e.getName());
            if (i < 0) continue;
            BorderStyle style = BorderStyle.getByName(Styles.getAttr(e, "style"));
            if (style == null) {
                style = BorderStyle.NONE;
            }
            Color color = Styles.parseColor(e.element("color"));
            if (i < 4) {
                border.setBorder(i, style, color);
                continue;
            }
            if ((padding & 1) == 1) {
                border.setBorder(4, style, color);
                continue;
            }
            if ((padding & 2) != 2) continue;
            border.setBorder(5, style, color);
        }
        return border;
    }

    protected void writeProperties(Element element, SubBorder subBorder) {
        if (subBorder != null && subBorder.style != BorderStyle.NONE) {
            int colorIndex;
            element.addAttribute("style", subBorder.style.getName());
            Element colorEle = element.element("color");
            if (colorEle == null) {
                colorEle = element.addElement("color");
            }
            if ((colorIndex = ColorIndex.indexOf(subBorder.color)) > -1) {
                colorEle.addAttribute("indexed", String.valueOf(colorIndex));
            } else {
                colorEle.addAttribute("rgb", ColorIndex.toARGB(subBorder.color));
            }
        }
    }

    public String toString() {
        return (Object)((Object)(this.borders[0] != null ? this.borders[0].style : BorderStyle.NONE)) + " " + (Object)((Object)(this.borders[1] != null ? this.borders[1].style : BorderStyle.NONE)) + " " + (Object)((Object)(this.borders[2] != null ? this.borders[2].style : BorderStyle.NONE)) + " " + (Object)((Object)(this.borders[3] != null ? this.borders[3].style : BorderStyle.NONE)) + " " + (Object)((Object)(this.borders[4] != null ? this.borders[4].style : BorderStyle.NONE)) + " " + (Object)((Object)(this.borders[5] != null ? this.borders[5].style : BorderStyle.NONE));
    }

    public static class SubBorder {
        public final BorderStyle style;
        public final Color color;

        public SubBorder(BorderStyle style, Color color) {
            this.style = style;
            this.color = color;
        }

        public BorderStyle getStyle() {
            return this.style;
        }

        public Color getColor() {
            return this.color;
        }

        public int hashCode() {
            int hash = this.color != null ? this.color.hashCode() : 0;
            return this.style.ordinal() << 24 | hash << 8 >>> 8;
        }

        public boolean equals(Object o) {
            return o instanceof SubBorder && o.hashCode() == this.hashCode();
        }
    }
}

