/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.MergeCalcFunc;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.XMLRow;
import org.ttzero.excel.util.StringUtil;

class XMLCalcRow
extends XMLRow {
    private MergeCalcFunc calcFun;
    private boolean hasCalcFunc;

    XMLCalcRow(SharedStrings sst, Styles styles, int startRow, MergeCalcFunc calcFun) {
        this.sst = sst;
        this.styles = styles;
        this.startRow = startRow;
        this.buf = new StringBuilder();
        this.calcFun = calcFun;
        this.hasCalcFunc = calcFun != null;
    }

    XMLCalcRow(XMLRow row) {
        this.sst = row.sst;
        this.styles = row.styles;
        this.startRow = row.startRow;
        this.buf = row.buf;
    }

    XMLCalcRow setCalcFun(MergeCalcFunc calcFun) {
        this.calcFun = calcFun;
        this.hasCalcFunc = calcFun != null;
        return this;
    }

    @Override
    protected void parseCells() {
        Cell cell;
        this.cursor = this.searchSpan();
        while (this.cb[this.cursor++] != '>') {
        }
        boolean bl = this.unknownLength = this.lc < 0;
        if (this.hasCalcFunc) {
            this.calcFun.accept(this.getRowNum(), this.cells, !this.unknownLength ? this.lc - this.fc : -1);
        }
        while ((cell = this.nextCell()) != null) {
            this.parseCellValue(cell);
        }
    }

    @Override
    protected void parseCellValue(Cell cell) {
        if (cell.f || !this.hasCalcFunc) {
            this.parseCalcFunc(cell);
        }
        super.parseCellValue(cell);
    }

    private void parseCalcFunc(Cell cell) {
        int _cursor = this.cursor;
        int a = this.getF(cell);
        boolean bl = cell.f = a < this.cursor;
        if (a == this.cursor) {
            this.cursor = _cursor;
            return;
        }
        if (a < this.cursor) {
            cell.fv = SharedStrings.unescape(this.buf, this.cb, a, this.cursor);
            if (cell.si > -1) {
                this.setCalc(cell.si, cell.fv);
            }
        } else if (cell.si > -1) {
            cell.fv = this.getCalc(cell.si, this.getRowNum() << 14 | cell.i);
        }
    }

    private int getF(Cell cell) {
        return this.get(cell, 'f', this::parseFunAttr);
    }

    private void parseFunAttr(Cell cell, char[] cb, int a, int b) {
        String[] values = new String[10];
        int index = 0;
        boolean sv = false;
        int i = a;
        while (true) {
            if (a < b && cb[a] > ' ' && cb[a] != '=') {
                ++a;
                continue;
            }
            values[index++] = new String(cb, i, sv ? a - i - 1 : a - i);
            sv = false;
            if (a + 1 >= b) break;
            if (cb[a + 1] == '\"') {
                a += 2;
                sv = true;
            } else if (cb[a + 1] == ' ') {
                values[index++] = "1";
            } else {
                ++a;
            }
            i = ++a;
        }
        if (index < 2 || (index & 1) == 1) {
            this.LOGGER.warn("The function format error.[{}]", (Object)new String(cb, a, b - a));
            return;
        }
        int len = index >> 1;
        for (i = 0; i < len; ++i) {
            int _i = i << 1;
            int vl = values[_i].length();
            if (vl - 1 == i) continue;
            int _n = vl - 1;
            if (_n > index - 1) {
                this.LOGGER.warn("Unknown attribute on function tag.[{}]", (Object)values[_i]);
                return;
            }
            StringUtil.swap(values, _n << 1, _i);
            StringUtil.swap(values, (_n << 1) + 1, _i + 1);
        }
        int si = Integer.parseInt(values[3]);
        if (index > 4) {
            this.addRef(si, values[5]);
        }
        cell.si = si;
    }
}

