/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.style.Border;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.NumFmt;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.processor.ConversionProcessor;
import org.ttzero.excel.processor.StyleProcessor;

public class Column {
    public String key;
    public String name;
    public Class<?> clazz;
    public boolean share;
    public ConversionProcessor processor;
    public StyleProcessor styleProcessor;
    public Integer cellStyle;
    public Integer headerStyle;
    protected int cellStyleIndex = -1;
    protected int headerStyleIndex = -1;
    public double width;
    public double headerHeight = -1.0;
    public double o;
    public Styles styles;
    public Comment headerComment;
    public Comment cellComment;
    public NumFmt numFmt;
    public boolean ignoreValue;
    public int wrapText;
    public int colIndex = -1;
    public Column prev;
    public Column next;
    public Column tail;
    public int realColIndex;
    public boolean hide;

    public Column() {
    }

    public Column(String name) {
        this.name = name;
    }

    public Column(String name, Class<?> clazz) {
        this(name, clazz, true);
    }

    public Column(String name, String key) {
        this(name, key, true);
    }

    public Column(String name, String key, Class<?> clazz) {
        this(name, key, true);
        this.clazz = clazz;
    }

    public Column(String name, Class<?> clazz, ConversionProcessor processor) {
        this(name, clazz, processor, true);
    }

    public Column(String name, String key, ConversionProcessor processor) {
        this(name, key, processor, true);
    }

    public Column(String name, Class<?> clazz, boolean share) {
        this.name = name;
        this.clazz = clazz;
        this.share = share;
    }

    public Column(String name, String key, boolean share) {
        this.name = name;
        this.key = key;
        this.share = share;
    }

    public Column(String name, Class<?> clazz, ConversionProcessor processor, boolean share) {
        this(name, clazz, share);
        this.processor = processor;
    }

    public Column(String name, String key, Class<?> clazz, ConversionProcessor processor) {
        this(name, key, clazz);
        this.processor = processor;
    }

    public Column(String name, String key, ConversionProcessor processor, boolean share) {
        this(name, key, share);
        this.processor = processor;
    }

    public Column(String name, Class<?> clazz, int cellStyle) {
        this(name, clazz, cellStyle, true);
    }

    public Column(String name, String key, int cellStyle) {
        this(name, key, cellStyle, true);
    }

    public Column(String name, Class<?> clazz, int cellStyle, boolean share) {
        this(name, clazz, share);
        this.cellStyle = cellStyle;
    }

    public Column(String name, String key, int cellStyle, boolean share) {
        this(name, key, share);
        this.cellStyle = cellStyle;
    }

    public Column(Column other) {
        this.from(other);
        if (other.next != null) {
            this.addSubColumn(new Column(other.next));
        }
    }

    public Column from(Column other) {
        int i;
        this.key = other.key;
        this.name = other.name;
        this.clazz = other.clazz;
        this.share = other.share;
        this.processor = other.processor;
        this.styleProcessor = other.styleProcessor;
        this.width = other.width;
        this.headerHeight = other.headerHeight;
        this.o = other.o;
        this.styles = other.styles;
        this.headerComment = other.headerComment;
        this.cellComment = other.cellComment;
        this.numFmt = other.numFmt;
        this.ignoreValue = other.ignoreValue;
        this.wrapText = other.wrapText;
        this.colIndex = other.colIndex;
        this.hide = other.hide;
        this.realColIndex = other.realColIndex;
        if (other.cellStyle != null) {
            this.setCellStyle(other.cellStyle);
        }
        if (other.headerStyle != null) {
            this.setHeaderStyle(other.headerStyle);
        }
        if ((i = other.getHeaderStyleIndex()) > 0) {
            this.headerStyleIndex = i;
        }
        if ((i = other.getCellStyleIndex()) > 0) {
            this.cellStyleIndex = i;
        }
        return this;
    }

    public Column setWidth(double width) {
        if (width < 0.0) {
            throw new ExcelWriteException("Width " + width + " less than 0.");
        }
        this.width = width;
        return this;
    }

    public Column setHeaderHeight(double headerHeight) {
        if (headerHeight < 0.0) {
            throw new ExcelWriteException("Height " + headerHeight + " less than 0.");
        }
        this.headerHeight = headerHeight;
        return this;
    }

    public boolean isShare() {
        return this.share;
    }

    public String getName() {
        return this.name;
    }

    public Column setName(String name) {
        this.name = name;
        return this;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Column setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public Column setProcessor(ConversionProcessor processor) {
        this.processor = processor;
        return this;
    }

    public Column setStyleProcessor(StyleProcessor styleProcessor) {
        this.styleProcessor = styleProcessor;
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public Column setCellStyle(int cellStyle) {
        this.cellStyle = cellStyle;
        if (this.styles != null) {
            this.cellStyleIndex = this.styles.of(cellStyle);
        }
        return this;
    }

    public Column setHeaderStyle(int headerStyle) {
        this.headerStyle = headerStyle;
        if (this.styles != null) {
            this.headerStyleIndex = this.styles.of(headerStyle);
        }
        return this;
    }

    public Column setColIndex(int colIndex) {
        this.colIndex = colIndex;
        return this;
    }

    public int getCellStyleIndex() {
        return this.cellStyleIndex >= 0 ? this.cellStyleIndex : (this.cellStyleIndex = this.styles != null && this.cellStyle != null ? this.styles.of(this.cellStyle) : -1);
    }

    public int getHeaderStyleIndex() {
        return this.headerStyleIndex >= 0 ? this.headerStyleIndex : (this.headerStyleIndex = this.styles != null && this.headerStyle != null ? this.styles.of(this.headerStyle) : -1);
    }

    int defaultHorizontal() {
        int horizontal = IWorksheetWriter.isDate(this.clazz) || IWorksheetWriter.isDateTime(this.clazz) || IWorksheetWriter.isLocalDate(this.clazz) || IWorksheetWriter.isLocalDateTime(this.clazz) || IWorksheetWriter.isTime(this.clazz) || IWorksheetWriter.isLocalTime(this.clazz) || IWorksheetWriter.isChar(this.clazz) || IWorksheetWriter.isBool(this.clazz) ? 6 : (IWorksheetWriter.isInt(this.clazz) || IWorksheetWriter.isLong(this.clazz) || IWorksheetWriter.isFloat(this.clazz) || IWorksheetWriter.isDouble(this.clazz) || IWorksheetWriter.isBigDecimal(this.clazz) ? 4 : 2);
        return horizontal;
    }

    public Column setCellStyle(Font font) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | 0 | this.defaultHorizontal());
        return this;
    }

    public Column setCellStyle(Font font, int horizontal) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | 0 | horizontal);
        return this;
    }

    public Column setCellStyle(Font font, Border border) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | this.defaultHorizontal());
        return this;
    }

    public Column setCellStyle(Font font, Border border, int horizontal) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | horizontal);
        return this;
    }

    public Column setCellStyle(Font font, Fill fill, Border border) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | this.defaultHorizontal());
        return this;
    }

    public Column setCellStyle(Font font, Fill fill, Border border, int horizontal) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | 0 | horizontal);
        return this;
    }

    public Column setCellStyle(Font font, Fill fill, Border border, int vertical, int horizontal) {
        this.cellStyle = this.styles.of((font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | vertical | horizontal);
        return this;
    }

    public Column setCellStyle(NumFmt numFmt, Font font, Fill fill, Border border, int vertical, int horizontal) {
        this.cellStyle = this.styles.of((numFmt != null ? this.styles.addNumFmt(numFmt) : 0) | (font != null ? this.styles.addFont(font) : 0) | (fill != null ? this.styles.addFill(fill) : 0) | (border != null ? this.styles.addBorder(border) : 0) | vertical | horizontal);
        return this;
    }

    public Column setShare(boolean share) {
        this.share = share;
        return this;
    }

    public Column setNumFmt(String code) {
        this.numFmt = new NumFmt(code);
        return this;
    }

    public Column setNumFmt(NumFmt numFmt) {
        this.numFmt = numFmt;
        return this;
    }

    public NumFmt getNumFmt() {
        return this.numFmt != null ? this.numFmt : (this.numFmt = this.styles.getNumFmt(this.cellStyle));
    }

    public int getCellStyle(Class<?> clazz) {
        int style;
        if (IWorksheetWriter.isString(clazz)) {
            style = Styles.defaultStringBorderStyle();
        } else if (IWorksheetWriter.isDateTime(clazz) || IWorksheetWriter.isDate(clazz) || IWorksheetWriter.isLocalDateTime(clazz)) {
            if (this.numFmt == null) {
                this.numFmt = NumFmt.DATETIME_FORMAT;
            }
            style = 70;
        } else if (IWorksheetWriter.isBool(clazz) || IWorksheetWriter.isChar(clazz)) {
            style = Styles.clearHorizontal(Styles.defaultStringBorderStyle()) | 6;
        } else if (IWorksheetWriter.isInt(clazz) || IWorksheetWriter.isLong(clazz)) {
            style = Styles.defaultIntBorderStyle();
        } else if (IWorksheetWriter.isFloat(clazz) || IWorksheetWriter.isDouble(clazz) || IWorksheetWriter.isBigDecimal(clazz)) {
            style = Styles.defaultDoubleBorderStyle();
        } else if (IWorksheetWriter.isLocalDate(clazz)) {
            if (this.numFmt == null) {
                this.numFmt = NumFmt.DATE_FORMAT;
            }
            style = 70;
        } else if (IWorksheetWriter.isTime(clazz) || IWorksheetWriter.isLocalTime(clazz)) {
            if (this.numFmt == null) {
                this.numFmt = NumFmt.TIME_FORMAT;
            }
            style = 70;
        } else {
            style = 262208;
        }
        if (this.numFmt != null) {
            style = Styles.clearNumFmt(style) | this.styles.addNumFmt(this.numFmt);
        }
        return style | this.wrapText;
    }

    public int getCellStyle() {
        if (this.cellStyle != null) {
            return this.cellStyle;
        }
        this.setCellStyle(this.getCellStyle(this.clazz));
        return this.cellStyle;
    }

    public boolean isIgnoreValue() {
        return this.ignoreValue;
    }

    public Column ignoreValue() {
        this.ignoreValue = true;
        return this;
    }

    public Column setWrapText(boolean wrapText) {
        this.wrapText = wrapText ? 1 : 0;
        return this;
    }

    public Column setHeaderComment(Comment headerComment) {
        this.headerComment = headerComment;
        return this;
    }

    public Column addSubColumn(Column column) {
        if (this == column) {
            return this;
        }
        if (this.next != null) {
            int appendSize;
            int subSize = this.subColumnSize();
            if (subSize + (appendSize = column.subColumnSize()) > 10) {
                throw new ExcelWriteException("Too many sub-column occur. Max support 10, current is " + subSize);
            }
            column.prev = this.tail;
            this.tail.next = column;
        } else {
            this.next = column;
            column.prev = this;
        }
        this.tail = column.tail != null ? column.tail : column;
        return this;
    }

    public int subColumnSize() {
        int i = 1;
        if (this.next != null) {
            Column next = this.next;
            while (next != this.tail) {
                next = next.next;
                ++i;
            }
            ++i;
        }
        return i;
    }

    public Column[] toArray() {
        return this.toArray(new Column[this.subColumnSize()]);
    }

    public Column[] toArray(Column[] dist) {
        int len = Math.min(this.subColumnSize(), dist.length);
        if (len < 1) {
            return dist;
        }
        Column e = this;
        for (int i = 0; i < len; ++i) {
            dist[i] = e;
            e = e.next;
        }
        return dist;
    }

    public int getRealColIndex() {
        return this.realColIndex;
    }

    public boolean isHide() {
        return this.hide;
    }

    public Column hide() {
        this.hide = true;
        return this;
    }

    public Column show() {
        this.hide = false;
        return this;
    }

    public Column getTail() {
        return this.tail != null ? this.tail : this;
    }
}

