/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.util.Iterator;
import org.ttzero.excel.entity.Row;

public class RowBlock
implements Iterator<Row> {
    private Row[] rows;
    private int i;
    private int n;
    private int total = 0;
    private boolean eof;
    private final int limit;

    public RowBlock() {
        this(32);
    }

    public RowBlock(int limit) {
        this.limit = limit;
        this.init();
    }

    private void init() {
        this.rows = new Row[this.limit];
        for (int i = 0; i < this.limit; ++i) {
            this.rows[i] = new Row();
        }
    }

    public final RowBlock reopen() {
        this.eof = false;
        return this;
    }

    public final RowBlock clear() {
        this.n = 0;
        this.i = 0;
        return this;
    }

    public int getTotal() {
        return this.total;
    }

    private void markEnd() {
        this.eof = true;
    }

    public boolean isEOF() {
        return this.eof;
    }

    final RowBlock flip() {
        if (this.i < this.limit) {
            this.markEnd();
        }
        this.n = this.i;
        this.total += this.i;
        this.i = 0;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.n;
    }

    @Override
    public Row next() {
        return this.rows[this.i++];
    }

    public Row firstRow() {
        return this.rows[0];
    }

    public Row lastRow() {
        return this.rows[this.n - 1];
    }

    public Row get(int position) {
        return this.rows[position];
    }

    public int size() {
        return this.n;
    }

    public void position(int position) {
        if (position < 0 || position >= this.n) {
            throw new ArrayIndexOutOfBoundsException("Index: " + position + ", Size: " + this.n);
        }
        this.i = position;
    }

    public int position() {
        return this.i;
    }
}

