/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.ttzero.excel.reader.Row;

public class RowSetIterator
implements Iterator<Row> {
    private final boolean onlyDataRow;
    private final Supplier<Row> supplier;
    private Row nextRow = null;

    public RowSetIterator(Supplier<Row> supplier, boolean onlyDataRow) {
        this.supplier = supplier;
        this.onlyDataRow = onlyDataRow;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRow != null) {
            return true;
        }
        if (this.onlyDataRow) {
            while ((this.nextRow = this.supplier.get()) != null && this.nextRow.isBlank()) {
            }
        } else {
            this.nextRow = this.supplier.get();
        }
        return this.nextRow != null;
    }

    @Override
    public Row next() {
        if (this.nextRow != null || this.hasNext()) {
            Row next = this.nextRow;
            this.nextRow = null;
            return next;
        }
        throw new NoSuchElementException();
    }
}

