/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

interface Tester {
    public boolean test(int var1);

    public int limit();

    public int size();

    public int analysis();

    public static class FixBinaryTester
    implements Tester {
        private int start;
        private int limit;
        private final int initial_size;
        private long[] marks;
        private int total_resize;

        FixBinaryTester(int expectedInsertions) {
            this.initial_size = (expectedInsertions - 1 >> 6) + 1;
            this.marks = new long[this.initial_size];
            this.limit = (this.initial_size << 6) - 1;
        }

        @Override
        public boolean test(int i) {
            int m;
            int n;
            if (i < this.start) {
                return true;
            }
            if (i > this.limit) {
                this.resize(i);
            }
            boolean a = (this.marks[n = (i -= this.start) >> 6] >> 63 - (m = i - (n << 6)) & 1L) == 1L;
            int n2 = n;
            this.marks[n2] = this.marks[n2] | 1L << 63 - m;
            return a;
        }

        @Override
        public int limit() {
            return this.limit;
        }

        @Override
        public int size() {
            return this.marks.length;
        }

        @Override
        public int analysis() {
            return this.total_resize;
        }

        private void resize(int i) {
            int ii;
            ++this.total_resize;
            int n = this.marks.length;
            int l = (i - this.start >> 6) + 1;
            for (ii = 0; ii < n && this.marks[ii] == -1L; ++ii) {
            }
            if (l - ii <= this.initial_size) {
                if (ii > 0) {
                    int j = 0;
                    int m = ii;
                    while (m < n) {
                        this.marks[j++] = this.marks[m++];
                    }
                    while (j < n) {
                        int n2 = j++;
                        this.marks[n2] = this.marks[n2] & 0L;
                    }
                    this.start += ii << 6;
                }
            } else {
                long[] newMarks = new long[l - ii + (l - ii >> 1)];
                System.arraycopy(this.marks, ii, newMarks, 0, this.marks.length - ii);
                this.marks = newMarks;
                this.start += ii << 6;
            }
            this.limit = (this.marks.length << 6) + this.start - 1;
        }
    }
}

