/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Drawings;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.HeaderRow;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.RowSetIterator;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.reader.XMLCalcSheet;
import org.ttzero.excel.reader.XMLMergeSheet;
import org.ttzero.excel.reader.XMLRow;

public class XMLSheet
implements Sheet {
    final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected String name;
    protected int index;
    protected Path path;
    protected int id;
    protected SharedStrings sst;
    protected Styles styles;
    protected int startRow = -1;
    protected HeaderRow header;
    protected boolean hidden;
    protected Dimension dimension;
    protected Drawings drawings;
    protected int hrf;
    protected int hrl;
    protected BufferedReader reader;
    protected char[] cb;
    protected int nChar;
    protected int length;
    protected boolean eof = false;
    protected boolean heof = false;
    protected long mark;
    protected XMLRow sRow;
    protected long lastRowMark;

    public XMLSheet() {
    }

    public XMLSheet(XMLSheet sheet) {
        this.name = sheet.name;
        this.index = sheet.index;
        this.path = sheet.path;
        this.sst = sheet.sst;
        this.styles = sheet.styles;
        this.id = sheet.id;
        this.startRow = sheet.startRow;
        this.header = sheet.header;
        this.hidden = sheet.hidden;
        this.dimension = sheet.dimension;
        this.drawings = sheet.drawings;
        this.reader = sheet.reader;
        this.cb = sheet.cb;
        this.nChar = sheet.nChar;
        this.length = sheet.length;
        this.eof = sheet.eof;
        this.heof = sheet.heof;
        this.mark = sheet.mark;
        this.sRow = sheet.sRow;
        this.lastRowMark = sheet.lastRowMark;
        this.hrf = sheet.hrf;
        this.hrl = sheet.hrl;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setPath(Path path) {
        this.path = path;
    }

    protected void setSst(SharedStrings sst) {
        this.sst = sst;
    }

    protected void setStyles(Styles styles) {
        this.styles = styles;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getId() {
        return this.id;
    }

    protected void setId(int id) {
        this.id = id;
    }

    protected void setDrawings(Drawings drawings) {
        this.drawings = drawings;
    }

    @Override
    @Deprecated
    public int getSize() {
        return this.dimension != null ? this.dimension.lastRow - this.dimension.firstRow + 1 : -1;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    public int getFirstRow() {
        return this.startRow;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public Sheet header(int fromRowNum, int toRowNum) {
        XMLSheet.rangeCheck(fromRowNum, toRowNum);
        this.hrf = fromRowNum;
        this.hrl = toRowNum;
        return this;
    }

    XMLSheet setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public Row getHeader() {
        if (this.header == null && !this.heof) {
            Row row;
            Row row2 = row = this.hrf == 0 ? this.findRow0(this::createHeader) : this.getHeader(this.hrf, this.hrl);
            if (row != null) {
                this.header = row instanceof HeaderRow ? (HeaderRow)row : row.asHeader();
                this.sRow.setHr(this.header);
            }
        } else if (this.hrl > 0 && this.hrl > this.sRow.index) {
            XMLRow row = this.nextRow();
            while (row != null && ((Row)row).getRowNum() < this.hrl) {
                row = this.nextRow();
            }
        }
        return this.header;
    }

    protected Row getHeader(int fromRowNum, int toRowNum) {
        if (this.header != null) {
            return this.header;
        }
        XMLSheet.rangeCheck(fromRowNum, toRowNum);
        if (this.sRow.index > -1 && fromRowNum < this.sRow.index) {
            throw new IndexOutOfBoundsException("Current row num " + this.sRow.index + " is great than fromRowNum " + fromRowNum + ". Use Sheet#reset() to reset cursor.");
        }
        if (toRowNum - fromRowNum > 0) {
            Row[] rows = new Row[toRowNum - fromRowNum + 1];
            int i = 0;
            int lc = -1;
            boolean changeLc = false;
            Object row = this.nextRow();
            while (row != null) {
                if (((Row)row).getRowNum() >= fromRowNum) {
                    if (((Row)row).lc > lc) {
                        lc = ((Row)row).lc;
                        if (i > 0) {
                            changeLc = true;
                        }
                    }
                    Row r = new Row(){};
                    r.fc = ((Row)row).fc;
                    r.lc = ((Row)row).lc;
                    r.index = ((Row)row).index;
                    r.sst = ((Row)row).sst;
                    r.cells = ((Row)row).copyCells();
                    rows[i++] = r;
                }
                if (((Row)row).getRowNum() >= toRowNum) break;
                row = this.nextRow();
            }
            if (changeLc) {
                for (Row row2 : rows) {
                    row2.lc = lc;
                    row2.cells = row2.copyCells(lc);
                }
            }
            XMLMergeSheet tmp = new XMLSheet(this).asMergeSheet();
            tmp.reader = null;
            List<Dimension> mergeCells = tmp.parseMerge();
            if (mergeCells != null) {
                mergeCells = mergeCells.stream().filter(dim -> dim.firstRow < toRowNum || dim.lastRow > fromRowNum).collect(Collectors.toList());
            }
            return new HeaderRow().with(mergeCells, rows);
        }
        XMLRow row = this.nextRow();
        while (row != null && ((Row)row).getRowNum() < fromRowNum) {
            row = this.nextRow();
        }
        return new HeaderRow().with(row);
    }

    static void rangeCheck(int fromRowNum, int toRowNum) {
        if (fromRowNum <= 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromRowNum);
        }
        if (fromRowNum > toRowNum) {
            throw new IllegalArgumentException("fromIndex(" + fromRowNum + ") > toIndex(" + toRowNum + ")");
        }
    }

    @Override
    public XMLSheet bind(Class<?> clazz) {
        if (this.getHeader() != null) {
            try {
                this.header.setClassOnce(clazz);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelReadException(e);
            }
        }
        return this;
    }

    @Override
    public Sheet bind(Class<?> clazz, Row row) {
        if (row == null) {
            throw new IllegalArgumentException("Specify the bind row must not be null.");
        }
        if (!row.equals(this.header)) {
            this.header = row instanceof HeaderRow ? (HeaderRow)row : row.asHeader();
            this.sRow.setHr(this.header);
        }
        try {
            this.header.setClassOnce(clazz);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ExcelReadException(e);
        }
        return this;
    }

    public String toString() {
        return "Sheet id: " + this.getId() + ", name: " + this.getName() + ", dimension: " + this.getDimension();
    }

    @Override
    public XMLSheet load() throws IOException {
        if (this.sRow != null) {
            this.reset();
            return this;
        }
        this.LOGGER.debug("Load {}", (Object)this.path.toString());
        this.reader = Files.newBufferedReader(this.path);
        this.cb = new char[8192];
        this.nChar = 0;
        int left = 0;
        block0: while (true) {
            this.length = this.reader.read(this.cb, left, this.cb.length - left);
            if (this.length < 11) break;
            if (this.nChar == 0 && this.startRow < 1) {
                int end;
                String line = new String(this.cb, 56, 1024);
                String size = "<dimension ref=\"";
                int index = line.indexOf(size);
                int n = end = index > 0 ? line.indexOf(34, index += size.length()) : -1;
                if (end > 0) {
                    String l_ = line.substring(index, end);
                    Pattern pat = Pattern.compile("([A-Z]+)(\\d+):([A-Z]+)(\\d+)");
                    Matcher mat = pat.matcher(l_);
                    if (mat.matches()) {
                        this.dimension = Dimension.of(l_);
                        this.startRow = this.dimension.firstRow;
                    } else {
                        pat = Pattern.compile("([A-Z]+)(\\d+)");
                        mat = pat.matcher(l_);
                        if (mat.matches()) {
                            this.startRow = Integer.parseInt(mat.group(2));
                        }
                    }
                    this.nChar += end;
                }
            }
            while (this.nChar < this.length - 12) {
                if (this.cb[this.nChar] == '<' && this.cb[this.nChar + 1] == 's' && this.cb[this.nChar + 2] == 'h' && this.cb[this.nChar + 3] == 'e' && this.cb[this.nChar + 4] == 'e' && this.cb[this.nChar + 5] == 't' && this.cb[this.nChar + 6] == 'D' && this.cb[this.nChar + 7] == 'a' && this.cb[this.nChar + 8] == 't' && this.cb[this.nChar + 9] == 'a' && (this.cb[this.nChar + 10] == '>' || this.cb[this.nChar + 10] == '/' && this.cb[this.nChar + 11] == '>')) {
                    this.nChar += 11;
                    break block0;
                }
                ++this.nChar;
            }
            left = this.nChar;
            while (left > 0 && this.cb[left--] != '>') {
            }
            if (left <= 0) continue;
            System.arraycopy(this.cb, left, this.cb, 0, this.length - left);
            this.mark += (long)this.nChar;
            this.nChar = 0;
        }
        if (this.cb[this.nChar] == '>') {
            this.mark += (long)this.length;
            this.eof = true;
        } else {
            this.eof = false;
            this.mark += (long)this.nChar;
            this.sRow = this.createRow().init(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1);
        }
        if (!this.eof && this.dimension == null) {
            this.parseDimension();
        }
        if (this.dimension == null) {
            this.dimension = new Dimension(1, 1);
        }
        this.LOGGER.debug("Dimension-Range: {}", (Object)this.dimension);
        return this;
    }

    private XMLRow nextRow() {
        if (this.eof) {
            return null;
        }
        boolean endTag = false;
        int start = this.nChar;
        while (++this.nChar < this.length && this.cb[this.nChar] != '>') {
        }
        if (this.cb[this.nChar++ - 1] == '/') {
            return this.sRow.empty(this.cb, start, this.nChar - start);
        }
        while (this.nChar < this.length - 6) {
            if (this.cb[this.nChar] == '<' && this.cb[this.nChar + 1] == '/' && this.cb[this.nChar + 2] == 'r' && this.cb[this.nChar + 3] == 'o' && this.cb[this.nChar + 4] == 'w' && this.cb[this.nChar + 5] == '>') {
                this.nChar += 6;
                endTag = true;
                break;
            }
            ++this.nChar;
        }
        if (!endTag) {
            int n;
            if (start == 0) {
                char[] _cb = new char[this.cb.length << 1];
                n = this.length - start;
                System.arraycopy(this.cb, start, _cb, 0, n);
                this.cb = _cb;
            } else {
                n = this.length - start;
                System.arraycopy(this.cb, start, this.cb, 0, n);
            }
            try {
                this.length = this.reader.read(this.cb, n, this.cb.length - n);
                if (this.length < 0) {
                    this.eof = true;
                    this.reader.close();
                    this.reader = null;
                    this.LOGGER.debug("end of file.");
                    return null;
                }
            }
            catch (IOException e) {
                throw new ExcelReadException("Parse row data error", e);
            }
            this.nChar = 0;
            this.length += n;
            return this.nextRow();
        }
        return this.sRow.with(this.cb, start, this.nChar - start);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Row findRow0(HeaderRowFunc func) {
        char[] cb = new char[8192];
        int nChar = 0;
        try (BufferedReader reader = Files.newBufferedReader(this.path);){
            boolean eof;
            int length;
            if (this.mark > 0L) {
                reader.skip(this.mark);
                length = reader.read(cb);
            } else {
                block19: while (true) {
                    length = reader.read(cb);
                    while (true) {
                        if (nChar >= length - 12) continue block19;
                        if (cb[nChar] == '<' && cb[nChar + 1] == 's' && cb[nChar + 2] == 'h' && cb[nChar + 3] == 'e' && cb[nChar + 4] == 'e' && cb[nChar + 5] == 't' && cb[nChar + 6] == 'D' && cb[nChar + 7] == 'a' && cb[nChar + 8] == 't' && cb[nChar + 9] == 'a' && (cb[nChar + 10] == '>' || cb[nChar + 10] == '/' && cb[nChar + 11] == '>')) {
                            nChar += 11;
                            break block19;
                        }
                        ++nChar;
                    }
                    break;
                }
            }
            boolean bl = eof = length <= 0 || cb[nChar] == '>';
            if (eof) {
                this.heof = true;
                Row row = null;
                return row;
            }
            int start = nChar;
            while (true) {
                if (nChar < length - 6) {
                    if (cb[nChar] == '<' && cb[nChar + 1] == '/' && cb[nChar + 2] == 'r' && cb[nChar + 3] == 'o' && cb[nChar + 4] == 'w' && cb[nChar + 5] == '>') {
                        Row row = func.accept(cb, start, (nChar += 6) - start);
                        return row;
                    }
                    ++nChar;
                    continue;
                }
                char[] _cb = new char[cb.length << 1];
                int n = length - start;
                System.arraycopy(cb, start, _cb, 0, n);
                cb = _cb;
                try {
                    length = reader.read(cb, n, cb.length - n);
                    if (length < 0) {
                        reader.close();
                        Row row = null;
                        return row;
                    }
                }
                catch (IOException e) {
                    throw new ExcelReadException("Parse row data error", e);
                }
                start = 0;
                length += n;
            }
        }
        catch (IOException e) {
            this.LOGGER.error("Read header row error.");
            return null;
        }
    }

    @Override
    public Iterator<Row> iterator() {
        if (this.hrf > 0) {
            this.getHeader();
        }
        return new RowSetIterator(this::nextRow, false);
    }

    @Override
    public Iterator<Row> dataIterator() {
        if (this.hrf > 0) {
            this.getHeader();
        }
        RowSetIterator nIter = new RowSetIterator(this::nextRow, true);
        if (this.hrf == 0 && nIter.hasNext()) {
            Row row = (Row)nIter.next();
            if (this.header == null) {
                this.header = row.asHeader();
            }
            row.setHr(this.header);
        }
        return nIter;
    }

    @Override
    public List<Drawings.Picture> listPictures() {
        return this.drawings != null ? this.drawings.listPictures(this) : null;
    }

    @Override
    public void close() throws IOException {
        this.cb = null;
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public XMLSheet reset() {
        this.LOGGER.debug("Reset {}", (Object)this.path.toString());
        try {
            this.hrf = 0;
            this.hrl = 0;
            this.header = null;
            this.sRow.fc = 0;
            this.sRow.lc = -1;
            this.sRow.index = -1;
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.cb == null) {
                return this.load();
            }
            this.reader = Files.newBufferedReader(this.path);
            this.reader.skip(this.mark);
            this.length = this.reader.read(this.cb);
            this.nChar = 0;
            this.eof = this.length <= 0;
        }
        catch (IOException e) {
            throw new ExcelReadException("Reset worksheet[" + this.getName() + "] error occur.", e);
        }
        return this;
    }

    @Override
    public XMLRow createRow() {
        return new XMLRow();
    }

    void parseDimension() {
        try (SeekableByteChannel channel = Files.newByteChannel(this.path, StandardOpenOption.READ);){
            long position = Files.size(this.path);
            int block = (int)Math.min(2048L, position);
            int c = 7;
            ByteBuffer buffer = ByteBuffer.allocate(block);
            byte[] left = null;
            int left_size = 0;
            boolean getit = false;
            while (true) {
                int i;
                channel.position(Math.max(0L, position -= (long)(block - left_size)));
                channel.read(buffer);
                if (left_size > 0) {
                    buffer.limit(block);
                    buffer.put(left, 0, left_size);
                }
                buffer.flip();
                boolean eof = buffer.limit() < block;
                int limit = buffer.limit();
                for (i = limit - 1; i >= 7 && (buffer.get(i) != 34 || buffer.get(i - 1) != 61 || buffer.get(i - 2) != 114 || buffer.get(i - 3) > 32 || buffer.get(i - 4) != 119 || buffer.get(i - 5) != 111 || buffer.get(i - 6) != 114 || buffer.get(i - 7) != 60); --i) {
                }
                if (i < 7) {
                    if (eof || (eof = position <= 0L)) break;
                    while (i < limit && buffer.get(i) != 62) {
                        ++i;
                    }
                    if (++i < limit - 1) {
                        buffer.position(i);
                        left_size = i;
                        if (left == null || left_size > left.length) {
                            left = new byte[left_size];
                        }
                        buffer.position(0);
                        buffer.get(left, 0, left_size);
                    } else {
                        left_size = 0;
                    }
                } else {
                    getit = true;
                    buffer.position(i);
                    if (left_size > 0) {
                        channel.position(channel.position() + (long)left_size);
                    }
                    this.lastRowMark = channel.position() - (long)buffer.remaining();
                    break;
                }
                buffer.position(0);
                buffer.limit(buffer.capacity() - left_size);
            }
            if (!getit) {
                this.dimension = Dimension.of("A1");
                return;
            }
            this.parseDim(channel, buffer);
        }
        catch (IOException e) {
            this.LOGGER.debug("", (Throwable)e);
        }
    }

    private int[] innerParse(ByteBuffer buffer, int i) {
        int row = 0;
        while (buffer.get(i) != 34) {
            row = row * 10 + (buffer.get(i) - 48);
            ++i;
        }
        ++i;
        while (buffer.limit() - i >= 7 && (buffer.get(i) != 115 || buffer.get(i + 1) != 112 || buffer.get(i + 2) != 97 || buffer.get(i + 3) != 110 || buffer.get(i + 4) != 115 || buffer.get(i + 5) != 61 || buffer.get(i + 6) != 34)) {
            ++i;
        }
        int cs = 0;
        int ls = 0;
        if (buffer.limit() <= (i += 7)) {
            this.eof = true;
            return new int[]{row, 1, 1};
        }
        while (buffer.get(i) != 58) {
            cs = cs * 10 + (buffer.get(i) - 48);
            ++i;
        }
        ++i;
        while (buffer.get(i) != 34) {
            ls = ls * 10 + (buffer.get(i) - 48);
            ++i;
        }
        return new int[]{row, cs, ls};
    }

    private void parseDim(SeekableByteChannel channel, ByteBuffer buffer) throws IOException {
        long rr = 0L;
        int i = buffer.position();
        int[] info = this.innerParse(buffer, ++i);
        int rc = info[2] << 16 | info[1] & Short.MAX_VALUE;
        rr |= (long)info[0] << 32;
        if (this.mark > 0L) {
            channel.position(this.mark);
            buffer.clear();
            channel.read(buffer);
            buffer.flip();
            i = 0;
            while (buffer.get(i) != 60 || buffer.get(i + 1) != 114 || buffer.get(i + 2) != 111 || buffer.get(i + 3) != 119 || buffer.get(i + 4) > 32 || buffer.get(i + 5) != 114 || buffer.get(i + 6) != 61 || buffer.get(i + 7) != 34) {
                ++i;
            }
            info = this.innerParse(buffer, i += 8);
            rr |= (long)info[0];
            if (info[1] > (rc & Short.MAX_VALUE)) {
                rc |= info[1] & Short.MAX_VALUE;
            }
            if (info[2] < rc >>> 16) {
                rc |= info[2] << 16;
            }
        } else {
            rr |= 1L;
        }
        this.dimension = new Dimension((int)rr, (short)rc, (int)(rr >>> 32), (short)(rc >>> 16));
    }

    Row createHeader(char[] cb, int start, int n) {
        return this.createRow().init(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1).with(cb, start, n);
    }

    @Override
    public XMLSheet asSheet() {
        return this instanceof XMLCalcSheet || this instanceof XMLMergeSheet ? new XMLSheet(this) : this;
    }

    @Override
    public XMLCalcSheet asCalcSheet() {
        return !(this instanceof XMLCalcSheet) ? new XMLCalcSheet(this) : (XMLCalcSheet)this;
    }

    @Override
    public XMLMergeSheet asMergeSheet() {
        return !(this instanceof XMLMergeSheet) ? new XMLMergeSheet(this) : (XMLMergeSheet)this;
    }

    static void watch(ByteBuffer buffer) {
        int p = buffer.position();
        byte[] bytes = new byte[Math.min(128, buffer.remaining())];
        buffer.get(bytes, 0, bytes.length);
        System.out.println(new String(bytes, 0, bytes.length, StandardCharsets.US_ASCII));
        buffer.position(p);
    }

    static interface HeaderRowFunc {
        public Row accept(char[] var1, int var2, int var3);
    }
}

