/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.processor.StyleProcessor;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.DateUtil;

public interface ICellValueAndStyle {
    default public void reset(Row row, Cell cell, Object e, Column hc) {
        this.setCellValue(row.index, cell, e, hc, hc.getClazz(), hc.processor != null);
        if (hc.processor == null) {
            cell.xf = this.getStyleIndex(row, hc, e);
        }
    }

    default public int getStyleIndex(Row row, Column hc, Object o) {
        int style = hc.getCellStyle();
        if (hc.styleProcessor != null) {
            style = hc.styleProcessor.build(o, style, hc.styles);
        }
        return hc.styles.of(style);
    }

    @Deprecated
    public void reset(int var1, Cell var2, Object var3, Column var4);

    public String getFileSuffix();

    @Deprecated
    public int getStyleIndex(int var1, Column var2, Object var3);

    default public <T> void setStyleDesign(T o, Cell cell, Column hc, StyleProcessor<T> styleProcessor) {
        if (styleProcessor != null && hc.styles != null) {
            cell.xf = hc.styles.of(styleProcessor.build(o, hc.styles.getStyleByIndex(cell.xf), hc.styles));
        }
    }

    default public void setCellValue(int row, Cell cell, Object e, Column hc, Class<?> clazz, boolean hasProcessor) {
        if (hasProcessor) {
            this.conversion(row, cell, e, hc);
            return;
        }
        if (e == null) {
            this.setNullValue(row, cell, hc);
            return;
        }
        if (clazz == null) {
            clazz = e.getClass();
            hc.setClazz(clazz);
        }
        if (IWorksheetWriter.isString(clazz)) {
            cell.setSv(e.toString());
        } else if (IWorksheetWriter.isDate(clazz)) {
            cell.setIv(DateUtil.toDateTimeValue((Date)e));
        } else if (IWorksheetWriter.isDateTime(clazz)) {
            cell.setIv(DateUtil.toDateTimeValue((Timestamp)e));
        } else if (IWorksheetWriter.isChar(clazz)) {
            cell.setCv(((Character)e).charValue());
        } else if (IWorksheetWriter.isShort(clazz)) {
            cell.setNv(((Short)e).shortValue());
        } else if (IWorksheetWriter.isInt(clazz)) {
            cell.setNv((Integer)e);
        } else if (IWorksheetWriter.isLong(clazz)) {
            cell.setLv((Long)e);
        } else if (IWorksheetWriter.isFloat(clazz)) {
            cell.setDv(((Float)e).floatValue());
        } else if (IWorksheetWriter.isDouble(clazz)) {
            cell.setDv((Double)e);
        } else if (IWorksheetWriter.isBool(clazz)) {
            cell.setBv((Boolean)e);
        } else if (IWorksheetWriter.isBigDecimal(clazz)) {
            cell.setMv((BigDecimal)e);
        } else if (IWorksheetWriter.isLocalDate(clazz)) {
            cell.setIv(DateUtil.toDateValue((LocalDate)e));
        } else if (IWorksheetWriter.isLocalDateTime(clazz)) {
            cell.setIv(DateUtil.toDateTimeValue((LocalDateTime)e));
        } else if (IWorksheetWriter.isTime(clazz)) {
            cell.setTv(DateUtil.toTimeValue((Time)e));
        } else if (IWorksheetWriter.isLocalTime(clazz)) {
            cell.setTv(DateUtil.toTimeValue((LocalTime)e));
        } else {
            this.unknownType(row, cell, e, hc, clazz);
        }
    }

    default public void setNullValue(int row, Cell cell, Column hc) {
        boolean hasProcessor;
        boolean bl = hasProcessor = hc.processor != null;
        if (hasProcessor) {
            this.conversion(row, cell, 0, hc);
        } else {
            cell.blank();
        }
    }

    default public void conversion(int row, Cell cell, Object o, Column hc) {
        Object e = hc.processor.conversion(o);
        if (e != null) {
            Class<?> clazz = e.getClass();
            if (IWorksheetWriter.isInt(clazz)) {
                if (IWorksheetWriter.isChar(clazz)) {
                    cell.setCv(((Character)e).charValue());
                } else if (IWorksheetWriter.isShort(clazz)) {
                    cell.setNv(((Short)e).shortValue());
                } else {
                    cell.setNv((Integer)e);
                }
            } else {
                this.setCellValue(row, cell, e, hc, clazz, false);
            }
        } else {
            cell.blank();
        }
    }

    default public void unknownType(int row, Cell cell, Object e, Column hc, Class<?> clazz) {
        cell.setSv(e.toString());
    }
}

