/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ttzero.excel.annotation.ExcelColumn;
import org.ttzero.excel.annotation.ExcelColumns;
import org.ttzero.excel.annotation.FreezePanes;
import org.ttzero.excel.annotation.HeaderComment;
import org.ttzero.excel.annotation.HeaderStyle;
import org.ttzero.excel.annotation.IgnoreExport;
import org.ttzero.excel.annotation.StyleDesign;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.Panes;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.processor.ConversionProcessor;
import org.ttzero.excel.processor.StyleProcessor;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.ReflectUtil;
import org.ttzero.excel.util.StringUtil;

public class ListSheet<T>
extends Sheet {
    protected List<T> data;
    protected int start;
    protected int end;
    protected boolean eof;
    private int size;
    protected StyleProcessor<T> styleProcessor;

    public Sheet setStyleProcessor(StyleProcessor<T> styleProcessor) {
        this.styleProcessor = styleProcessor;
        this.putExtProp("style_design", styleProcessor);
        return this;
    }

    public StyleProcessor<T> getStyleProcessor() {
        StyleProcessor fromExtProp;
        if (this.styleProcessor != null) {
            return this.styleProcessor;
        }
        this.styleProcessor = fromExtProp = (StyleProcessor)this.getExtPropValue("style_design");
        return this.styleProcessor;
    }

    public ListSheet() {
    }

    public ListSheet(String name) {
        super(name);
    }

    public ListSheet(Column ... columns) {
        super(columns);
    }

    public ListSheet(String name, Column ... columns) {
        super(name, columns);
    }

    public ListSheet(String name, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
    }

    public ListSheet(List<T> data) {
        this(null, data);
    }

    public ListSheet(String name, List<T> data) {
        super(name);
        this.setData(data);
    }

    public ListSheet(List<T> data, Column ... columns) {
        this(null, data, columns);
    }

    public ListSheet(String name, List<T> data, Column ... columns) {
        this(name, data, (WaterMark)null, columns);
    }

    public ListSheet(List<T> data, WaterMark waterMark, Column ... columns) {
        this(null, data, waterMark, columns);
    }

    public ListSheet(String name, List<T> data, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
        this.setData(data);
    }

    public ListSheet<T> setData(List<T> data) {
        this.data = data;
        if (!this.headerReady && this.workbook != null) {
            this.getAndSortHeaderColumns();
        }
        if (data != null && this.sheetWriter != null) {
            this.paging();
        }
        return this;
    }

    protected T getFirst() {
        if (this.data == null || this.data.isEmpty()) {
            return null;
        }
        T first = this.data.get(this.start);
        if (first != null) {
            return first;
        }
        int i = this.start + 1;
        while ((first = this.data.get(i++)) == null) {
        }
        return first;
    }

    @Override
    public void close() throws IOException {
        List<T> list;
        if (!this.eof && this.rows >= this.getRowLimit() && (list = this.more()) != null && !list.isEmpty()) {
            this.compact();
            this.data.addAll(list);
            ListSheet copy = (ListSheet)this.getClass().cast(this.clone());
            copy.start = 0;
            copy.end = list.size();
            this.workbook.insertSheet(this.id, copy);
            this.shouldClose = false;
        }
        if (this.shouldClose && this.data != null) {
            this.data = null;
        }
        super.close();
    }

    @Override
    protected void resetBlockData() {
        if (!this.eof && this.left() < this.getRowBlockSize()) {
            this.append();
        }
        int end = this.getEndIndex();
        int len = this.columns.length;
        boolean hasGlobalStyleProcessor = (this.extPropMark & 2) == 2;
        try {
            while (this.start < end) {
                Row row = this.rowBlock.next();
                row.index = this.rows;
                Cell[] cells = row.realloc(len);
                T o = this.data.get(this.start);
                boolean isNull = o == null;
                for (int i = 0; i < len; ++i) {
                    Cell cell = cells[i];
                    cell.clear();
                    EntryColumn column = (EntryColumn)this.columns[i];
                    Object e = column.isIgnoreValue() || isNull ? null : (column.getMethod() != null ? column.getMethod().invoke(o, new Object[0]) : (column.getField() != null ? column.getField().get(o) : (Object)o));
                    this.cellValueAndStyle.reset(row, cell, e, (Column)column);
                    if (!hasGlobalStyleProcessor) continue;
                    this.cellValueAndStyle.setStyleDesign(o, cell, column, this.getStyleProcessor());
                }
                row.height = this.getRowHeight();
                ++this.rows;
                ++this.start;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ExcelWriteException(e);
        }
    }

    protected void append() {
        block4: {
            int rbs = this.getRowBlockSize();
            while (true) {
                List<T> list;
                if ((list = this.more()) == null || list.isEmpty()) {
                    this.shouldClose = true;
                    this.eof = true;
                    break block4;
                }
                if (this.data == null) {
                    this.setData(list);
                    if (list.size() < rbs) {
                        continue;
                    }
                    break block4;
                }
                this.compact();
                this.data.addAll(list);
                this.start = 0;
                this.end = this.data.size();
                if (this.end >= rbs) break;
            }
            this.paging();
        }
    }

    private void compact() {
        int size = this.left();
        if (this.start > 0 && size > 0) {
            ArrayList<T> last = new ArrayList<T>(size);
            last.addAll(this.data.subList(this.start, this.end));
            this.data.clear();
            this.data.addAll(last);
        } else if (this.start > 0) {
            this.data.clear();
        }
    }

    protected Class<?> getTClass() {
        Type type;
        Class clazz = null;
        if (this.getClass().getGenericSuperclass() instanceof ParameterizedType && (type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]) instanceof Class) {
            clazz = (Class)type;
        }
        if (clazz == null) {
            T o = this.getFirst();
            if (o == null) {
                return null;
            }
            clazz = o.getClass();
        }
        return clazz;
    }

    protected int init() {
        boolean forceExport;
        Class<?> clazz = this.getTClass();
        if (clazz == null) {
            return 0;
        }
        HashMap<String, Method> tmp = new HashMap<String, Method>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor pd : propertyDescriptors = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()) {
                Method method = pd.getReadMethod();
                if (method == null) continue;
                tmp.put(pd.getName(), method);
            }
        }
        catch (IntrospectionException e) {
            this.LOGGER.warn("Get class {} methods failed.", clazz);
        }
        Field[] declaredFields = ReflectUtil.listDeclaredFields(clazz, c -> !this.ignoreColumn((AccessibleObject)c));
        boolean bl = forceExport = this.forceExport == 1;
        if (!this.hasHeaderColumns()) {
            ArrayList<Column> list = new ArrayList<Column>(declaredFields.length);
            for (int i = 0; i < declaredFields.length; ++i) {
                EntryColumn tail;
                EntryColumn column;
                Field field = declaredFields[i];
                field.setAccessible(true);
                String gs = field.getName();
                Method method = (Method)tmp.get(gs);
                if (method != null) {
                    if (this.ignoreColumn(method)) {
                        declaredFields[i] = null;
                        continue;
                    }
                    column = this.createColumn(method);
                    if (column == null && forceExport) {
                        column = new EntryColumn(gs, "", false);
                    }
                    if (column != null) {
                        tail = (EntryColumn)column.getTail();
                        tail.method = method;
                        tail.field = field;
                        tail.clazz = method.getReturnType();
                        tail.key = gs;
                        if (StringUtil.isEmpty(tail.name)) {
                            tail.name = gs;
                        }
                        list.add(column);
                        this.buildHeaderStyle(method, field, tail);
                        this.buildHeaderComment(method, field, tail);
                        continue;
                    }
                }
                if ((column = this.createColumn(field)) == null && forceExport) {
                    column = new EntryColumn(gs, "", false);
                }
                if (column == null) continue;
                list.add(column);
                tail = (EntryColumn)column.getTail();
                tail.field = field;
                tail.key = gs;
                if (StringUtil.isEmpty(tail.name)) {
                    tail.name = gs;
                }
                if (method != null) {
                    tail.clazz = method.getReturnType();
                    tail.method = method;
                } else {
                    tail.clazz = field.getType();
                }
                this.buildHeaderStyle(method, field, tail);
                this.buildHeaderComment(method, field, tail);
            }
            List<Column> attachList = this.attachOtherColumn(tmp, clazz);
            if (attachList != null) {
                list.addAll(attachList);
            }
            if (list.isEmpty()) {
                this.shouldClose = true;
                this.eof = true;
                this.headerReady = true;
                this.end = 0;
                if (Map.class.isAssignableFrom(clazz)) {
                    this.LOGGER.warn("List<Map> has detected, please use ListMapSheet for export.");
                } else {
                    this.LOGGER.warn("Class [{}] do not contains properties to export.", clazz);
                }
                return 0;
            }
            this.columns = new Column[list.size()];
            list.toArray(this.columns);
        } else {
            Method[] others = this.filterOthersMethodsCanExport(tmp, clazz);
            HashMap<String, Object> otherMap = new HashMap<String, Object>();
            for (Method m : others) {
                ExcelColumn ec = m.getAnnotation(ExcelColumn.class);
                if (ec != null && StringUtil.isNotEmpty(ec.value())) {
                    otherMap.put(ec.value(), m);
                }
                otherMap.put(m.getName(), m);
            }
            for (int i = 0; i < this.columns.length; ++i) {
                Column hc;
                this.columns[i] = hc = new EntryColumn(this.columns[i]);
                if (hc.tail != null) {
                    hc = hc.tail;
                }
                EntryColumn ec = hc;
                if (ec.method == null) {
                    Method method = (Method)tmp.get(hc.key);
                    if (method != null) {
                        method.setAccessible(true);
                        ec.method = method;
                    } else {
                        method = (Method)otherMap.get(hc.key);
                        if (method != null) {
                            method.setAccessible(true);
                            ec.method = method;
                        }
                    }
                }
                if (ec.field == null) {
                    for (Field field : declaredFields) {
                        if (!field.getName().equals(hc.key)) continue;
                        field.setAccessible(true);
                        ec.field = field;
                        break;
                    }
                }
                if (ec.method == null && ec.field == null) {
                    if (this.columns.length > 1) {
                        this.LOGGER.warn("Column [" + hc.getName() + "(" + hc.key + ")] not declare in class " + clazz);
                        hc.ignoreValue();
                    } else {
                        this.LOGGER.warn("Column one does not specify method and filed");
                    }
                } else if (hc.getClazz() == null) {
                    hc.setClazz(ec.method != null ? ec.method.getReturnType() : ec.field.getType());
                }
                if (hc.getHeaderStyleIndex() == -1) {
                    this.buildHeaderStyle(ec.method, ec.field, hc);
                }
                if (hc.headerComment != null) continue;
                this.buildHeaderComment(ec.method, ec.field, hc);
            }
        }
        this.mergeGlobalSetting(clazz);
        return this.columns.length;
    }

    protected EntryColumn createColumn(AccessibleObject ao) {
        if (this.ignoreColumn(ao)) {
            return null;
        }
        ao.setAccessible(true);
        StyleProcessor<?> sp = this.getDesignStyle(ao.getAnnotation(StyleDesign.class));
        ExcelColumns cs = ao.getAnnotation(ExcelColumns.class);
        if (cs != null) {
            ExcelColumn[] ecs = cs.value();
            EntryColumn root = null;
            for (ExcelColumn ec : ecs) {
                EntryColumn column = this.createColumnByAnnotation(ec);
                if (sp != null) {
                    column.styleProcessor = sp;
                }
                if (root == null) {
                    root = column;
                    continue;
                }
                root.addSubColumn(column);
            }
            return root;
        }
        ExcelColumn ec = ao.getAnnotation(ExcelColumn.class);
        if (ec != null) {
            EntryColumn column = this.createColumnByAnnotation(ec);
            if (sp != null) {
                column.styleProcessor = sp;
            }
            return column;
        }
        return null;
    }

    protected EntryColumn createColumnByAnnotation(ExcelColumn ec) {
        if (ec == null) {
            return null;
        }
        EntryColumn column = new EntryColumn(ec.value(), "", ec.share());
        if (StringUtil.isNotEmpty(ec.format())) {
            column.setNumFmt(ec.format());
        }
        column.setWrapText(ec.wrapText());
        if (ec.colIndex() > -1) {
            column.colIndex = ec.colIndex();
        }
        if (ec.hide()) {
            column.hide();
        }
        if (ec.maxWidth() >= 0.0) {
            column.width = ec.maxWidth();
        }
        return column;
    }

    protected void buildHeaderStyle(AccessibleObject main, AccessibleObject sub, Column column) {
        HeaderStyle hs = null;
        if (main != null) {
            hs = main.getAnnotation(HeaderStyle.class);
        }
        if (hs == null && sub != null) {
            hs = sub.getAnnotation(HeaderStyle.class);
        }
        if (hs != null) {
            column.setHeaderStyle(this.buildHeadStyle(hs.fontColor(), hs.fillFgColor()));
        }
    }

    protected void buildHeaderComment(AccessibleObject main, AccessibleObject sub, Column column) {
        ExcelColumn ec;
        HeaderComment comment = null;
        if (main != null && (comment = main.getAnnotation(HeaderComment.class)) == null && (ec = main.getAnnotation(ExcelColumn.class)) != null) {
            comment = ec.comment();
        }
        if (comment == null && sub != null && (comment = sub.getAnnotation(HeaderComment.class)) == null && (ec = sub.getAnnotation(ExcelColumn.class)) != null) {
            comment = ec.comment();
        }
        if (comment != null && (StringUtil.isNotEmpty(comment.value()) || StringUtil.isNotEmpty(comment.title()))) {
            column.headerComment = new Comment(comment.title(), comment.value(), comment.width(), comment.height());
        }
    }

    protected void mergeGlobalSetting(Class<?> clazz) {
        StyleProcessor<?> styleProcessor;
        HeaderStyle headerStyle = clazz.getDeclaredAnnotation(HeaderStyle.class);
        int style = 0;
        if (headerStyle != null) {
            style = this.buildHeadStyle(headerStyle.fontColor(), headerStyle.fillFgColor());
        }
        for (Column column : this.columns) {
            if (style <= 0 || column.getHeaderStyleIndex() != -1) continue;
            column.setHeaderStyle(style);
        }
        if (this.styleProcessor == null && (styleProcessor = this.getDesignStyle(clazz.getDeclaredAnnotation(StyleDesign.class))) != null) {
            this.setStyleProcessor(styleProcessor);
        }
        this.attachFreezePanes(clazz);
    }

    protected StyleProcessor<?> getDesignStyle(StyleDesign styleDesign) {
        if (styleDesign != null && !StyleProcessor.None.class.isAssignableFrom(styleDesign.using())) {
            try {
                return styleDesign.using().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.LOGGER.warn("Construct {} error occur, it will be ignore.", styleDesign.using(), (Object)e);
            }
        }
        return null;
    }

    protected boolean ignoreColumn(AccessibleObject ao) {
        return ao.getAnnotation(IgnoreExport.class) != null;
    }

    protected List<Column> attachOtherColumn(Map<String, Method> existsMethodMapper, Class<?> clazz) {
        Method[] readMethods = this.filterOthersMethodsCanExport(existsMethodMapper, clazz);
        if (readMethods != null) {
            HashSet<Method> existsMethods = new HashSet<Method>(existsMethodMapper.values());
            ArrayList<Column> list = new ArrayList<Column>();
            for (Method method : readMethods) {
                EntryColumn column;
                if (existsMethods.contains(method) || (column = this.createColumn(method)) == null) continue;
                list.add(column);
                EntryColumn tail = (EntryColumn)column.getTail();
                tail.method = method;
                tail.clazz = method.getReturnType();
                tail.key = method.getName();
                if (StringUtil.isEmpty(tail.name)) {
                    tail.name = method.getName();
                }
                this.buildHeaderStyle(method, null, tail);
                this.buildHeaderComment(method, null, tail);
            }
            return list;
        }
        return null;
    }

    @Override
    protected Column[] getHeaderColumns() {
        int size;
        if (!this.headerReady && (size = this.init()) <= 0) {
            this.columns = new Column[0];
        }
        return this.columns;
    }

    protected int getEndIndex() {
        int rowLimit;
        int blockSize = this.getRowBlockSize();
        if (this.rows + blockSize > (rowLimit = this.getRowLimit())) {
            blockSize = rowLimit - this.rows;
        }
        int end = this.start + blockSize;
        return Math.min(end, this.end);
    }

    @Override
    public int size() {
        return !this.shouldClose ? this.size : -1;
    }

    protected int left() {
        return this.end - this.start;
    }

    @Override
    protected void paging() {
        int limit;
        int len = this.dataSize();
        if (len + this.rows > (limit = this.getRowLimit())) {
            this.end = limit - this.rows + this.start;
            this.shouldClose = false;
            this.eof = true;
            this.size = limit;
            int n = this.id;
            int i = this.end;
            while (i < len) {
                ListSheet copy = (ListSheet)this.getClass().cast(this.clone());
                copy.start = i;
                copy.end = i = Math.min(i + limit, len);
                copy.size = copy.end - copy.start;
                copy.eof = copy.size == limit;
                this.workbook.insertSheet(n++, copy);
            }
            this.workbook.getSheetAt((int)(n - 1)).shouldClose = true;
        } else {
            this.end = len;
            this.size += len;
        }
    }

    public int dataSize() {
        return this.data != null ? this.data.size() : 0;
    }

    protected List<T> more() {
        return null;
    }

    protected void attachFreezePanes(Class<?> clazz) {
        if (this.getExtPropValue("freeze") != null) {
            return;
        }
        FreezePanes panes = clazz.getAnnotation(FreezePanes.class);
        if (panes == null) {
            return;
        }
        if (panes.topRow() < 0 || panes.firstColumn() < 0) {
            throw new IllegalArgumentException("negative number occur.");
        }
        if ((panes.topRow() | panes.firstColumn()) == 0) {
            return;
        }
        this.putExtProp("freeze", Panes.of(panes.topRow(), panes.firstColumn()));
    }

    protected Method[] filterOthersMethodsCanExport(Map<String, Method> existsMethodMapper, Class<?> clazz) {
        Method[] readMethods = null;
        try {
            Collection<Method> values = existsMethodMapper.values();
            readMethods = ReflectUtil.listReadMethods(clazz, method -> method.getAnnotation(ExcelColumn.class) != null && method.getAnnotation(IgnoreExport.class) == null && !values.contains(method));
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return readMethods;
    }

    public static class EntryColumn
    extends Column {
        public Method method;
        public Field field;

        public EntryColumn() {
        }

        public EntryColumn(String name) {
            this.name = name;
        }

        public EntryColumn(String name, Class<?> clazz) {
            super(name, clazz);
        }

        public EntryColumn(String name, String key) {
            super(name, key);
        }

        public EntryColumn(String name, String key, Class<?> clazz) {
            super(name, key, clazz);
        }

        public EntryColumn(String name, Class<?> clazz, ConversionProcessor processor) {
            super(name, clazz, processor);
        }

        public EntryColumn(String name, String key, ConversionProcessor processor) {
            super(name, key, processor);
        }

        public EntryColumn(String name, Class<?> clazz, boolean share) {
            super(name, clazz, share);
        }

        public EntryColumn(String name, String key, boolean share) {
            super(name, key, share);
        }

        public EntryColumn(String name, Class<?> clazz, ConversionProcessor processor, boolean share) {
            super(name, clazz, processor, share);
        }

        public EntryColumn(String name, String key, Class<?> clazz, ConversionProcessor processor) {
            super(name, key, clazz, processor);
        }

        public EntryColumn(String name, String key, ConversionProcessor processor, boolean share) {
            super(name, key, processor, share);
        }

        public EntryColumn(String name, Class<?> clazz, int cellStyle) {
            super(name, clazz, cellStyle);
        }

        public EntryColumn(String name, String key, int cellStyle) {
            super(name, key, cellStyle);
        }

        public EntryColumn(String name, Class<?> clazz, int cellStyle, boolean share) {
            super(name, clazz, cellStyle, share);
        }

        public EntryColumn(String name, String key, int cellStyle, boolean share) {
            super(name, key, cellStyle, share);
        }

        public EntryColumn(Column other) {
            super.from(other);
            if (other instanceof EntryColumn) {
                EntryColumn o = (EntryColumn)other;
                this.method = o.method;
                this.field = o.field;
            }
            if (other.next != null) {
                this.addSubColumn(new EntryColumn(other.next));
            }
        }

        public Method getMethod() {
            return this.method;
        }

        public Field getField() {
            return this.field;
        }
    }
}

