/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.e7;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={""}, value="Types", uri={"http://schemas.openxmlformats.org/package/2006/content-types"})
public class ContentType
implements Storable {
    private final Set<? super Type> set = new HashSet<Type>();
    private final RelManager relManager = new RelManager();

    public void addRel(Relationship rel) {
        this.relManager.add(rel);
    }

    public void add(Type type) {
        this.set.add(type);
    }

    public boolean hasDrawings() {
        return this.set.stream().anyMatch(t -> "application/vnd.openxmlformats-officedocument.drawing+xml".equals(((Type)t).contentType));
    }

    @java.lang.Override
    public void writeTo(Path root) throws IOException {
        this.relManager.write(root, null);
        TopNS topNS = this.getClass().getAnnotation(TopNS.class);
        DocumentFactory factory = DocumentFactory.getInstance();
        Element rootElement = factory.createElement(topNS.value(), topNS.uri()[0]);
        for (Type type : this.set) {
            Class<?> clazz = type.getClass();
            Element ele = rootElement.addElement(clazz.getSimpleName());
            Field[] fields = clazz.getDeclaredFields();
            Field[] sfilds = clazz.getSuperclass().getDeclaredFields();
            Field[] newFields = Arrays.copyOf(fields, fields.length + sfilds.length);
            for (int j = fields.length; j < newFields.length; ++j) {
                newFields[j] = sfilds[j - fields.length];
            }
            for (Field field : newFields) {
                field.setAccessible(true);
                Class<?> _clazz = field.getType();
                if (_clazz == this.getClass()) continue;
                try {
                    Object oo = field.get(type);
                    if (oo == null) continue;
                    ele.addAttribute(StringUtil.uppFirstKey(field.getName()), oo.toString());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        Document doc = factory.createDocument(rootElement);
        FileUtil.writeToDiskNoFormat(doc, root.resolve("[Content_Types].xml"));
    }

    public static class Override
    extends Type {
        String partName;

        public Override(String contentType, String partName) {
            this.partName = partName;
            this.contentType = contentType;
        }

        public String getPartName() {
            return this.partName;
        }

        public void setPartName(String partName) {
            this.partName = partName;
        }

        public int hashCode() {
            return this.partName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Override)) {
                return false;
            }
            return this == o || this.partName.equals(((Override)o).partName);
        }

        @java.lang.Override
        public String getKey() {
            return this.partName;
        }
    }

    public static class Default
    extends Type {
        String extension;

        public Default(String contentType, String extension) {
            this.extension = extension;
            this.contentType = contentType;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public int hashCode() {
            return this.extension.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            return this == o || this.extension.equals(((Default)o).extension);
        }

        @java.lang.Override
        public String getKey() {
            return this.extension;
        }
    }

    public static abstract class Type {
        protected String contentType;

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public abstract String getKey();
    }
}

