/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.awt.Color;
import org.ttzero.excel.entity.style.Styles;

public class ColorIndex {
    public static final int[] colors = new int[]{-16777216, -1, -65536, -16711936, -16776961, -256, -65281, -16711681, -16777216, -1, -65536, -16711936, -16776961, -256, -65281, -16711681, -8388608, -16744448, -16777088, -8355840, -8388480, -16744320, -4144960, -8355712, -6710785, -6737050, -52, -3342337, -10092442, -32640, -16750900, -3355393, -16777088, -65281, -256, -16711681, -8388480, -8388608, -16744320, -16776961, -16724737, -3342337, -3342388, -103, -6697729, -26164, -3368449, -13159, -13408513, -13382452, -6697984, -13312, -26368, -39424, -10066279, -6908266, -16764058, -13395610, -16764160, -13421824, -6737152, -6737050, -13421671, -13421773};
    public static final Color[] themeColors = new Color[]{new Color(255, 255, 255), new Color(0, 0, 0), new Color(238, 236, 225), new Color(31, 73, 125), new Color(79, 129, 189), new Color(192, 80, 77), new Color(155, 187, 89), new Color(128, 100, 162), new Color(75, 172, 198), new Color(247, 150, 70), new Color(0, 0, 255), new Color(128, 0, 128)};

    @Deprecated
    public static int get(int index) {
        if (index < 0 || index >= colors.length) {
            return 8;
        }
        return colors[index];
    }

    @Deprecated
    public static Color getColor(int index) {
        return new Color(index < 0 || index >= colors.length ? colors[8] : colors[index]);
    }

    public static int indexOf(Color color) {
        return ColorIndex.indexOf(color.getRGB());
    }

    public static int indexOf(int rgb) {
        int i;
        if (rgb >= 0) {
            return -1;
        }
        for (i = 8; i < colors.length && colors[i] != rgb; ++i) {
        }
        return i < colors.length ? i : -1;
    }

    public static String toARGB(Color color) {
        return ColorIndex.toARGB(color.getRGB());
    }

    public static String toARGB(int rgb) {
        int i;
        char[] chars = new char[8];
        for (i = 0; i < 4; ++i) {
            int n = rgb >> 8 * (3 - i) & 0xFF;
            if (n <= 15) {
                chars[i << 1] = 48;
                chars[(i << 1) + 1] = (char)(n < 10 ? 48 + n : 97 + n - 10);
                continue;
            }
            Integer.toHexString(n).getChars(0, 2, chars, i << 1);
        }
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] < 'a' || chars[i] > 'z') continue;
            int n = i;
            chars[n] = (char)(chars[n] - 32);
        }
        return new String(chars);
    }

    public static Color toColor(String rgb) {
        if (rgb.length() == 8 && rgb.startsWith("FF")) {
            rgb = "#" + rgb.substring(2);
        } else if (rgb.length() == 6 && rgb.charAt(0) != '#') {
            rgb = "#" + rgb;
        }
        return Styles.toColor(rgb);
    }
}

