/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.dom4j.Element;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.util.StringUtil;

public class NumFmt
implements Comparable<NumFmt> {
    public static final NumFmt DATETIME_FORMAT = new NumFmt("yyyy\\-mm\\-dd\\ hh:mm:ss");
    public static final NumFmt DATE_FORMAT = new NumFmt("yyyy\\-mm\\-dd");
    public static final NumFmt TIME_FORMAT = new NumFmt("hh:mm:ss");
    protected String code;
    protected int id = -1;

    public NumFmt() {
    }

    NumFmt(int id, String code) {
        this.id = id;
        this.code = code;
    }

    public NumFmt(String code) {
        this.code = NumFmt.clean(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    NumFmt setId(int id) {
        this.id = id;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public static NumFmt valueOf(int id) {
        return new NumFmt().setId(id);
    }

    public static NumFmt of(String code) {
        return new NumFmt(code);
    }

    private static String clean(String code) {
        if (StringUtil.isEmpty(code)) {
            throw new NumberFormatException("The format code must not be null or empty.");
        }
        code = NumFmt.escape(code, '-');
        code = NumFmt.escape(code, ' ');
        return code;
    }

    private static String escape(String code, char c) {
        int i = code.indexOf(c);
        if (i > -1) {
            int j = 0;
            StringBuilder buf = new StringBuilder();
            do {
                if (i != j) {
                    buf.append(code, j, i);
                    j = i;
                }
                if (i != 0 && code.charAt(i - 1) == '\\') continue;
                buf.append('\\');
            } while ((i = code.indexOf(c, i + 1)) > -1);
            code = buf.append(code, j, code.length()).toString();
        }
        return code;
    }

    public double calcNumWidth(double base) {
        if (StringUtil.isBlank(this.code)) {
            return 0.0;
        }
        String[] codes = this.code.split(";");
        double max = 0.0;
        for (String code : codes) {
            double len;
            double n = base < 0.0 ? 1.0 : 0.0;
            boolean ignore = false;
            boolean comma = false;
            for (int i = 0; i < code.length(); ++i) {
                char c = code.charAt(i);
                if (c == '\"' || c == '\\') continue;
                if (ignore) {
                    if (c != ']' && c != ')') continue;
                    ignore = false;
                    continue;
                }
                if (c == '[' || c == '(') {
                    ignore = true;
                    continue;
                }
                if (c == ',') {
                    comma = true;
                }
                n += c > '\u4e00' ? 1.86 : 1.0;
            }
            boolean isDate = Styles.testCodeIsDate(code);
            int k = 0;
            if (!isDate) {
                k = code.lastIndexOf(46);
                if (k < 0) {
                    char c;
                    for (k = code.length(); k > 0 && ((c = code.charAt(k - 1)) == '_' || c == ' ' || c == '.'); --k) {
                    }
                }
                int n2 = k = k >= 0 ? code.length() - k : 0;
            }
            double d = isDate ? n : (len = (comma ? base + base / 3.0 : base) + (double)k);
            if (!(max < len)) continue;
            max = len;
        }
        return max + 0.86;
    }

    public int hashCode() {
        return this.code != null ? this.code.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o instanceof NumFmt) {
            NumFmt other = (NumFmt)o;
            return Objects.equals(other.code, this.code);
        }
        return false;
    }

    public String toString() {
        return "id: " + this.id + ", code: " + this.code;
    }

    public Element toDom4j(Element root) {
        if (StringUtil.isEmpty(this.code)) {
            return root;
        }
        return root.addElement(StringUtil.lowFirstKey(this.getClass().getSimpleName())).addAttribute("formatCode", this.code).addAttribute("numFmtId", String.valueOf(this.id));
    }

    public static List<NumFmt> domToNumFmt(Element root) {
        Element ele = root.element("numFmts");
        if (ele == null) {
            return new ArrayList<NumFmt>();
        }
        List sub = ele.elements();
        ArrayList<NumFmt> numFmts = new ArrayList<NumFmt>(sub.size());
        for (Element e : sub) {
            String id = Styles.getAttr(e, "numFmtId");
            String code = Styles.getAttr(e, "formatCode");
            numFmts.add(new NumFmt(Integer.parseInt(id), code));
        }
        numFmts.sort(Comparator.comparingInt(NumFmt::getId));
        return numFmts;
    }

    @Override
    public int compareTo(NumFmt o) {
        return this.id - o.id;
    }
}

