/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.ttzero.excel.annotation.ExcelColumn;
import org.ttzero.excel.annotation.ExcelColumns;
import org.ttzero.excel.annotation.IgnoreImport;
import org.ttzero.excel.annotation.RowNum;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.manager.Const;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.CellType;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.GridFactory;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.UncheckedTypeException;
import org.ttzero.excel.util.ReflectUtil;
import org.ttzero.excel.util.StringUtil;

public class HeaderRow
extends Row {
    protected String[] names;
    protected Class<?> clazz;
    protected Object t;
    protected Map<String, Integer> mapping;
    protected ListSheet.EntryColumn[] columns;
    protected static final Field detailMessageField;
    protected int headRows;

    public HeaderRow with(Row ... rows) {
        return this.with(null, rows.length, rows);
    }

    public HeaderRow with(int headRows, Row ... rows) {
        return this.with(null, headRows, rows);
    }

    public HeaderRow with(List<Dimension> mergeCells, Row ... rows) {
        return this.with(mergeCells, rows.length, rows);
    }

    public HeaderRow with(List<Dimension> mergeCells, int headRows, Row ... rows) {
        int i;
        this.headRows = headRows;
        Row row = rows[rows.length - 1];
        this.names = new String[row.lc];
        this.mapping = new HashMap<String, Integer>();
        this.fc = row.fc;
        this.lc = row.lc;
        this.index = row.index;
        this.cells = new Cell[this.names.length];
        for (i = 0; i < row.fc; ++i) {
            this.cells[i] = new Cell();
        }
        if (headRows == 1) {
            for (i = row.fc; i < row.lc; ++i) {
                this.names[i] = row.getString(i);
                this.mapping.put(this.names[i], i);
                Cell cell = new Cell();
                cell.setSv(this.names[i]);
                this.cells[i] = cell;
            }
        } else {
            this.mergeCellsIfNull(mergeCells, rows);
            StringBuilder buf = new StringBuilder();
            for (int i2 = row.fc; i2 < row.lc; ++i2) {
                buf.delete(0, buf.length());
                for (Row r : rows) {
                    String tmp = r.getString(i2);
                    if (!StringUtil.isNotEmpty(tmp)) continue;
                    buf.append(tmp).append(':');
                }
                if (buf.length() > 1) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                this.names[i2] = buf.toString();
                this.mapping.put(this.names[i2], i2);
                Cell cell = new Cell();
                cell.setSv(this.names[i2]);
                this.cells[i2] = cell;
            }
        }
        return this;
    }

    public final boolean is(Class<?> clazz) {
        return this.clazz != null && this.clazz == clazz;
    }

    protected HeaderRow setClass(Class<?> clazz) {
        ListSheet.EntryColumn column;
        Method method;
        this.clazz = clazz;
        Field[] declaredFields = ReflectUtil.listDeclaredFields(clazz, c -> !this.ignoreColumn((AccessibleObject)c));
        HashMap<String, Method> tmp = new HashMap<String, Method>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor pd : propertyDescriptors = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()) {
                method = pd.getWriteMethod();
                if (method == null) continue;
                tmp.put(pd.getName(), method);
            }
        }
        catch (IntrospectionException e2) {
            this.LOGGER.warn("Get class {} methods failed.", clazz);
        }
        final ArrayList<ListSheet.EntryColumn> list = new ArrayList<ListSheet.EntryColumn>();
        for (int i = 0; i < declaredFields.length; ++i) {
            ListSheet.EntryColumn tail;
            Field f = declaredFields[i];
            f.setAccessible(true);
            String gs = f.getName();
            method = (Method)tmp.get(gs);
            if (method != null && (column = this.createColumn(method)) != null) {
                tail = column.tail != null ? (ListSheet.EntryColumn)column.tail : column;
                tail.method = method;
                if (StringUtil.isEmpty(tail.name)) {
                    tail.name = method.getName();
                }
                if (tail.clazz == null) {
                    tail.clazz = method.getParameterTypes()[0];
                }
                if (tail.colIndex < 0) {
                    tail.colIndex = this.check(tail.name, gs);
                }
                list.add(column);
                continue;
            }
            column = this.createColumn(f);
            if (column == null) continue;
            ListSheet.EntryColumn entryColumn = tail = column.tail != null ? (ListSheet.EntryColumn)column.tail : column;
            if (StringUtil.isEmpty(tail.name)) {
                tail.name = gs;
            }
            if (method != null) {
                tail.method = method;
                if (tail.clazz == null) {
                    tail.clazz = method.getParameterTypes()[0];
                }
            } else {
                tail.field = f;
                if (tail.clazz == null) {
                    tail.clazz = declaredFields[i].getType();
                }
            }
            if (tail.colIndex < 0) {
                tail.colIndex = this.check(tail.name, gs);
            }
            list.add(column);
        }
        Map<String, Method> otherColumns = this.attachOtherColumn(clazz);
        if (!otherColumns.isEmpty()) {
            for (Map.Entry<String, Method> entry : otherColumns.entrySet()) {
                ListSheet.EntryColumn tail;
                column = this.createColumn(entry.getValue());
                if (column == null) {
                    column = new ListSheet.EntryColumn(entry.getKey());
                }
                ListSheet.EntryColumn entryColumn = tail = column.tail != null ? (ListSheet.EntryColumn)column.tail : column;
                if (StringUtil.isEmpty(tail.name)) {
                    tail.name = entry.getKey();
                }
                tail.method = entry.getValue();
                if (tail.clazz == null) {
                    tail.clazz = entry.getValue().getParameterTypes()[0];
                }
                if (tail.colIndex < 0) {
                    tail.colIndex = this.getIndex(tail.name);
                }
                list.add(column);
            }
        }
        ListSheet<Object> listSheet = new ListSheet<Object>(){

            @Override
            public Column[] getAndSortHeaderColumns() {
                this.columns = new Column[list.size()];
                list.toArray(this.columns);
                this.headerReady = true;
                this.sortColumns(this.columns);
                this.calculateRealColIndex();
                this.reverseHeadColumn();
                this.mergeHeaderCellsIfEquals();
                return this.columns;
            }
        };
        Column[] columns = listSheet.getAndSortHeaderColumns();
        List mergeCells = (List)listSheet.getExtPropValue("merge_cells");
        List list2 = mergeCells = mergeCells != null && !mergeCells.isEmpty() ? mergeCells.stream().filter(c -> c.firstColumn < c.lastColumn).collect(Collectors.toList()) : null;
        if (mergeCells != null && !mergeCells.isEmpty()) {
            Grid mergedGrid = GridFactory.create(mergeCells);
            for (Column c2 : columns) {
                Column[] sub = c2.toArray();
                for (int j = sub.length - 1; j >= 0; --j) {
                    int t = sub.length - j;
                    if (!mergedGrid.test(t, c2.realColIndex) || !HeaderRow.isTopRow(mergeCells, t, c2.realColIndex)) continue;
                    Cell cell = new Cell((short)c2.realColIndex);
                    if (StringUtil.isNotEmpty(sub[j].getName())) {
                        cell.setSv(sub[j].getName());
                    } else {
                        cell.t = (char)101;
                    }
                    mergedGrid.merge(t, cell);
                    sub[j].name = cell.sv;
                }
            }
        }
        int len = columns.length;
        for (int i = 0; i < len; ++i) {
            Column c3 = columns[i];
            if (c3.tail != null) {
                StringJoiner joiner = new StringJoiner(":");
                Column[] sub = c3.toArray();
                for (int j = sub.length - 1; j >= 0; --j) {
                    if (!StringUtil.isNotEmpty(sub[j].getName())) continue;
                    joiner.add(sub[j].getName());
                }
                c3.name = joiner.toString();
            } else if (!(c3 instanceof ListSheet.EntryColumn)) {
                columns[i] = c3 = new ListSheet.EntryColumn(c3);
            }
            if (c3.colIndex >= 0) continue;
            c3.colIndex = this.getIndex(c3.name);
            c3.realColIndex = c3.colIndex + 1;
        }
        this.columns = (ListSheet.EntryColumn[])Arrays.stream(columns).filter(c -> c.colIndex >= 0 || c.clazz == RowNum.class).sorted(Comparator.comparingInt(a -> a.colIndex)).map(e -> e instanceof ListSheet.EntryColumn ? (ListSheet.EntryColumn)e : new ListSheet.EntryColumn((Column)e)).toArray(ListSheet.EntryColumn[]::new);
        return this;
    }

    static boolean isTopRow(List<Dimension> mergeCells, int row, int col) {
        for (Dimension dim : mergeCells) {
            if (!dim.checkRange(row, col) || row != dim.firstRow) continue;
            return true;
        }
        return false;
    }

    protected int check(String first, String second) {
        int n = this.getIndex(first);
        if (n == -1) {
            n = this.getIndex(second);
        }
        if (n == -1) {
            this.LOGGER.warn("{} field [{}] can't find in header {}", new Object[]{this.clazz, first, Arrays.toString(this.names)});
        }
        return n;
    }

    protected HeaderRow setClassOnce(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        this.setClass(clazz);
        this.t = clazz.newInstance();
        return this;
    }

    protected ListSheet.EntryColumn[] getColumns() {
        return this.columns;
    }

    public <T> T getT() {
        return (T)this.t;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public CellType getCellType(int columnIndex) {
        return CellType.STRING;
    }

    public String get(int columnIndex) {
        this.rangeCheck(columnIndex);
        return this.names[columnIndex];
    }

    public String[] getNames() {
        return this.names;
    }

    public int getIndex(String columnName) {
        Integer index = this.mapping != null ? this.mapping.get(columnName) : null;
        return index != null ? index : -1;
    }

    @Override
    public String toString() {
        int i;
        StringJoiner joiner = new StringJoiner(" | ");
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < this.names.length && this.names[i] == null; ++i) {
        }
        char[] chars = new char[10];
        Arrays.fill(chars, 0, chars.length, '-');
        int j = i;
        while (i < this.names.length) {
            joiner.add(this.names[i]);
            int n = this.simpleTestLength(this.names[i]) + (j == i || i == this.names.length - 1 ? 1 : 2);
            if (n > chars.length) {
                chars = new char[n];
            }
            Arrays.fill(chars, 0, n, '-');
            if (this.columns != null && i < this.columns.length && this.columns[i].clazz != RowNum.class) {
                Class c = this.columns[i].clazz;
                if (IWorksheetWriter.isDate(c) || IWorksheetWriter.isLocalDate(c) || IWorksheetWriter.isLocalDateTime(c) || IWorksheetWriter.isLocalTime(c) || IWorksheetWriter.isChar(c) || IWorksheetWriter.isBool(c)) {
                    chars[n - 1] = 58;
                    chars[0] = 58;
                } else if (IWorksheetWriter.isInt(c)) {
                    chars[n - 1] = 58;
                }
            }
            buf.append(chars, 0, n).append('|');
            ++i;
        }
        buf.insert(0, joiner.toString() + Const.lineSeparator);
        return buf.toString();
    }

    protected int simpleTestLength(String name) {
        if (name == null) {
            return 4;
        }
        char[] chars = name.toCharArray();
        double d = 0.0;
        for (char c : chars) {
            if (c < '\u0080') {
                d += 1.0;
                continue;
            }
            d += 1.75;
        }
        return (int)d;
    }

    void put(Row row, Object t) throws IllegalAccessException, InvocationTargetException {
        int i;
        try {
            for (i = 0; i < this.columns.length; ++i) {
                if (this.columns[i].method != null) {
                    this.methodPut(i, row, t);
                    continue;
                }
                this.fieldPut(i, row, t);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw ex;
        }
        catch (NumberFormatException | DateTimeException ex) {
            ListSheet.EntryColumn c = this.columns[i];
            String msg = "The undecorated value of cell '" + new String(Sheet.int2Col(c.colIndex + 1)) + row.getRowNum() + "' is \"" + row.getString(c.colIndex) + "\"(" + (Object)((Object)row.getCellType(c.colIndex)) + "), cannot cast to " + c.clazz;
            if (StringUtil.isNotEmpty(ex.getMessage())) {
                msg = msg + ". " + ex.getMessage();
            }
            if (detailMessageField != null) {
                detailMessageField.set(ex, msg);
                throw ex;
            }
            throw ex instanceof DateTimeException ? new DateTimeException(msg, ex) : new NumberFormatException(msg);
        }
        catch (NullPointerException ex) {
            String msg = "Null value in cell '" + new String(Sheet.int2Col(this.columns[i].colIndex + 1)) + row.getRowNum() + "'(" + (Object)((Object)row.getCellType(i)) + ')';
            if (StringUtil.isNotEmpty(ex.getMessage())) {
                msg = msg + ". " + ex.getMessage();
            }
            if (detailMessageField != null) {
                detailMessageField.set(ex, msg);
                throw ex;
            }
            throw new ExcelReadException(msg, ex);
        }
        catch (UncheckedTypeException ex) {
            ListSheet.EntryColumn c = this.columns[i];
            String msg = StringUtil.isNotEmpty(ex.getMessage()) ? "Error occur in cell '" + new String(Sheet.int2Col(c.colIndex + 1)) + row.getRowNum() + "'(" + (Object)((Object)row.getCellType(i)) + "). " + ex.getMessage() : "The undecorated value of cell '" + new String(Sheet.int2Col(c.colIndex + 1)) + row.getRowNum() + "' is \"" + row.getString(c.colIndex) + "\"(" + (Object)((Object)row.getCellType(c.colIndex)) + "), cannot cast to " + c.clazz;
            if (detailMessageField != null) {
                detailMessageField.set(ex, msg);
                throw ex;
            }
            throw new UncheckedTypeException(msg, ex);
        }
        catch (Exception ex) {
            ListSheet.EntryColumn c = this.columns[i];
            String msg = "Error occur in cell '" + new String(Sheet.int2Col(c.colIndex + 1)) + row.getRowNum() + "' value is \"" + row.getString(c.colIndex) + "\"(" + (Object)((Object)row.getCellType(c.colIndex)) + ')';
            if (StringUtil.isNotEmpty(ex.getMessage())) {
                msg = msg + ". " + ex.getMessage();
            }
            if (detailMessageField != null) {
                detailMessageField.set(ex, msg);
                throw ex;
            }
            throw new ExcelReadException(msg, ex);
        }
    }

    protected void fieldPut(int i, Row row, Object t) throws IllegalAccessException {
        ListSheet.EntryColumn ec = this.columns[i];
        int c = ec.colIndex;
        Class fieldClazz = ec.clazz;
        if (fieldClazz == String.class) {
            ec.field.set(t, row.getString(c));
        } else if (fieldClazz == Integer.class) {
            ec.field.set(t, row.getInt(c));
        } else if (fieldClazz == Long.class) {
            ec.field.set(t, row.getLong(c));
        } else if (fieldClazz == java.util.Date.class || fieldClazz == Date.class) {
            ec.field.set(t, row.getDate(c));
        } else if (fieldClazz == Timestamp.class) {
            ec.field.set(t, row.getTimestamp(c));
        } else if (fieldClazz == Double.class) {
            ec.field.set(t, row.getDouble(c));
        } else if (fieldClazz == Float.class) {
            ec.field.set(t, row.getFloat(c));
        } else if (fieldClazz == Boolean.class) {
            ec.field.set(t, row.getBoolean(c));
        } else if (fieldClazz == BigDecimal.class) {
            ec.field.set(t, row.getDecimal(c));
        } else if (fieldClazz == Integer.TYPE) {
            Integer v = row.getInt(c);
            ec.field.set(t, v != null ? v : 0);
        } else if (fieldClazz == Long.TYPE) {
            Long v = row.getLong(c);
            ec.field.set(t, v != null ? v : 0L);
        } else if (fieldClazz == Double.TYPE) {
            Double v = row.getDouble(c);
            ec.field.set(t, v != null ? v : 0.0);
        } else if (fieldClazz == Float.TYPE) {
            Float v = row.getFloat(c);
            ec.field.set(t, Float.valueOf(v != null ? v.floatValue() : 0.0f));
        } else if (fieldClazz == Boolean.TYPE) {
            Boolean v = row.getBoolean(c);
            ec.field.set(t, v != null ? v : false);
        } else if (fieldClazz == Time.class) {
            ec.field.set(t, row.getTime(c));
        } else if (fieldClazz == LocalDateTime.class) {
            ec.field.set(t, row.getLocalDateTime(c));
        } else if (fieldClazz == LocalDate.class) {
            ec.field.set(t, row.getLocalDate(c));
        } else if (fieldClazz == LocalTime.class) {
            ec.field.set(t, row.getLocalTime(c));
        } else if (fieldClazz == Character.class) {
            ec.field.set(t, row.getChar(c));
        } else if (fieldClazz == Byte.class) {
            ec.field.set(t, row.getByte(c));
        } else if (fieldClazz == Short.class) {
            ec.field.set(t, row.getShort(c));
        } else if (fieldClazz == Character.TYPE) {
            Character v = row.getChar(c);
            ec.field.set(t, Character.valueOf(v != null ? v.charValue() : (char)'\u0000'));
        } else if (fieldClazz == Byte.TYPE) {
            Byte v = row.getByte(c);
            ec.field.set(t, v != null ? v : (byte)0);
        } else if (fieldClazz == Short.TYPE) {
            Short v = row.getShort(c);
            ec.field.set(t, v != null ? v : (short)0);
        } else if (fieldClazz == RowNum.class) {
            ec.field.set(t, row.getRowNum());
        }
    }

    protected void methodPut(int i, Row row, Object t) throws IllegalAccessException, InvocationTargetException {
        ListSheet.EntryColumn ec = this.columns[i];
        int c = ec.colIndex;
        Class fieldClazz = ec.clazz;
        if (fieldClazz == String.class) {
            ec.method.invoke(t, row.getString(c));
        } else if (fieldClazz == Integer.class) {
            ec.method.invoke(t, row.getInt(c));
        } else if (fieldClazz == Long.class) {
            ec.method.invoke(t, row.getLong(c));
        } else if (fieldClazz == java.util.Date.class || fieldClazz == Date.class) {
            ec.method.invoke(t, row.getDate(c));
        } else if (fieldClazz == Timestamp.class) {
            ec.method.invoke(t, row.getTimestamp(c));
        } else if (fieldClazz == Double.class) {
            ec.method.invoke(t, row.getDouble(c));
        } else if (fieldClazz == Float.class) {
            ec.method.invoke(t, row.getFloat(c));
        } else if (fieldClazz == Boolean.class) {
            ec.method.invoke(t, row.getBoolean(c));
        } else if (fieldClazz == BigDecimal.class) {
            ec.method.invoke(t, row.getDecimal(c));
        } else if (fieldClazz == Integer.TYPE) {
            Integer v = row.getInt(c);
            ec.method.invoke(t, v != null ? v : 0);
        } else if (fieldClazz == Long.TYPE) {
            Long v = row.getLong(c);
            ec.method.invoke(t, v != null ? v : 0L);
        } else if (fieldClazz == Double.TYPE) {
            Double v = row.getDouble(c);
            ec.method.invoke(t, v != null ? v : 0.0);
        } else if (fieldClazz == Float.TYPE) {
            Float v = row.getFloat(c);
            ec.method.invoke(t, Float.valueOf(v != null ? v.floatValue() : 0.0f));
        } else if (fieldClazz == Boolean.TYPE) {
            Boolean v = row.getBoolean(c);
            ec.method.invoke(t, v != null ? v : false);
        } else if (fieldClazz == Time.class) {
            ec.method.invoke(t, row.getTime(c));
        } else if (fieldClazz == LocalDateTime.class) {
            ec.method.invoke(t, row.getLocalDateTime(c));
        } else if (fieldClazz == LocalDate.class) {
            ec.method.invoke(t, row.getLocalDate(c));
        } else if (fieldClazz == LocalTime.class) {
            ec.method.invoke(t, row.getLocalTime(c));
        } else if (fieldClazz == Character.class) {
            ec.method.invoke(t, row.getChar(c));
        } else if (fieldClazz == Byte.class) {
            ec.method.invoke(t, row.getByte(c));
        } else if (fieldClazz == Short.class) {
            ec.method.invoke(t, row.getShort(c));
        } else if (fieldClazz == Character.TYPE) {
            Character v = row.getChar(c);
            ec.method.invoke(t, Character.valueOf(v != null ? v.charValue() : (char)'\u0000'));
        } else if (fieldClazz == Byte.TYPE) {
            Byte v = row.getByte(c);
            ec.method.invoke(t, v != null ? v : (byte)0);
        } else if (fieldClazz == Short.TYPE) {
            Short v = row.getShort(c);
            ec.method.invoke(t, v != null ? v : (short)0);
        } else if (fieldClazz == RowNum.class) {
            ec.method.invoke(t, row.getRowNum());
        }
    }

    protected boolean ignoreColumn(AccessibleObject ao) {
        return ao.getAnnotation(IgnoreImport.class) != null;
    }

    protected Map<String, Method> attachOtherColumn(Class<?> clazz) {
        Method[] writeMethods;
        try {
            writeMethods = ReflectUtil.listDeclaredMethods(clazz, method -> method.getAnnotation(ExcelColumn.class) != null || method.getAnnotation(RowNum.class) != null);
        }
        catch (IntrospectionException e) {
            this.LOGGER.warn("Get [" + clazz + "] read declared failed.", (Throwable)e);
            return Collections.emptyMap();
        }
        return Arrays.stream(writeMethods).filter(m -> m.getParameterCount() == 1).collect(Collectors.toMap(Method::getName, a -> a, (a, b) -> b));
    }

    protected ListSheet.EntryColumn createColumn(AccessibleObject ao) {
        if (this.ignoreColumn(ao)) {
            return null;
        }
        ao.setAccessible(true);
        ExcelColumns cs = ao.getAnnotation(ExcelColumns.class);
        if (cs != null) {
            ExcelColumn[] ecs = cs.value();
            ListSheet.EntryColumn root = null;
            for (int i = Math.max(0, ecs.length - this.headRows); i < ecs.length; ++i) {
                ListSheet.EntryColumn column = this.createColumnByAnnotation(ecs[i]);
                if (root == null) {
                    root = column;
                    continue;
                }
                root.addSubColumn(column);
            }
            return root;
        }
        ExcelColumn ec = ao.getAnnotation(ExcelColumn.class);
        if (ec != null) {
            return this.createColumnByAnnotation(ec);
        }
        RowNum rowNum = ao.getAnnotation(RowNum.class);
        if (rowNum != null) {
            return this.createColumnByAnnotation(rowNum);
        }
        return null;
    }

    protected ListSheet.EntryColumn createColumnByAnnotation(Annotation anno) {
        ListSheet.EntryColumn column = null;
        if (anno instanceof ExcelColumn) {
            ExcelColumn ec = (ExcelColumn)anno;
            column = new ListSheet.EntryColumn(ec.value());
            column.setColIndex(ec.colIndex());
            if (ec.hide()) {
                column.hide();
            }
        } else if (anno instanceof RowNum) {
            column = new ListSheet.EntryColumn("", RowNum.class);
        }
        return column;
    }

    protected void mergeCellsIfNull(List<Dimension> mergeCells, Row[] rows) {
        if (mergeCells == null) {
            return;
        }
        if ((mergeCells = mergeCells.stream().filter(d -> d.getWidth() > 1).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        Map<Long, Dimension> map = mergeCells.stream().collect(Collectors.toMap(a -> (long)a.firstRow << 16 | (long)a.firstColumn, a -> a, (a, b) -> a));
        for (Row row : rows) {
            int i = row.fc;
            while (i < row.lc) {
                Cell cell = row.cells[i];
                Dimension d2 = map.get((long)row.getRowNum() << 16 | (long)cell.i);
                if (d2 != null) {
                    String v = row.getString(cell);
                    if (d2.lastColumn > row.lc) {
                        row.cells = row.copyCells(d2.lastColumn);
                        row.lc = d2.lastColumn;
                    }
                    for (int j = d2.firstColumn + 1; j <= d2.lastColumn; ++j) {
                        row.cells[++i].setSv(v);
                    }
                    continue;
                }
                ++i;
            }
        }
    }

    static {
        Field field = null;
        try {
            field = Throwable.class.getDeclaredField("detailMessage");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        detailMessageField = field;
    }
}

