/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Drawings;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.reader.XMLSheet;
import org.ttzero.excel.util.FileUtil;

public class XMLDrawings
implements Drawings {
    private final ExcelReader excelReader;
    private List<Drawings.Picture> pictures;
    private boolean parsed;

    public XMLDrawings(ExcelReader reader) {
        this.excelReader = reader;
    }

    @Override
    public List<Drawings.Picture> listPictures() {
        return this.parsed ? this.pictures : this.parse();
    }

    protected List<Drawings.Picture> parse() {
        List<Drawings.Picture> list;
        this.parsed = true;
        if (this.excelReader.sheets == null) {
            return null;
        }
        SAXReader reader = SAXReader.createDefault();
        ArrayList<Drawings.Picture> pictures = new ArrayList<Drawings.Picture>();
        for (Sheet sheet : this.excelReader.sheets) {
            Document document;
            XMLSheet xmlSheet = (XMLSheet)sheet;
            Path relsPath = xmlSheet.path.getParent().resolve("_rels/" + xmlSheet.path.getFileName() + ".rels");
            if (!Files.exists(relsPath, new LinkOption[0])) continue;
            try {
                document = reader.read(Files.newInputStream(relsPath, new OpenOption[0]));
            }
            catch (IOException | DocumentException e) {
                FileUtil.rm_rf(this.excelReader.self.toFile(), true);
                throw new ExcelReadException("The file format is incorrect or corrupted. [/xl/worksheets/_rels/" + xmlSheet.path.getFileName() + ".rels]");
            }
            List list2 = document.getRootElement().elements();
            for (Element e : list2) {
                Path drawingsPath;
                List<Drawings.Picture> subPictures;
                String target = e.attributeValue("Target");
                String type = e.attributeValue("Type");
                if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image".equals(type)) {
                    Drawings.Picture picture = new Drawings.Picture();
                    pictures.add(picture);
                    picture.sheet = sheet;
                    picture.background = true;
                    picture.localPath = xmlSheet.path.getParent().resolve(target);
                    continue;
                }
                if (!"http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing".equals(type) || (subPictures = this.parseDrawings(drawingsPath = xmlSheet.path.getParent().resolve(target))) == null) continue;
                for (Drawings.Picture picture : subPictures) {
                    picture.sheet = sheet;
                    pictures.add(picture);
                }
            }
        }
        if (!pictures.isEmpty()) {
            this.pictures = pictures;
            list = this.pictures;
        } else {
            list = null;
        }
        return list;
    }

    protected List<Drawings.Picture> parseDrawings(Path path) {
        Document document;
        SAXReader reader = SAXReader.createDefault();
        try {
            document = reader.read(Files.newInputStream(path.getParent().resolve("_rels/" + path.getFileName() + ".rels"), new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            FileUtil.rm_rf(this.excelReader.self.toFile(), true);
            throw new ExcelReadException("The file format is incorrect or corrupted. [/xl/drawings/_rels/" + path.getFileName() + ".rels]");
        }
        List list = document.getRootElement().elements();
        Relationship[] rels = new Relationship[list.size()];
        int i = 0;
        for (Element e : list) {
            rels[i++] = new Relationship(e.attributeValue("Id"), e.attributeValue("Target"), e.attributeValue("Type"));
        }
        RelManager relManager = RelManager.of(rels);
        try {
            document = reader.read(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            FileUtil.rm_rf(this.excelReader.self.toFile(), true);
            throw new ExcelReadException("The file format is incorrect or corrupted. [/xl/drawings/" + path.getFileName() + "]");
        }
        Element root = document.getRootElement();
        Namespace xdr = root.getNamespaceForPrefix("xdr");
        Namespace a = root.getNamespaceForPrefix("a");
        List elements = root.elements();
        ArrayList<Drawings.Picture> pictures = new ArrayList<Drawings.Picture>(elements.size());
        for (Element e : root.elements()) {
            Element blip;
            Element blipFill;
            Element pic = e.element(QName.get((String)"pic", (Namespace)xdr));
            if (pic == null || (blipFill = pic.element(QName.get((String)"blipFill", (Namespace)xdr))) == null || (blip = blipFill.element(QName.get((String)"blip", (Namespace)a))) == null) continue;
            Namespace r = blip.getNamespaceForPrefix("r");
            String embed = blip.attributeValue(QName.get((String)"embed", (Namespace)r));
            Relationship rel = relManager.getById(embed);
            if (r == null || !"http://schemas.openxmlformats.org/officeDocument/2006/relationships/image".equals(rel.getType())) continue;
            Drawings.Picture picture = new Drawings.Picture();
            pictures.add(picture);
            picture.localPath = path.getParent().resolve(rel.getTarget());
            picture.dimension = this.dimension(e, xdr);
            Element extLst = blip.element(QName.get((String)"extLst", (Namespace)a));
            if (extLst == null) continue;
            for (Element ext : extLst.elements()) {
                Element srcUrl = ext.element("picAttrSrcUrl");
                if (srcUrl == null || (rel = relManager.getById(srcUrl.attributeValue(QName.get((String)"id", (Namespace)r)))) == null || !"http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink".equals(rel.getType())) continue;
                picture.srcUrl = rel.getTarget();
            }
        }
        return !pictures.isEmpty() ? pictures : null;
    }

    protected Dimension dimension(Element e, Namespace xdr) {
        Element fromEle = e.element(QName.get((String)"from", (Namespace)xdr));
        int[] f = this.dimEle(fromEle, xdr);
        Element toEle = e.element(QName.get((String)"to", (Namespace)xdr));
        int[] t = this.dimEle(toEle, xdr);
        return new Dimension(f[0] + 1, (short)(f[1] + 1), t[0] + 1, (short)(t[1] + 1));
    }

    protected int[] dimEle(Element e, Namespace xdr) {
        int c = 0;
        int r = 0;
        if (e != null) {
            String col = e.element(QName.get((String)"col", (Namespace)xdr)).getText();
            String row = e.element(QName.get((String)"row", (Namespace)xdr)).getText();
            c = Integer.parseInt(col);
            r = Integer.parseInt(row);
        }
        return new int[]{r, c};
    }

    public List<Drawings.Picture> getPictures() {
        return this.pictures;
    }

    public void setPictures(List<Drawings.Picture> pictures) {
        this.pictures = pictures;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }
}

