/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.util.ExtXMLWriter;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOGGER.error("Close stream fail.", (Throwable)e);
            }
        }
    }

    public static void rm(Path path) {
        FileUtil.rm(path.toFile());
    }

    public static void rm(File file) {
        boolean boo;
        if (file.exists() && !(boo = file.delete())) {
            LOGGER.error("Delete file [{}] fail.", (Object)file.getPath());
        }
    }

    public static void rm_rf(Path root) {
        FileUtil.rm_rf(root.toFile(), true);
    }

    public static void rm_rf(File root, boolean rmSelf) {
        File temp = root;
        if (root.isDirectory()) {
            File[] subFiles = root.listFiles();
            if (subFiles == null) {
                return;
            }
            ArrayList<File> files = new ArrayList<File>();
            int index = 0;
            do {
                files.addAll(Arrays.asList(subFiles));
                while (index < files.size()) {
                    if (((File)files.get(index)).isDirectory() && (subFiles = (root = (File)files.get(index)).listFiles()) != null) {
                        files.addAll(Arrays.asList(subFiles));
                    }
                    ++index;
                }
            } while (index < files.size());
            while (--index >= 0) {
                FileUtil.rm((File)files.get(index));
            }
        }
        if (rmSelf) {
            FileUtil.rm(temp);
        }
    }

    public static void cp(Path srcPath, File descFile) {
        FileUtil.cp(srcPath.toFile(), descFile);
    }

    public static void cp(File srcFile, File descFile) {
        if (srcFile.length() == 0L) {
            try {
                boolean boo = descFile.createNewFile();
                if (!boo) {
                    LOGGER.error("Copy file from [{}] to [{}] failed...", (Object)srcFile.getPath(), (Object)descFile.getPath());
                }
                return;
            }
            catch (IOException boo) {
                // empty catch block
            }
        }
        try (FileChannel inChannel = new FileInputStream(srcFile).getChannel();
             FileChannel outChannel = new FileOutputStream(descFile).getChannel();){
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            LOGGER.error("Copy file from [{}] to [{}] failed...", (Object)srcFile.getPath(), (Object)descFile.getPath());
        }
    }

    public static void cp(InputStream is, Path descFile) {
        try {
            Files.copy(is, descFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Copy file to [{}] failed...", (Object)descFile);
        }
    }

    public static void cp_R(String srcPath, String descPath, boolean moveSubFolder) {
        FileUtil.copyFolder(srcPath, descPath, moveSubFolder);
    }

    public static void cp_R(Path srcPath, Path descPath, boolean moveSubFolder) {
        FileUtil.copyFolder(srcPath.toString(), descPath.toString(), moveSubFolder);
    }

    public static void cp_R(String srcPath, String descPath) {
        FileUtil.copyFolder(srcPath, descPath, true);
    }

    public static void cp_R(Path srcPath, Path descPath) {
        FileUtil.copyFolder(srcPath.toString(), descPath.toString(), true);
    }

    public static void copyFolder(String srcPath, String descPath, boolean moveSubFolder) {
        boolean boo;
        File src = new File(srcPath);
        File desc = new File(descPath);
        if (!src.exists() || !src.isDirectory()) {
            throw new RuntimeException("The source path [" + srcPath + "] not exists or not a directory.");
        }
        if (!desc.exists() && !(boo = desc.mkdirs())) {
            throw new RuntimeException("Create destination path [" + descPath + "] failed.");
        }
        String[] ss = src.list();
        if (ss == null) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        LinkedList<File> folders = new LinkedList<File>();
        for (String s : ss) {
            File f2 = new File(src, s);
            if (f2.isFile()) {
                files.add(f2);
                continue;
            }
            folders.push(f2);
        }
        ss = null;
        int src_path_len = srcPath.length();
        if (moveSubFolder && !folders.isEmpty()) {
            while (!folders.isEmpty()) {
                File f3 = (File)folders.pollLast();
                if (f3 == null) continue;
                File df = new File(desc, f3.getPath().substring(src_path_len));
                if (!df.exists() && !df.mkdir()) {
                    LOGGER.warn("Create sub-folder [{}] error skip it.", (Object)df.getPath());
                    continue;
                }
                File[] fs = f3.listFiles();
                if (fs == null) continue;
                for (File _f : fs) {
                    if (_f.isFile()) {
                        files.add(_f);
                        continue;
                    }
                    folders.push(_f);
                }
            }
        }
        LOGGER.debug("Finished Scan. There contains {} files. Ready to copy them...", (Object)files.size());
        files.parallelStream().forEach(f -> FileUtil.cp(f, new File(descPath + f.getPath().substring(src_path_len))));
        LOGGER.debug("Copy all files in path {} finished.", (Object)srcPath);
    }

    public static Path mkdir(Path destPath) throws IOException {
        Path path = FileUtil.isWindows() ? Files.createDirectories(destPath, new FileAttribute[0]) : Files.createDirectories(destPath, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-x---")));
        return path;
    }

    public static Path mktmp(String prefix) throws IOException {
        Path path = FileUtil.isWindows() ? Files.createTempDirectory(prefix, new FileAttribute[0]) : Files.createTempDirectory(prefix, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-x---")));
        return path;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
    }

    public static void writeToDisk(Document doc, Path path) throws IOException {
        if (!FileUtil.exists(path.getParent())) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try (FileOutputStream fos = new FileOutputStream(path.toFile());){
            OutputFormat format = OutputFormat.createPrettyPrint();
            ExtXMLWriter writer = new ExtXMLWriter(fos, format);
            writer.write(doc);
            writer.flush();
            writer.close();
        }
    }

    public static void writeToDiskNoFormat(Document doc, Path path) throws IOException {
        if (!FileUtil.exists(path.getParent())) {
            FileUtil.mkdir(path.getParent());
        }
        try (FileOutputStream fos = new FileOutputStream(path.toFile());){
            ExtXMLWriter writer = new ExtXMLWriter(fos);
            writer.write(doc);
            writer.flush();
            writer.close();
        }
    }

    public static boolean exists(Path path) {
        try {
            return Files.exists(path, new LinkOption[0]);
        }
        catch (SecurityException e) {
            LOGGER.warn("Check " + path, (Throwable)e);
            return false;
        }
    }
}

