package org.tuzhao.library.activity;

import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.view.View;

/**
 * <h3>Base Annotation AppCompat Activity</h3>
 * @author tuzhao
 *         2016-01-14
 */
public class BaseAnnotationCompatActivity extends MethodAppCompatActivity {

	private LocalBroadcastManager lbm;
	private View rootView;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		if (normal(savedInstanceState)) {
			lbm = LocalBroadcastManager.getInstance(this);
			rootView = findContentView(this);
			setContentView(rootView);
		}
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		cleanObject(rootView, lbm);
	}

	public boolean normal(Bundle savedInstanceState) {
		return true;
	}

	public View getRootView() {
		return rootView;
	}

	public LocalBroadcastManager getLbm() {
		if (lbm == null) {
			lbm = LocalBroadcastManager.getInstance(this);
		}
		return lbm;
	}

}
