package org.tuzhao.library.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.widget.BaseAdapter;

import org.tuzhao.library.debug.LogManager;
import org.tuzhao.library.tools.StringUtil;
import org.tuzhao.library.tools.TimeZoneUtil;

import java.util.List;

/**
 * @author tuzhao
 *         2016-1-6
 */
public abstract class CustomBaseAdapter<T> extends BaseAdapter {

	private Context mContext;
	private List<T> mDataList;
	private LayoutInflater mInflater;

	public CustomBaseAdapter(Context context) {
		this.mContext = context;
		mInflater = LayoutInflater.from(context);
	}

	public CustomBaseAdapter(Context context, List<T> dataList) {
		this.mContext = context;
		this.mDataList = dataList;
		mInflater = LayoutInflater.from(context);
	}

	@Override
	public int getCount() {
		return mDataList != null ? mDataList.size() : 0;
	}

	@Override
	public T getItem(int position) {
		if ((mDataList != null && mDataList.size() > 0)
			&& (position > 0 && position < mDataList.size())) {
			return mDataList.get(position);
		} else {
			return null;
		}
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	public List<T> getDataList() {
		return mDataList;
	}

	public void setDataList(List<T> mDataList) {
		this.mDataList = mDataList;
		notifyDataSetChanged();
	}

	public Context getContext() {
		return mContext;
	}

	public LayoutInflater getInflater() {
		return mInflater;
	}

	public String trans(String sourceTime) {
		return TimeZoneUtil.trans(sourceTime);
	}

	public String trans3(String sourceTime) {
		return TimeZoneUtil.trans3(sourceTime);
	}

	public String trans2(String sourceTime) {
		return TimeZoneUtil.trans2(sourceTime);
	}

	/**
	 * 将浮点数格式化为小数点后两位
	 * @param num double
	 * @return 保留两位小数的数字
	 */
	public String format(double num) {
		return StringUtil.formatPointTwo(num);
	}

	/**
	 * 获取中国时区当前的毫秒时间戳
	 * @return 中国时区当前的毫秒时间戳
	 */
	public long getChinaCurrentMils() {
		return TimeZoneUtil.getChinaCurrentMils();
	}

	/**
	 * 将浮点数格式化为整数
	 * @param num double
	 * @return 整数
	 */
	public String formatInteger(double num) {
		return StringUtil.formatInteger(num);
	}

	public void it(Object tag,Object msg){
		LogManager.getDefaultLogger().it(String.valueOf(tag),msg);
	}

	public void ie(Exception e) {
		LogManager.getDefaultLogger().e(this.getClass().getSimpleName(), e);
	}

}

